/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HikvisionIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.hikvision.HikvisionIOHandler";
    private HikvisionDevice hikvisionDevice;

    public HikvisionDevice getHikvisionDevice() {
        if (this.hikvisionDevice == null) {
            this.hikvisionDevice = (HikvisionDevice)this.device;
        }
        return this.hikvisionDevice;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            boolean closeConnection = false;
            for (int i = 0; i < iServices.length / 2; ++i) {
                int inputNumber = i + 1;
                StringBuilder sb = new StringBuilder();
                sb.append("<EventTrigger>");
                sb.append("<id>");
                sb.append(inputNumber);
                sb.append("</id>");
                sb.append("<eventType>IO</eventType>");
                sb.append("<eventDescription>IO Event is detected.</eventDescription>");
                sb.append("<inputIOPortID>");
                sb.append(inputNumber);
                sb.append("</inputIOPortID>");
                sb.append("<EventTriggerNotificationList>");
                sb.append("<EventTriggerNotification>");
                sb.append("<id>4</id>");
                sb.append("<notificationMethod>email</notificationMethod>");
                sb.append("<notificationRecurrence>beginning</notificationRecurrence>");
                sb.append("</EventTriggerNotification>");
                sb.append("</EventTriggerNotificationList>");
                sb.append("</EventTrigger>");
                String url = "/ISAPI/Event/triggers/IO-" + inputNumber;
                if (this.getHikvisionDevice().isCGIDevice()) {
                    url = "/Event/triggers/" + inputNumber;
                    closeConnection = true;
                }
                try {
                    this.getHikvisionDevice().getHttpHandler().readPutRequest(url, sb.toString());
                    continue;
                }
                catch (Exception ex) {
                    try {
                        this.getHikvisionDevice().getHttpHandler().readPutRequest(url.replace("IO-", ""), sb.toString());
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.warn("Exception while trying to activate inputs: " + e.getMessage());
                        this.logger.warn("Will continue anyway for " + this);
                    }
                }
            }
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs(closeConnection);
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] sb = iServices;
                        int n = sb.length;
                        for (int ex = 0; ex < n; ++ex) {
                            DigitalInputSrv iService = sb[ex];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException ex) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        for (DigitalInputSrv iService : iServices) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] ");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            StringBuilder url = this.getHikvisionDevice().isCGIDevice() ? new StringBuilder("/IO/outputs/") : new StringBuilder("/ISAPI/System/IO/outputs/");
            url.append(outputNumber);
            url.append("/trigger");
            StringBuilder xmlData = new StringBuilder("<IOPortData xmlns=\"http://www.hikvision.com/ver10/XMLSchema\"><outputState>");
            if (value == 0) {
                xmlData.append("low");
            } else {
                xmlData.append("high");
            }
            xmlData.append("</outputState></IOPortData>");
            this.getHikvisionDevice().getHttpHandler().readPutRequest(url.toString(), xmlData.toString());
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [ " + errorCode + " ] :-(");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while writing digital output for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    private int readDigitalInputs(boolean closeConnection) throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        HashMap<Integer, Boolean> tmpMap = new HashMap<Integer, Boolean>();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Reading digital inputs of " + this + " ...");
        }
        for (DigitalInputSrv iService : iServices) {
            if (iService.getServiceType() != 9801L) continue;
            String url = "/ISAPI/System/IO/inputs/" + iService.getInputNumber() + "/status";
            if (this.getHikvisionDevice().isCGIDevice()) {
                url = "/IO/inputs/" + iService.getInputNumber() + "/status";
            }
            String ioData = this.getHikvisionDevice().getHttpHandler().readGetRequest(url, closeConnection);
            String xmlString = ioData.substring(ioData.indexOf(">") + 1, ioData.lastIndexOf(">") + 1);
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            Document cameraConf = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            NodeList list = cameraConf.getElementsByTagName("ioState");
            if (list.getLength() == 0) {
                list = cameraConf.getElementsByTagName("ioStatus");
            }
            if (list.getLength() <= 0) continue;
            boolean active = list.item(0).getTextContent().equalsIgnoreCase("active");
            tmpMap.put(iService.getInputNumber(), active);
        }
        DigitalInputSrv[] digitalInputSrvArray = iServices;
        int n = digitalInputSrvArray.length;
        for (int i = 0; i < n; ++i) {
            DigitalInputSrv iService;
            int inputNumber = (iService = digitalInputSrvArray[i]).getInputNumber();
            Boolean active = (Boolean)tmpMap.get(inputNumber);
            iService.checkInput(active != null && active != false ? 1 : 0);
        }
        return 0;
    }
}

