/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.crypto.Crypto;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class HikvisionEncryption {
    private static final String MAGIC = "AaBbCcDd1234!@#$";

    public static String getMagic() {
        return MAGIC;
    }

    protected String getInitVector() {
        byte[] initVector = new byte[16];
        Random random = new Random();
        random.nextBytes(initVector);
        return Basic.byteArrayToHexString((byte[])initVector);
    }

    protected String encrypt(NetworkParameter networkParameter, String text, boolean isIrreversible, int numberOfIterations, String salt, String initVector) throws Exception {
        byte[] key = this.getEncryptKey(networkParameter.getUserPWD()[0], salt, networkParameter.getUserPWD()[1], numberOfIterations, isIrreversible);
        return Crypto.encryptAes128((String)initVector, (byte[])key, (String)text);
    }

    public String calcSha256(String user, byte[] salt, String password) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (salt.length > 64) {
            return null;
        }
        byte[] saltAsByteArray = new byte[64];
        System.arraycopy(salt, 0, saltAsByteArray, 0, salt.length);
        String dataToHash = user + new String(saltAsByteArray, "UTF-8") + password;
        return Crypto.sha256((String)dataToHash);
    }

    public byte[] getEncryptKey(String user, String salt, String password, int keyIterationNumber, boolean irreversible) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String irreversiblePasswordHash;
        String hashInputAndResult = irreversible && salt != null ? ((irreversiblePasswordHash = this.calcSha256(user, salt.getBytes("UTF-8"), password)).length() > 64 ? irreversiblePasswordHash.substring(0, 64) : irreversiblePasswordHash) : (password.length() > 64 ? password.substring(0, 64) : password);
        hashInputAndResult = hashInputAndResult.toLowerCase() + HikvisionEncryption.getMagic();
        int keyIterations = keyIterationNumber <= 0 ? 100 : keyIterationNumber;
        for (int i = 0; i < keyIterations; ++i) {
            hashInputAndResult = Crypto.sha256((String)hashInputAndResult);
        }
        byte[] hashResultAsByteArray = Basic.hexStringToByteArray((String)hashInputAndResult);
        if (hashResultAsByteArray.length > 32) {
            byte[] returnValue = new byte[32];
            System.arraycopy(hashResultAsByteArray, 0, returnValue, 0, 32);
            return returnValue;
        }
        byte[] returnValue = new byte[hashResultAsByteArray.length];
        System.arraycopy(hashResultAsByteArray, 0, returnValue, 0, hashResultAsByteArray.length);
        return returnValue;
    }
}

