/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.EdgeStoragePlaybackSpeedType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedEdgeStoragePlaybackSpeedsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VideoSourceType;
import de.seetec.v5.re.cm.configuration.definition.device.VideoSourcesDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.AttendedBaggage;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.AudioCap;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.AudioChannelList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.AudioDetection;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.BehaviorRule;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.CMSearchResult;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.DefocusDetection;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.DeviceCap;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.DeviceInfo;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.EventNotification;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.EventNotificationAlert;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.EventTrigger;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.EventTriggerList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.FaceDetect;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.FaceThermometry;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.FaceThermometryRegionList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.FieldDetection;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.IOInputPortList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.IOOutputPortList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.ImageChannel;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.ImageChannellist;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.LineDetection;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.MatchElement;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.PTZChanelCap;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.PTZChannel;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.RacmCap;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.RegionEntrance;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.RegionExiting;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.RuleInfo;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.SceneChangeDetection;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.StreamingChannel;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.StreamingChannelList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.TextOverlayList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.ThermometryRegion;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.ThermometryRegionList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.Time;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.UnattendedBaggage;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.VideoCap;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.VideoInput;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionCameraAdministration;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionEventReader;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionHelper;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionIOHandler;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionStreamId;
import de.seetec.v5.re.cm.device.video.hikvision.Track;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkHelperAdapter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class HikvisionDevice
extends VideoServer {
    private static final Lock LOCK = new ReentrantLock();
    private static volatile CameraAdministration cameraAdministration = null;
    private NetworkParameter networkParameter;
    private int streamSet;
    private String firmwareString = null;
    private String currentName;
    private HttpHandlerImpl httpHandler;
    private final Object SEMAPHORE = new Object();
    private Boolean isCGIDevice = null;
    private Integer numberOfVideoSources = null;
    private String deviceType = "";
    private LinkedList<EventNotificationAlert>[] alarmList;
    private HikvisionEventReader hikvisionEventReader;
    private final Semaphore semaphore = new Semaphore(1);
    private int activeEventClients = 0;
    private Long timeDiff = null;
    private boolean substreamResolutionAlreadySet;

    public static CameraAdministration getCameraAdministration() throws SeeTecException {
        if (cameraAdministration == null) {
            cameraAdministration = new HikvisionCameraAdministration((SeetecHttpClient)new NetworkHelperAdapter());
        }
        return cameraAdministration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpHandlerImpl getHttpHandler() {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            if (this.httpHandler == null) {
                try {
                    if (this.networkParameter == null) {
                        this.networkParameter = this.getDeviceCnf().getNetworkParameter();
                    }
                    this.httpHandler = new HttpHandlerImpl(this.networkParameter);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return this.httpHandler;
        }
    }

    @Override
    public int initializeDevice(long srvType) {
        int errorCode = super.initializeDevice(srvType);
        try {
            if (this.logger.isDebugEnabled()) {
                SupportedGenericEventsType genericEvents = this.getDeviceDefinitionFromConfiguration().getSupportedGenericEvents();
                List<GenericEventDefinitionType> eventList = genericEvents.getGenericEventDefinition();
                for (GenericEventDefinitionType g : eventList) {
                    this.logger.debug("Type: " + g.getEventType() + " Source: " + g.getSourceNumber());
                }
            }
            this.networkParameter = this.getDeviceCnf().getNetworkParameter();
            int numberOfSources = this.getNumberOfVideoSources() + 1;
            this.alarmList = new LinkedList[numberOfSources];
            for (int i = 0; i < numberOfSources; ++i) {
                this.alarmList[i] = new LinkedList();
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Exception while getting network parameters for " + this + " : " + ex.getMessage());
        }
        return errorCode;
    }

    public int getBiggestWidth(String[] resolutions) throws SeeTecException {
        int biggestWidth = 0;
        if (this.isCGIDevice()) {
            for (String resolution : resolutions) {
                try {
                    int width = Integer.parseInt(resolution.substring(0, resolution.indexOf("*")));
                    if (width <= biggestWidth) continue;
                    biggestWidth = width;
                }
                catch (Exception ex) {
                    throw new SeeTecException(-20001, "Wrong Syntax for Resolution. Expected '*' as separator. " + ex);
                }
            }
        } else {
            for (String resolution : resolutions) {
                try {
                    int width = Integer.parseInt(resolution);
                    if (width <= biggestWidth) continue;
                    biggestWidth = width;
                }
                catch (Exception ex) {
                    throw new SeeTecException(-20001, "Error while reading resolution " + resolution + " Error: " + ex);
                }
            }
        }
        return biggestWidth;
    }

    @Override
    public int shutdown() {
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
            this.httpHandler = null;
        }
        return super.shutdown();
    }

    public int getBiggestHeight(String[] resolutions, String[] resolutionHeights) throws SeeTecException {
        int biggestHeight;
        block7: {
            int biggestWidth;
            block6: {
                biggestHeight = 0;
                biggestWidth = 0;
                if (!this.isCGIDevice()) break block6;
                for (String resolution : resolutions) {
                    try {
                        int width = Integer.parseInt(resolution.substring(0, resolution.indexOf("*")));
                        int height = Integer.parseInt(resolution.substring(resolution.indexOf("*") + 1));
                        if (width <= biggestWidth) continue;
                        biggestWidth = width;
                        biggestHeight = height;
                    }
                    catch (Exception ex) {
                        throw new SeeTecException(-20001, "Error while reading resolution " + resolution + " Error: " + ex);
                    }
                }
                break block7;
            }
            if (resolutions.length != resolutionHeights.length) break block7;
            for (int i = 0; i < resolutions.length; ++i) {
                String resolution = resolutions[i];
                String resolutionHeight = resolutionHeights[i];
                try {
                    int width = Integer.parseInt(resolution);
                    int height = Integer.parseInt(resolutionHeight);
                    if (width <= biggestWidth) continue;
                    biggestWidth = width;
                    biggestHeight = height;
                    continue;
                }
                catch (Exception ex) {
                    throw new SeeTecException(-20001, "Wrong Syntax for Resolution. Expected '*' as separator. " + ex);
                }
            }
        }
        return biggestHeight;
    }

    public int getMaxFps(String[] fpsStrings) {
        int fps = 1;
        for (String fpsString : fpsStrings) {
            fps = Integer.parseInt(fpsString) > fps ? Integer.parseInt(fpsString) : fps;
        }
        return fps;
    }

    public int getStreamSet() {
        return this.streamSet;
    }

    public void setStreamSet(int streamSet) {
        this.streamSet = streamSet;
    }

    @Override
    public String getFirmwareVersion() {
        if (this.firmwareString != null) {
            return this.firmwareString;
        }
        try {
            String url = "/System/deviceInfo";
            String tempFirmwareString = this.getHttpHandler().readGetRequest(url, true);
            String xmlFirmwareString = tempFirmwareString.substring(tempFirmwareString.indexOf(">") + 1, tempFirmwareString.lastIndexOf(">") + 1);
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlFirmwareString.getBytes());
            Document deviceInfo = new SAXBuilder().build((InputStream)bais);
            Element root = deviceInfo.getRootElement();
            Namespace ns = root.getNamespace();
            Element firmware = root.getChild("firmwareVersion", ns);
            if (firmware != null) {
                this.firmwareString = firmware.getText().substring(1);
                this.logger.info("Firmware found on device is " + this.firmwareString);
                return this.firmwareString;
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading Firmware from " + this + " : " + ex.getMessage());
        }
        return "<unknown>";
    }

    public static boolean isSmartDriver(long entityType) {
        ArrayList<Long> entityTypes = new ArrayList<Long>();
        entityTypes.add(200436L);
        entityTypes.add(204429L);
        entityTypes.add(205900L);
        entityTypes.add(206000L);
        entityTypes.add(206100L);
        entityTypes.add(201117L);
        entityTypes.add(204190L);
        entityTypes.add(206300L);
        entityTypes.add(206700L);
        return entityTypes.contains(entityType);
    }

    public String getHikvisionDeviceType() {
        if (this.deviceType.isEmpty()) {
            try {
                DeviceInfo deviceInfo = this.getHikvisionObject(DeviceInfo.class, "/ISAPI/System/deviceInfo");
                if (deviceInfo != null) {
                    this.deviceType = deviceInfo.getDeviceDescription() != null ? deviceInfo.getDeviceDescription().getValue().toLowerCase() : deviceInfo.getDeviceType().getValue().toLowerCase();
                    this.logger.info("Device Type: " + this.deviceType + " for " + this);
                }
            }
            catch (Exception ex) {
                this.logger.warn("Exception while trying to read device Type for " + this + " : " + ex.getMessage());
            }
        }
        return this.deviceType;
    }

    protected void deliverEventMessage(EventNotificationAlert eventMessage) {
        int channelId = Integer.parseInt(eventMessage.getChannelID().getValue());
        this.alarmList[channelId].push(eventMessage);
    }

    protected EventNotificationAlert retrieveEventMessage(int sourceNumber) {
        EventNotificationAlert eventMessage = null;
        if (this.alarmList != null && this.alarmList[sourceNumber] != null) {
            try {
                eventMessage = this.alarmList[sourceNumber].pop();
            }
            catch (NoSuchElementException ex) {
                try {
                    eventMessage = this.alarmList[0].pop();
                }
                catch (NoSuchElementException e) {
                    eventMessage = null;
                }
            }
        }
        return eventMessage;
    }

    protected void startEventReader() {
        try {
            this.semaphore.acquire();
            if (this.hikvisionEventReader == null) {
                this.hikvisionEventReader = new HikvisionEventReader();
                this.hikvisionEventReader.init(this);
            }
            ++this.activeEventClients;
        }
        catch (Exception ex) {
            this.logger.error("Exception while starting event reader: " + ex.getMessage() + " for " + this);
        }
        finally {
            this.semaphore.release();
        }
    }

    protected void shutdownEventStream() {
        try {
            this.semaphore.acquire();
            if (this.activeEventClients > 0) {
                --this.activeEventClients;
            }
            if (this.activeEventClients == 0 && this.hikvisionEventReader != null) {
                this.hikvisionEventReader.shutdown();
                this.hikvisionEventReader = null;
            }
        }
        catch (InterruptedException ex) {
            this.logger.warn("Exception while handling event trigger shutdown: " + ex.getMessage() + " for " + this);
        }
        finally {
            this.semaphore.release();
        }
    }

    protected int getNumberOfActiveEventClients() {
        return this.activeEventClients;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new HikvisionIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() {
        SupportedGenericEventsType supportedGenericEventsType;
        try {
            int videoSources = this.getNumberOfVideoSourcesFromDevice();
            supportedGenericEventsType = this.isCGIDevice() ? HikvisionDevice.getCgiGenericEventTrigger(videoSources) : this.getIsapiGenericEventTrigger(videoSources);
        }
        catch (Exception e) {
            this.logger.fatal((Object)e, (Throwable)e);
            throw new RuntimeException();
        }
        return supportedGenericEventsType;
    }

    protected boolean isCGIDevice() throws SeeTecException {
        block8: {
            if (this.isCGIDevice != null) {
                this.networkParameter.setStartWithoutAuthentication(true);
                return this.isCGIDevice;
            }
            try {
                this.getHttpHandler().readGetRequest("/ISAPI/System/deviceInfo", true);
            }
            catch (SeeTecException ex) {
                if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                    this.httpHandler = null;
                    this.networkParameter.setStartWithoutAuthentication(true);
                    try {
                        this.getHttpHandler().readGetRequest("/ISAPI/System/deviceInfo", true);
                    }
                    catch (SeeTecException exception) {
                        if (exception.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                            throw new SeeTecException(-21657, "Problems while getting definition from device for " + this + " Unauthorized exception: Please check the credentials.");
                        }
                        break block8;
                    }
                }
                this.isCGIDevice = true;
                return true;
            }
            catch (Exception ex) {
                this.logger.warn("Could not check for CGI device. Reason: " + ex.getMessage());
                this.logger.warn("Will asume it is an ISAPI device for " + this);
            }
        }
        this.isCGIDevice = false;
        return false;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        block8: {
            try {
                DeviceInfo deviceInfo = this.getHikvisionObject(DeviceInfo.class, "/ISAPI/System/deviceInfo");
                if (deviceInfo != null) {
                    try {
                        String currentSignature = deviceInfo.getFirmwareVersion().getValue();
                        String currentManufacturerHikvision = "Hikvision Smart Driver";
                        String currentManufacturerWBox = "W Box Smart Driver";
                        String currentManufacturerNorthern = "Northern Smart Driver";
                        String currentManufacturerAllNet = "ALLNET Smart Driver (ALL-CAM23xx Series)";
                        String currentManufacturerInterlogix = "Interlogix Smart Driver";
                        String currentManufacturerConvision = "Convision Smart Driver (CC-7xxx Series)";
                        String currentManufacturerGrundig = "Grundig Smart Driver";
                        String currentManufacturerTKH = "TKH Security Solutions Smart Driver (10xx/11xx Series)";
                        this.currentName = deviceInfo.getModel().getValue();
                        String currentComments = "RE_APP_VERSION::7.4.1_11";
                        if (!(signature != null && signature.equals(currentSignature) && manufacturer != null && (manufacturer.equals(currentManufacturerHikvision) || manufacturer.equals(currentManufacturerWBox) || manufacturer.equals(currentManufacturerNorthern) || manufacturer.equals(currentManufacturerInterlogix) || manufacturer.equals(currentManufacturerAllNet) || manufacturer.equals(currentManufacturerConvision) || manufacturer.equals(currentManufacturerGrundig) || manufacturer.equals(currentManufacturerTKH)) && name != null && name.equals(this.currentName) && comments != null && comments.equals(currentComments))) {
                            DeviceDefinition deviceDefinition = new DeviceDefinition();
                            deviceDefinition.setCountFirstChannelOnly(true);
                            deviceDefinition.setSignature(currentSignature);
                            deviceDefinition.setManufacturer(currentManufacturerHikvision);
                            CommentsType commentsType = new CommentsType();
                            commentsType.getString().add(currentComments);
                            deviceDefinition.setComments(commentsType);
                            deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                            String apiVersion = "IP Media Device Management Protocol 1.0 (Rev. 5.4)";
                            SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                            supportedApiVersionsType.getString().add("IP Media Device Management Protocol 1.0 (Rev. 5.4)");
                            deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                            deviceDefinition.setDefaultApiVersion("IP Media Device Management Protocol 1.0 (Rev. 5.4)");
                            deviceDefinition.setNoOfCams(this.getNumberOfVideoSourcesFromDevice());
                            VirtualCameraDefinitionType virtualCameraDefinitionType = this.getVirtualCameraDefinitionType();
                            deviceDefinition.setVirtualCameraDefinition(virtualCameraDefinitionType);
                            DeviceNetworkDefinitionType deviceNetworkDefinitionType = this.getDeviceNetworkDefinitionType();
                            deviceDefinition.setDeviceNetworkDefinition(deviceNetworkDefinitionType);
                            StreamingChannel mainStream = this.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/101/capabilities");
                            if (mainStream == null) {
                                mainStream = this.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/1/capabilities");
                            }
                            SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
                            supportedCaptureModesType.getCaptureModeDefinition().add(this.getCaptureModeDefinitionType(mainStream, 1));
                            deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                            deviceDefinition.setDefaultCaptureModeIndex(0);
                            ImageRotationCapabilitiesType imageRotationCapabilitiesType = this.getImageRotationCapabilitiesType(mainStream);
                            deviceDefinition.setImageRotationCapabilities(imageRotationCapabilitiesType);
                            AudioCapabilitiesType audioCapabilitiesType = this.getAudioCapabilitiesType(mainStream);
                            deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                            AvailableIOsType availableIOsType = this.getAvailableIOsType();
                            deviceDefinition.setAvailableIOs(availableIOsType);
                            MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = this.getMiscVideoServerCapabilitiesType(1);
                            SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                            supportedVideoSourceEntityTypesType.getLong().add(210435L);
                            deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                            deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                            deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                            deviceDefinition.setDeviceGroupMemberships(this.getDeviceGroupMembershipsType(1));
                            if (this.supportsEdgeStorage()) {
                                deviceDefinition.setSupportedEdgeStoragePlaybackSpeeds(this.getSupportedEdgeStoragePlaybackSpeedsType());
                            }
                            deviceDefinition.setEntityType(200436L);
                            deviceDefinition.setName(this.currentName);
                            return deviceDefinition;
                        }
                        break block8;
                    }
                    catch (Throwable exception) {
                        this.logger.warn("Error while reading information from " + this + ": " + exception.getMessage(), exception);
                        throw new SeeTecException(-21600, exception.getMessage());
                    }
                }
                this.logger.error("Could not read definitions from device for " + this);
            }
            catch (JAXBException | SAXException ex) {
                this.logger.error("Problems while getting definition from device for " + this, ex);
            }
        }
        return null;
    }

    protected DeviceGroupMembershipsType getDeviceGroupMembershipsType(int channel) throws SeeTecException {
        DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
        deviceGroupMembershipsType.getDeviceGroups().add("ShowChannelSelector");
        deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
        deviceGroupMembershipsType.getDeviceGroups().add("PresetsImportable");
        deviceGroupMembershipsType.getDeviceGroups().add("DeviceMulticastConfiguration");
        deviceGroupMembershipsType.getDeviceGroups().add("ConfigurableVideoStreamNetworkTimeout");
        if (this.supportsEdgeStorage()) {
            deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorage");
            deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorageVideoImport");
        }
        if (!this.isCGIDevice()) {
            try {
                PTZChanelCap ptzList = this.getHikvisionObject(PTZChanelCap.class, "/ISAPI/PTZCtrl/channels/" + channel + "/capabilities", "/PTZ/channels/" + channel);
                if (ptzList != null && ptzList.getIsSupportPosition3D().isValue()) {
                    deviceGroupMembershipsType.getDeviceGroups().add("OpticalZoomAreaSupported");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            deviceGroupMembershipsType.getDeviceGroups().add("CameraAdministrationUpgradeFirmware");
            deviceGroupMembershipsType.getDeviceGroups().add("CameraAdministrationModifyPassword");
        }
        deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
        return deviceGroupMembershipsType;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        try {
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer("Generic Hikvision Driver");
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(MediaID.VIDEO_SOURCE_PTZ.getType());
            videoCameraDefinition.setName(this.currentName);
            videoCameraDefinition.setEntityType(210435L);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = this.getFeaturesType(1);
            videoCameraDefinition.setFeatures(featuresType);
            return videoCameraDefinition;
        }
        catch (Exception exception) {
            this.logger.warn("Error while reading information from " + this, (Throwable)exception);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    protected FeaturesType getFeaturesType(int channel) {
        FeaturesType featuresType = new FeaturesType();
        PTZChanelCap ptzChanelCap = null;
        try {
            ptzChanelCap = this.getHikvisionObject(PTZChanelCap.class, "/ISAPI/PTZCtrl/channels/" + channel + "/capabilities", "");
        }
        catch (Exception ex) {
            this.logger.warn("Could not read all PTZ capabilities for " + this + " PTZ might still be working");
        }
        try {
            PTZChannel ptzChannel = this.getHikvisionObject(PTZChannel.class, "/ISAPI/PTZCtrl/channels/" + channel, "/PTZ/channels/" + channel);
            featuresType = this.getPTZfeaturesType(this.isCGIDevice(), ptzChannel);
        }
        catch (Exception ex) {
            this.logger.warn("Exception while trying to get PTZ channel for " + this + " : ex: " + ex.getMessage());
        }
        if (ptzChanelCap != null && ptzChanelCap.getAbsoluteZoomPositionSpace() != null) {
            PTZChanelCap.AbsoluteZoomPositionSpace.ZRange zoomRange = ptzChanelCap.getAbsoluteZoomPositionSpace().getZRange();
            BigDecimal maxZoom = zoomRange.getMax();
            featuresType.setCanAbsoluteZoom(true);
            featuresType.setMinAbsoluteZoom(0);
            featuresType.setMaxAbsoluteZoom(maxZoom == null ? 0 : maxZoom.intValue());
            featuresType.setCanAbsolutePan(false);
            featuresType.setMinPan(0);
            featuresType.setMaxPan(0);
            featuresType.setCanAbsoluteTilt(false);
            featuresType.setMinTilt(0);
            featuresType.setMaxTilt(0);
        }
        featuresType.setCanPreset(true);
        return featuresType;
    }

    @Override
    protected VideoSourcesDefinitionType getVideoSourcesDefinitionFromDevice(int totalSources) throws SeeTecException {
        VideoSourcesDefinitionType videoSourcesDefinitionType = new VideoSourcesDefinitionType();
        try {
            List<VideoSourceType> sourceDefinitionList = videoSourcesDefinitionType.getVideoSource();
            for (int i = 0; i < totalSources; ++i) {
                StreamingChannel streamingChannel;
                VideoSourceType videoSource = new VideoSourceType();
                videoSource.setVideoSourceEnabled(true);
                boolean ptzEnabled = true;
                if (ptzEnabled) {
                    videoSource.setPtzCapabilities(this.convertFeatureTypeToPtzCapabilitiesType(this.getFeaturesType(i + 1)));
                }
                if ((streamingChannel = this.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/" + (i + 1) + "01/capabilities")) == null) {
                    streamingChannel = this.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/" + (i + 1) + "/capabilities");
                }
                videoSource.setAudioCapabilities(this.getAudioCapabilitiesType(streamingChannel));
                videoSource.setImageRotation(this.getImageRotationCapabilitiesType(streamingChannel));
                videoSource.setMiscVideoServerCapabilities(this.getMiscVideoServerCapabilitiesType(i + 1));
                videoSource.setDeviceGroupMemberships(this.getDeviceGroupMembershipsType(i + 1));
                videoSource.setSupportedEdgeStoragePlaybackSpeeds(this.getSupportedEdgeStoragePlaybackSpeedsType());
                videoSource.setCaptureMode(this.getCaptureModeDefinitionType(streamingChannel, i + 1));
                sourceDefinitionList.add(videoSource);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Couldn't read view capabilities for " + this);
            throw new SeeTecException(-21600, ex.getMessage());
        }
        return videoSourcesDefinitionType;
    }

    protected <T> T getHikvisionObject(Class<T> clazz, String url) throws SAXException, JAXBException, SeeTecException {
        return this.getHikvisionObject(clazz, url, null);
    }

    protected <T> T getHikvisionObject(Class<T> clazz, String url1, String url2) throws SAXException, JAXBException, SeeTecException {
        byte[] result = null;
        try {
            result = this.getHttpHandler().readGetRequest(url1, true).getBytes();
        }
        catch (SeeTecException ex) {
            try {
                if (url2 == null) {
                    url2 = url1.replace("/ISAPI", "");
                }
                this.httpHandler = null;
                result = this.getHttpHandler().readGetRequest(url2, true).getBytes();
            }
            catch (SeeTecException exception) {
                if (exception.getNetworkStatus() == HTTPStatusCode.HTTP_FORBIDDEN || exception.getNetworkStatus() == HTTPStatusCode.HTTP_METHOD_NOT_ALLOWED) {
                    throw new SeeTecException(-21657, "Error while trying to get Device Info", ex.getNetworkStatus());
                }
                this.logger.warn("Could not read camera configuration. Reason: " + exception.getMessage());
            }
            catch (Exception e) {
                this.logger.warn("Could not read camera configuration. Reason: " + e.getMessage());
            }
        }
        return this.unmarshalHikvisionObject(clazz, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T unmarshalHikvisionObject(Class<T> clazz, byte[] result) throws SAXException, JAXBException, SeeTecException {
        String responseFromCamera;
        int indexOfHeaderEnd;
        if (result != null && result.length > 0 && (indexOfHeaderEnd = (responseFromCamera = new String(result)).indexOf("<")) != -1) {
            responseFromCamera = responseFromCamera.substring(indexOfHeaderEnd);
            responseFromCamera = responseFromCamera.replace("http://www.hikvision.com/ver20/mmmm/XMLSchema", "http://www.isapi.org/ver20/XMLSchema");
            responseFromCamera = responseFromCamera.replace("http://www.hikvision.com/ver10/XMLSchema", "http://www.isapi.org/ver20/XMLSchema");
            responseFromCamera = responseFromCamera.replace("http://www.hikvision.com/ver20/XMLSchema", "http://www.isapi.org/ver20/XMLSchema");
            responseFromCamera = responseFromCamera.replace("http://www.std-cgi.com/ver10/XMLSchema", "http://www.isapi.org/ver20/XMLSchema");
            responseFromCamera = responseFromCamera.replace("http://www.std-cgi.com/ver20/XMLSchema", "http://www.isapi.org/ver20/XMLSchema");
            responseFromCamera = responseFromCamera.replace("http://www.isapi.org/ver10/XMLSchema", "http://www.isapi.org/ver20/XMLSchema");
            responseFromCamera = responseFromCamera.replace("urn:psialliance-org", "http://www.isapi.org/ver20/XMLSchema");
            try {
                Object listOfAllAttributes;
                LOCK.lock();
                Object object = listOfAllAttributes = Basic.unmarshalXML(clazz, (Object)responseFromCamera, (boolean)false);
                return (T)object;
            }
            finally {
                LOCK.unlock();
            }
        }
        return null;
    }

    protected int readNumberOfVideoSourcesFromDevice() throws SAXException, JAXBException, SeeTecException {
        if (this.isCGIDevice()) {
            ImageChannellist imageChannellist = this.getHikvisionObject(ImageChannellist.class, "/Image/channels");
            if (imageChannellist != null) {
                return imageChannellist.getImageChannel().size();
            }
        } else {
            VideoInput videoInput = this.getHikvisionObject(VideoInput.class, "/ISAPI/System/Video/inputs/");
            if (videoInput != null) {
                return videoInput.getVideoInputChannelList().get(0).getVideoInputChannel().size();
            }
        }
        return 1;
    }

    protected int getNumberOfVideoSourcesFromDevice() throws SAXException, JAXBException, SeeTecException {
        if (this.numberOfVideoSources == null) {
            this.numberOfVideoSources = this.readNumberOfVideoSourcesFromDevice();
        }
        return this.numberOfVideoSources;
    }

    void resetHttpHandler() {
        this.httpHandler = null;
    }

    private static SupportedGenericEventsType getCgiGenericEventTrigger(int videoSources) {
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        ArrayList<String> eventList = new ArrayList<String>();
        eventList.add("tamperdetection");
        eventList.add("VMD");
        eventList.add("videoloss");
        for (int i = 0; i < videoSources; ++i) {
            for (String event : eventList) {
                GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(event);
                genericEventDefinitionType.setSourceNumber(i + 1);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
        }
        return supportedGenericEventsType;
    }

    private void setResolution(int width, int height, int stream, Codec codec, int channelNumber) throws SeeTecException, SAXException, JAXBException {
        String url = "/ISAPI/Streaming/channels/" + channelNumber + "0" + stream;
        if (this.isCGIDevice()) {
            url = this.getNumberOfVideoSourcesFromDevice() <= 1 && this.deviceType.toLowerCase().contains("ip") ? "/Streaming/channels/" + stream : "/PSIA/Streaming/channels/" + channelNumber + "0" + stream;
        }
        String codecString = "";
        if (null != codec) {
            switch (codec) {
                case H264: {
                    codecString = "H.264";
                    break;
                }
                case MJPEG: {
                    codecString = "MJPEG";
                    break;
                }
                case H265: {
                    codecString = "H.265";
                    break;
                }
            }
        }
        String currentConfiguration = this.getHttpHandler().readGetRequest(url);
        StringBuilder sb = new StringBuilder("<StreamingChannel version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
        sb.append("<id>").append(channelNumber).append("0").append(stream).append("</id>");
        sb.append("<channelName></channelName>");
        sb.append("<enabled>true</enabled>");
        sb.append("<Transport>");
        sb.append("<ControlProtocolList>");
        sb.append("<ControlProtocol>");
        sb.append("<streamingTransport>RTSP</streamingTransport>");
        sb.append("</ControlProtocol>");
        sb.append("</ControlProtocolList>");
        if (currentConfiguration.contains("<SecurityAlgorithm")) {
            sb.append("<Security>");
            sb.append("<enabled>true</enabled>");
            sb.append("<certificateType>digest</certificateType>");
            sb.append("<SecurityAlgorithm>");
            sb.append("<algorithmType>MD5</algorithmType>");
            sb.append("</SecurityAlgorithm>");
            sb.append("</Security>");
        }
        sb.append("</Transport>");
        sb.append("<Video>");
        sb.append("<enabled>true</enabled>");
        sb.append("<videoInputChannelID>1</videoInputChannelID>");
        sb.append("<videoCodecType>").append(codecString).append("</videoCodecType>");
        sb.append("<videoResolutionWidth>").append(width).append("</videoResolutionWidth>");
        sb.append("<videoResolutionHeight>").append(height).append("</videoResolutionHeight>");
        sb.append("<videoQualityControlType>vbr</videoQualityControlType>");
        sb.append("<videoScanType>progressive</videoScanType>");
        sb.append("<maxFrameRate>100</maxFrameRate>");
        sb.append("</Video>");
        sb.append("</StreamingChannel>");
        try {
            this.getHttpHandler().readPutRequest(url, sb.toString(), true);
        }
        catch (Exception ex) {
            try {
                String alternativXmlConfiguration = this.getAlternativeConfiguration(sb.toString(), stream);
                this.getHttpHandler().readPutRequest(url, alternativXmlConfiguration, true);
            }
            catch (JDOMException ex1) {
                this.getLogger().warn("Could not set alternative configuration data for " + this);
            }
        }
    }

    private SupportedGenericEventsType getIsapiGenericEventTrigger(int videoSources) {
        List<GenericEventDefinitionType> vcaRulesEventDefinitionType;
        List<GenericEventDefinitionType> bodyTemperatureEventDefinitionType;
        List<GenericEventDefinitionType> thermalEventDefinitionType;
        SupportedGenericEventsType supportedGenericEventsType;
        boolean shelterAlarmSet = false;
        boolean tamperDetectionSet = false;
        List<Object> eventTriggerList = new ArrayList();
        EventTriggerList triggerResponse = null;
        try {
            String eventsFromCamera = this.getHttpHandler().readGetRequest("/ISAPI/Event/triggers");
            if (eventsFromCamera.contains("<EventNotification")) {
                EventNotification eventNotification = this.unmarshalHikvisionObject(EventNotification.class, eventsFromCamera.getBytes());
                if (eventNotification != null) {
                    triggerResponse = eventNotification.getEventTriggerList();
                }
            } else {
                triggerResponse = this.unmarshalHikvisionObject(EventTriggerList.class, eventsFromCamera.getBytes());
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading event trigger from " + this + " : " + ex.getMessage());
        }
        if (triggerResponse != null && triggerResponse.getClass() == EventTriggerList.class && triggerResponse.getEventTrigger().size() > 0) {
            eventTriggerList = triggerResponse.getEventTrigger();
        }
        if (eventTriggerList.size() > 0) {
            GenericEventDefinitionType genericEventDefinitionType;
            String event;
            supportedGenericEventsType = new SupportedGenericEventsType();
            for (EventTrigger trigger : eventTriggerList) {
                if (trigger == null || trigger.getEventType() == null || trigger.getEventType().getValue() == null || trigger.getEventType().getValue().value().toLowerCase().equals("io") || trigger.getEventType().getValue().value().toLowerCase().equals("wlsensor") || trigger.getEventType().getValue().value().toLowerCase().equals("ipconflict") || trigger.getEventType().getValue().value().toLowerCase().equals("nicbroken")) continue;
                if (trigger.getEventType().getValue().value().toLowerCase().trim().equals("shelteralarm")) {
                    shelterAlarmSet = true;
                }
                if (trigger.getEventType().getValue().value().toLowerCase().trim().equals("tamperdetection")) {
                    tamperDetectionSet = true;
                }
                GenericEventDefinitionType genericEventDefinitionType2 = new GenericEventDefinitionType();
                genericEventDefinitionType2.setEventType(trigger.getEventType().getValue().value());
                int alarmSourceNumber = 0;
                if (videoSources > 1 && trigger.getVideoInputChannelID() != null) {
                    alarmSourceNumber = Integer.parseInt(trigger.getVideoInputChannelID().getValue());
                }
                genericEventDefinitionType2.setSourceNumber(alarmSourceNumber);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType2);
            }
            if (videoSources > 1 && HikvisionHelper.isEventsAvailableForFirstChannelOnly(supportedGenericEventsType)) {
                supportedGenericEventsType = HikvisionHelper.copyEventsForOtherChannels(videoSources, supportedGenericEventsType);
            }
            if (!shelterAlarmSet) {
                event = "shelteralarm";
                genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(event);
                genericEventDefinitionType.setSourceNumber(0);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
            if (!tamperDetectionSet) {
                event = "tamperdetection";
                genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(event);
                genericEventDefinitionType.setSourceNumber(0);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
        } else {
            supportedGenericEventsType = this.getIsapiGenericEventTriggerByTrying();
        }
        if (!(thermalEventDefinitionType = this.getIsapiThermalEventTrigger(videoSources)).isEmpty()) {
            supportedGenericEventsType.getGenericEventDefinition().addAll(thermalEventDefinitionType);
        }
        if (!(bodyTemperatureEventDefinitionType = this.getBodyTemperatureEventTrigger(videoSources)).isEmpty()) {
            supportedGenericEventsType.getGenericEventDefinition().addAll(bodyTemperatureEventDefinitionType);
        }
        if (!(vcaRulesEventDefinitionType = this.getVcaRules(videoSources)).isEmpty()) {
            supportedGenericEventsType.getGenericEventDefinition().addAll(vcaRulesEventDefinitionType);
        }
        return supportedGenericEventsType;
    }

    private SupportedGenericEventsType getIsapiGenericEventTriggerByTrying() {
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        ArrayList<String> eventList = new ArrayList<String>();
        eventList.add("tamperdetection");
        eventList.add("VMD");
        eventList.add("shelteralarm");
        this.checkGenericEventTrigger("facedetection", "/ISAPI/Smart/FaceDetect/1", FaceDetect.class, eventList);
        this.checkGenericEventTrigger("audioexception", "/ISAPI/Smart/AudioDetection/channels/1", AudioDetection.class, eventList);
        this.checkGenericEventTrigger("defocus", "/ISAPI/Smart/DefocusDetection/1", DefocusDetection.class, eventList);
        this.checkGenericEventTrigger("SceneChangeDetection", "/ISAPI/Smart/SceneChangeDetection/1", SceneChangeDetection.class, eventList);
        this.checkGenericEventTrigger("linedetection", "/ISAPI/Smart/LineDetection", LineDetection.class, eventList);
        this.checkGenericEventTrigger("fielddetection", "/ISAPI/Smart/FieldDetection", FieldDetection.class, eventList);
        this.checkGenericEventTrigger("attendedBaggage", "/ISAPI/Smart/attendedBaggage", AttendedBaggage.class, eventList);
        this.checkGenericEventTrigger("unattendedBaggage", "/ISAPI/Smart/unattendedBaggage", UnattendedBaggage.class, eventList);
        this.checkGenericEventTrigger("regionEntrance", "/ISAPI/Smart/regionEntrance", RegionEntrance.class, eventList);
        this.checkGenericEventTrigger("regionExiting", "/ISAPI/Smart/regionExiting", RegionExiting.class, eventList);
        for (String event : eventList) {
            GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
            genericEventDefinitionType.setEventType(event);
            genericEventDefinitionType.setSourceNumber(0);
            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
        }
        return supportedGenericEventsType;
    }

    private VirtualCameraDefinitionType getVirtualCameraDefinitionType() {
        VirtualCameraDefinitionType virtualCameraDefinitionType = new VirtualCameraDefinitionType();
        virtualCameraDefinitionType.setCanVirtualCamera(false);
        virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
        virtualCameraDefinitionType.setNoOfVirtualCameras(0);
        return virtualCameraDefinitionType;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just Hikvision default pass which is a proper default setting in this case.")
    private DeviceNetworkDefinitionType getDeviceNetworkDefinitionType() throws SeeTecException, SAXException, JAXBException {
        DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
        deviceNetworkDefinitionType.setCanChangeHttpPort(true);
        deviceNetworkDefinitionType.setCanChangeHttpsPort(true);
        deviceNetworkDefinitionType.setDefaultHttpPort(80);
        deviceNetworkDefinitionType.setDefaultHttpsPort(443);
        deviceNetworkDefinitionType.setDefaultPassword("12345");
        deviceNetworkDefinitionType.setDefaultUserName("admin");
        deviceNetworkDefinitionType.setUseAuthentication(true);
        deviceNetworkDefinitionType.setCanHttps(true);
        deviceNetworkDefinitionType.setDefaultVideoStreamNetworkTimeout(15000L);
        deviceNetworkDefinitionType.setMaxVideoStreamNetworkTimeout(20000L);
        deviceNetworkDefinitionType.setMinVideoStreamNetworkTimeout(5000L);
        return deviceNetworkDefinitionType;
    }

    private CameraResolutionType getCaptureModeCameraResolutionType(StreamingChannel mainStream) throws SeeTecException {
        int biggestHeight;
        int biggestWidth;
        CameraResolutionType captureModeCameraResolutionType = new CameraResolutionType();
        String[] resolutions = mainStream.getVideo().getVideoResolutionWidth().getOpt().split(",");
        String[] fpsString = mainStream.getVideo().getMaxFrameRate().getOpt().split(",");
        int fps = this.getMaxFps(fpsString);
        if (this.isCGIDevice()) {
            biggestWidth = this.getBiggestWidth(resolutions);
            biggestHeight = this.getBiggestHeight(resolutions, null);
        } else {
            String[] resolutionWidths = mainStream.getVideo().getVideoResolutionHeight().getOpt().split(",");
            biggestWidth = this.getBiggestWidth(resolutions);
            biggestHeight = this.getBiggestHeight(resolutions, resolutionWidths);
        }
        captureModeCameraResolutionType.setDisplayResolution("DefaultCaptureMode");
        captureModeCameraResolutionType.setWidth(biggestWidth);
        captureModeCameraResolutionType.setHeight(biggestHeight);
        captureModeCameraResolutionType.setMaxMilliFPS(fps * 10);
        captureModeCameraResolutionType.setMinMilliFPS(1);
        captureModeCameraResolutionType.setResolution(biggestWidth + "x" + biggestHeight);
        captureModeCameraResolutionType.setSupportedFrameRates(null);
        return captureModeCameraResolutionType;
    }

    private SupportedMPEGProfileIDs getSupportedMPEGProfileIds(String[] H264Profiles) {
        SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
        if (H264Profiles != null) {
            String[] stringArray = H264Profiles;
            int n = stringArray.length;
            block10: for (int i = 0; i < n; ++i) {
                String profile;
                switch (profile = stringArray[i]) {
                    case "Baseline": {
                        supportedMPEGProfileIds.getInt().add(MpegProfile.BASELINE.getType());
                        continue block10;
                    }
                    case "Main": {
                        supportedMPEGProfileIds.getInt().add(MpegProfile.MAIN.getType());
                        continue block10;
                    }
                    case "High": {
                        supportedMPEGProfileIds.getInt().add(MpegProfile.HIGH.getType());
                        continue block10;
                    }
                }
            }
        }
        return supportedMPEGProfileIds;
    }

    private AvailableIOsType getAvailableIOsType() throws SeeTecException, SAXException, JAXBException {
        AvailableIOsType availableIOsType = new AvailableIOsType();
        try {
            IOInputPortList ioInputList;
            int numberOfInputs = 0;
            String inputURL = "/ISAPI/System/IO/inputs";
            String outputURL = "/ISAPI/System/IO/outputs";
            if (this.isCGIDevice()) {
                inputURL = "/IO/inputs";
                outputURL = "/IO/outputs";
            }
            if ((ioInputList = this.getHikvisionObject(IOInputPortList.class, inputURL)) != null) {
                numberOfInputs = ioInputList.getIOInputPort().size();
            }
            for (int i = 0; i < numberOfInputs; ++i) {
                availableIOsType.getInputOutputCapabilities().add(0);
            }
            int numberOfOutputs = 0;
            IOOutputPortList ioOutputList = this.getHikvisionObject(IOOutputPortList.class, outputURL);
            if (ioOutputList != null) {
                numberOfOutputs = ioOutputList.getIOOutputPort().size();
            }
            for (int i = 0; i < numberOfOutputs; ++i) {
                availableIOsType.getInputOutputCapabilities().add(1);
            }
        }
        catch (JAXBException | SAXException ex) {
            this.logger.error("Problems while geting IO definitions from device for " + this, ex);
            throw ex;
        }
        return availableIOsType;
    }

    protected ImageRotationCapabilitiesType getImageRotationCapabilitiesType(StreamingChannel mainStream) throws SAXException, JAXBException, SeeTecException {
        ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
        SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
        ImageChannel imageChannel = this.getHikvisionObject(ImageChannel.class, "/ISAPI/Image/channels/1/capabilities");
        if (imageChannel.getImageFlip() != null && imageChannel.getImageFlip().getEnabled() != null && imageChannel.getImageFlip().getEnabled().getOpt().contains("true")) {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
            if (mainStream.getVideo() != null && mainStream.getVideo().getRotationDegree() != null) {
                String[] rotationAngles;
                for (String rotationAngle : rotationAngles = mainStream.getVideo().getRotationDegree().getOpt().split(",")) {
                    supportedRotationAnglesType.getInt().add(Integer.parseInt(rotationAngle) * 1000);
                }
            } else if (imageChannel.getCorridor() != null && imageChannel.getCorridor().getEnabled() != null && imageChannel.getCorridor().getEnabled().getOpt().equalsIgnoreCase("true,false")) {
                supportedRotationAnglesType.getInt().add(0);
                supportedRotationAnglesType.getInt().add(90000);
                supportedRotationAnglesType.getInt().add(180000);
                supportedRotationAnglesType.getInt().add(270000);
            } else {
                supportedRotationAnglesType.getInt().add(0);
                supportedRotationAnglesType.getInt().add(180000);
            }
        } else {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(false);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(false);
            supportedRotationAnglesType.getInt().add(0);
            supportedRotationAnglesType.getInt().add(180000);
        }
        imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        return imageRotationCapabilitiesType;
    }

    private AudioCapabilitiesType getAudioCapabilitiesType(StreamingChannel mainStream) throws SAXException, JAXBException {
        AudioCapabilitiesType audioCapabilitiesType;
        block12: {
            audioCapabilitiesType = new AudioCapabilitiesType();
            try {
                AudioChannelList audioValue = this.isCGIDevice() ? this.getHikvisionObject(AudioChannelList.class, "/Audio/channels") : this.getHikvisionObject(AudioChannelList.class, "/ISAPI/System/Audio/channels");
                if (audioValue != null && !audioValue.getAudioChannel().isEmpty()) {
                    audioCapabilitiesType.setCanAudio(audioValue.getAudioChannel().get(0).getEnabled().isValue());
                    audioCapabilitiesType.setNumberOfPossibleAudioStreams(audioValue.getAudioChannel().size());
                    audioCapabilitiesType.setDefaultAudioCodecIndex(0);
                }
                if (audioCapabilitiesType.isCanAudio() && mainStream.getAudio() != null) {
                    String[] audioCodecs = mainStream.getAudio().getAudioCompressionType().getOpt().split(",");
                    AudioCodecsType audioCodecsType = this.getAudioCodecsType(audioCodecs);
                    audioCapabilitiesType.setAudioCodecs(audioCodecsType);
                } else {
                    audioCapabilitiesType.setAudioCodecs(null);
                }
            }
            catch (SeeTecException ex) {
                this.logger.warn("Exception while reading audio capabilities. Maybe audio is not available for " + this);
            }
            catch (JAXBException | SAXException ex) {
                this.logger.error("Problems while geting audio definitions from device for " + this, ex);
                throw ex;
            }
            try {
                if (this.isCGIDevice()) {
                    audioCapabilitiesType.setCanAudioOut(true);
                    break block12;
                }
                try {
                    AudioCap audioCap = this.getHikvisionObject(AudioCap.class, "/ISAPI/System/audio/capabilities", "/ISAPI/System/Audio/capabilities");
                    if (audioCap.getAudioOutputNums().getValue().intValue() > 0) {
                        audioCapabilitiesType.setCanAudioOut(true);
                    }
                }
                catch (Exception ex) {
                    this.logger.info("Could not get audio out capabilities for " + this);
                }
            }
            catch (SeeTecException ex) {
                this.logger.warn("Exception while gettin API version for " + this);
            }
        }
        return audioCapabilitiesType;
    }

    private AudioCodecsType getAudioCodecsType(String[] audioCodecs) {
        AudioCodecsType audioCodecsType = new AudioCodecsType();
        for (String audioCodec : audioCodecs) {
            AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
            CodecType codecType = new CodecType();
            switch (audioCodec) {
                case "G.711ulaw": {
                    codecType.setValue(Codec.G711U.getType());
                    break;
                }
                case "G.726": {
                    break;
                }
                case "G.711alaw": {
                    codecType.setValue(Codec.G711A.getType());
                    break;
                }
                case "PCM": {
                    codecType.setValue(Codec.PCM.getType());
                    break;
                }
                default: {
                    codecType.setValue(Codec.UNKNOWN.getType());
                }
            }
            if (codecType.getValue() == 0) continue;
            audioCodecDefinitionType.setAudioCodec(codecType);
            audioCodecDefinitionType.setBitrate(64000);
            audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
        }
        return audioCodecsType;
    }

    protected MiscVideoServerCapabilitiesType getMiscVideoServerCapabilitiesType(int channel) throws SeeTecException {
        MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
        try {
            miscVideoServerCapabilitiesType.setCanTimeDate(true);
            miscVideoServerCapabilitiesType.setCanTitle(this.getTitleCapabilities(channel));
            if (!this.isCGIDevice()) {
                miscVideoServerCapabilitiesType.setCanDetectTampering(false);
                miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
            }
            miscVideoServerCapabilitiesType.setNoOfRS232S(0);
            miscVideoServerCapabilitiesType.setCanTimeshift(false);
            miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
            miscVideoServerCapabilitiesType.setCanPTZ(true);
        }
        catch (JAXBException | SAXException ex) {
            this.logger.error("Exception while preparing Hikvision Device capabilities: " + ex.getMessage());
        }
        return miscVideoServerCapabilitiesType;
    }

    private MultiStreamingDefinitionsType getMultiStreamingDefinitionsType(StreamingChannel mainStream, int maxNumberOfStreams, int channelNumber) throws SeeTecException, SAXException, JAXBException {
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        List<String> codecsSet = this.getCodecsSet(maxNumberOfStreams);
        try {
            SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
            for (int stream = 1; stream <= maxNumberOfStreams; ++stream) {
                String url = "/ISAPI/Streaming/channels/" + channelNumber + "0" + stream + "/capabilities";
                if (this.isCGIDevice() && this.getNumberOfVideoSourcesFromDevice() <= 1 && this.getHikvisionDeviceType().toLowerCase().contains("ip")) {
                    url = "/ISAPI/Streaming/channels/" + stream + "/capabilities";
                }
                StreamingChannel streamingChannel = this.getHikvisionObject(StreamingChannel.class, url);
                url = "/ISAPI/Streaming/channels/" + channelNumber + "02/capabilities";
                if (this.isCGIDevice() && this.getNumberOfVideoSourcesFromDevice() <= 1 && this.getHikvisionDeviceType().toLowerCase().contains("ip")) {
                    url = "/ISAPI/Streaming/channels/2/capabilities";
                }
                StreamingChannel subStream = this.getHikvisionObject(StreamingChannel.class, url);
                if (maxNumberOfStreams >= 3 && !this.isCGIDevice()) {
                    url = "/ISAPI/Streaming/channels/" + channelNumber + "03/capabilities";
                }
                HashSet streamingCodecs = new HashSet();
                Collections.addAll(streamingCodecs, streamingChannel.getVideo().getVideoCodecType().getOpt().split(","));
                for (String codec : codecsSet) {
                    BitrateSettingsType bitrateSettingsType;
                    SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType;
                    CodecType codecType;
                    StreamDefinitionType streamDefinitionType = this.getCommonStreamDefinitionType();
                    if (codec.equals("H.264") && streamingCodecs.contains("H.264")) {
                        codecType = new CodecType();
                        codecType.setValue(Codec.H264.getType());
                        if (streamingChannel.getVideo().getH264Profile() != null) {
                            String[] H264Profiles = streamingChannel.getVideo().getH264Profile().getOpt().split(",");
                            supportedMPEGProfileIds = this.getSupportedMPEGProfileIds(H264Profiles);
                        }
                        supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                        if (!this.isCGIDevice()) {
                            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                        }
                        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                        bitrateSettingsType = new BitrateSettingsType();
                        bitrateSettingsType.setCanVBR(true);
                        bitrateSettingsType.setCanVBRQuality(true);
                        bitrateSettingsType.setCanVBRBandwidth(true);
                        bitrateSettingsType.setCanCBR(true);
                        bitrateSettingsType.setCanCBRQuality(true);
                        bitrateSettingsType.setMaxBandwidth(streamingChannel.getVideo().getConstantBitRate().getMax().intValue() * 1024);
                        bitrateSettingsType.setMinBandwidth(1024);
                        bitrateSettingsType.setSupportedBitrates(null);
                        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    } else if (codec.equals("H.265") && streamingCodecs.contains("H.265")) {
                        codecType = new CodecType();
                        codecType.setValue(Codec.H265.getType());
                        supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                        if (!this.isCGIDevice()) {
                            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                        }
                        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                        bitrateSettingsType = new BitrateSettingsType();
                        bitrateSettingsType.setCanVBR(true);
                        bitrateSettingsType.setCanVBRQuality(true);
                        bitrateSettingsType.setCanVBRBandwidth(true);
                        bitrateSettingsType.setCanCBR(true);
                        bitrateSettingsType.setCanCBRQuality(true);
                        bitrateSettingsType.setMaxBandwidth(streamingChannel.getVideo().getConstantBitRate().getMax().intValue() * 1024);
                        bitrateSettingsType.setMinBandwidth(1024);
                        bitrateSettingsType.setSupportedBitrates(null);
                        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    } else if (codec.equals("MJPEG") && streamingCodecs.contains("MJPEG")) {
                        codecType = new CodecType();
                        codecType.setValue(Codec.MJPEG.getType());
                        supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                        if (!this.isCGIDevice()) {
                            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                        }
                        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                        bitrateSettingsType = new BitrateSettingsType();
                        bitrateSettingsType.setCanVBR(true);
                        bitrateSettingsType.setCanVBRQuality(true);
                        bitrateSettingsType.setCanCBR(false);
                        bitrateSettingsType.setCanCBRQuality(false);
                        streamDefinitionType.setHideKompressionField(false);
                        bitrateSettingsType.setMaxBandwidth(0x1000000);
                        bitrateSettingsType.setMinBandwidth(1024);
                        bitrateSettingsType.setSupportedBitrates(null);
                        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    } else {
                        if (!codec.equals("MPEG4") || !streamingCodecs.contains("MPEG4")) continue;
                        codecType = new CodecType();
                        codecType.setValue(Codec.MPEG4.getType());
                        supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                        if (!this.isCGIDevice()) {
                            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                        }
                        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                        bitrateSettingsType = new BitrateSettingsType();
                        bitrateSettingsType.setCanVBR(true);
                        bitrateSettingsType.setCanVBRQuality(true);
                        bitrateSettingsType.setCanCBR(true);
                        bitrateSettingsType.setCanCBRQuality(true);
                        bitrateSettingsType.setMaxBandwidth(0x1000000);
                        bitrateSettingsType.setMinBandwidth(1024);
                        bitrateSettingsType.setSupportedBitrates(null);
                        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                    }
                    streamDefinitionType.setMaxNumberOfStreams(1);
                    streamDefinitionType.setStreamingMode(codecType);
                    streamDefinitionType.setName(codec.toUpperCase() + " Stream " + stream);
                    streamDefinitionType.setSupportedCameraResolutions(this.getSupportedCameraResolutionsType(mainStream, subStream, streamingChannel, stream, Codec.valueOf((int)codecType.getValue()), channelNumber));
                    if (codecType.getValue() == Codec.H264.getType()) {
                        streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfileIds);
                    }
                    multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
                }
            }
        }
        catch (JAXBException | SAXException ex) {
            this.logger.error("Problems while getting streaming definitions from device for " + this, ex);
            throw ex;
        }
        return multiStreamingDefinitionsType;
    }

    private List<String> getCodecsSet(int maxNumberOfStreams) throws SeeTecException, SAXException, JAXBException {
        HashSet codecsSet = new HashSet();
        try {
            for (int ch = 1; ch <= maxNumberOfStreams; ++ch) {
                StreamingChannel streamingChannel = this.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/10" + ch + "/capabilities");
                if (streamingChannel == null) {
                    streamingChannel = this.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/" + ch + "/capabilities");
                }
                Collections.addAll(codecsSet, streamingChannel.getVideo().getVideoCodecType().getOpt().split(","));
            }
            if (codecsSet.contains("H.264") && codecsSet.contains("MPEG4")) {
                codecsSet.remove("MPEG4");
            }
        }
        catch (JAXBException | SAXException ex) {
            this.logger.error("Problems while getting codec from device for " + this);
            throw ex;
        }
        ArrayList<String> codecs = new ArrayList<String>(codecsSet);
        Collections.reverse(codecs);
        return codecs;
    }

    private SupportedCameraResolutionsType getSupportedCameraResolutionsType(StreamingChannel mainStream, StreamingChannel subStream, StreamingChannel streamingChannel, int stream, Codec codec, int channelNumber) throws SeeTecException, SAXException, JAXBException {
        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
        String[] resolutionsWidth = streamingChannel.getVideo().getVideoResolutionWidth().getOpt().split(",");
        String[] resolutionsHeight = streamingChannel.getVideo().getVideoResolutionHeight().getOpt().split(",");
        String[] fpsString = mainStream.getVideo().getMaxFrameRate().getOpt().split(",");
        for (int resol = 0; resol < resolutionsWidth.length; ++resol) {
            int lowestHeightSubstream;
            int lowestWidthSubstream;
            int height;
            int width;
            if (resolutionsWidth[resol].contains("*")) {
                width = Integer.parseInt(resolutionsWidth[resol].substring(0, resolutionsWidth[resol].indexOf("*")));
                height = Integer.parseInt(resolutionsWidth[resol].substring(resolutionsWidth[resol].indexOf("*") + 1));
            } else {
                width = Integer.parseInt(resolutionsWidth[resol]);
                height = Integer.parseInt(resolutionsHeight[resol]);
            }
            String[] resolutionsWidthSubstream = subStream.getVideo().getVideoResolutionWidth().getOpt().split(",");
            String[] resolutionsHeightSubstream = subStream.getVideo().getVideoResolutionHeight().getOpt().split(",");
            if (resolutionsWidthSubstream[0].contains("*")) {
                lowestWidthSubstream = Integer.parseInt(resolutionsWidthSubstream[0].substring(0, resolutionsWidthSubstream[0].indexOf("*")));
                lowestHeightSubstream = Integer.parseInt(resolutionsHeightSubstream[0].substring(resolutionsHeightSubstream[0].indexOf("*") + 1));
            } else {
                lowestWidthSubstream = Integer.parseInt(resolutionsWidthSubstream[0]);
                lowestHeightSubstream = Integer.parseInt(resolutionsHeightSubstream[0]);
            }
            if (!this.substreamResolutionAlreadySet) {
                this.setResolution(lowestWidthSubstream, lowestHeightSubstream, 2, codec, channelNumber);
                this.substreamResolutionAlreadySet = true;
            }
            int fps = this.getMaxFps(fpsString);
            fps = this.getCurrentMaxFps(width, height, stream, fps, codec, channelNumber);
            CameraResolutionType cameraResolutionType = new CameraResolutionType();
            cameraResolutionType.setDisplayResolution(width + "x" + height);
            cameraResolutionType.setWidth(width);
            cameraResolutionType.setHeight(height);
            cameraResolutionType.setMaxMilliFPS(fps * 10);
            cameraResolutionType.setMinMilliFPS(1);
            cameraResolutionType.setResolution(width + "x" + height);
            cameraResolutionType.setSupportedFrameRates(null);
            supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
        }
        return supportedCameraResolutionsType;
    }

    private RtspSettingsType getRtspSettingsType() {
        RtspSettingsType rtspSettingsType = new RtspSettingsType();
        rtspSettingsType.setDefaultRtspPort(554);
        rtspSettingsType.setCanChangeRtspPort(true);
        rtspSettingsType.setCanMultipleRtspPorts(false);
        return rtspSettingsType;
    }

    private StreamDefinitionType getCommonStreamDefinitionType() {
        StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
        streamDefinitionType.setNoOfHWMDInputs(0);
        streamDefinitionType.setDefaultMilliFPS(8000);
        streamDefinitionType.setHideFPSField(false);
        streamDefinitionType.setHideIFrameField(false);
        streamDefinitionType.setMinIFrameDistance(1);
        streamDefinitionType.setMaxIFrameDistance(Integer.MAX_VALUE);
        streamDefinitionType.setHideKompressionField(false);
        streamDefinitionType.setHideBandwithField(false);
        streamDefinitionType.setEncodingIntervalMin(0);
        streamDefinitionType.setEncodingIntervalMax(0);
        streamDefinitionType.setRtspSettings(this.getRtspSettingsType());
        streamDefinitionType.setDefaultCameraResolutionIndex(0);
        streamDefinitionType.setDefaultTransmissionTypeIndex(0);
        return streamDefinitionType;
    }

    protected boolean getTitleCapabilities(int channel) throws SeeTecException, SAXException, JAXBException {
        boolean titleAvailable = false;
        try {
            if (this.isCGIDevice()) {
                TextOverlayList title = this.getHikvisionObject(TextOverlayList.class, "/Video/inputs/channels/" + channel + "/overlays/text");
                if (title != null) {
                    titleAvailable = true;
                }
            } else {
                TextOverlayList title = this.getHikvisionObject(TextOverlayList.class, "/ISAPI/System/Video/inputs/channels/" + channel + "/overlays/text");
                if (title != null) {
                    titleAvailable = true;
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while getting title capabilities for " + this, (Throwable)ex);
            titleAvailable = false;
        }
        return titleAvailable;
    }

    protected FeaturesType getPTZfeaturesType(boolean isCgiDevice, PTZChannel ptzChannel) throws SeeTecException, SAXException, JAXBException {
        FeaturesType featuresType = new FeaturesType();
        if (isCgiDevice) {
            featuresType.setMinPan(-180000);
            featuresType.setMaxPan(180000);
            featuresType.setCanRelativePan(false);
            featuresType.setCanAbsolutePan(false);
            featuresType.setCanContinuousPan(true);
            featuresType.setMinTilt(0);
            featuresType.setMaxTilt(90000);
            featuresType.setCanRelativeTilt(false);
            featuresType.setCanAbsoluteTilt(false);
            featuresType.setCanContinuousTilt(true);
            featuresType.setCanPreset(true);
            featuresType.setCanAbsoluteZoom(false);
            featuresType.setCanContinuousZoom(true);
            featuresType.setCanRelativeZoom(false);
            featuresType.setMinZoom(0);
            featuresType.setMaxZoom(100000);
            featuresType.setCanCenterPT(false);
            featuresType.setCanFocus(true);
            featuresType.setCanAutoFocus(true);
            featuresType.setCanIris(true);
            featuresType.setCanAutoIris(true);
            featuresType.setCanNullLux(false);
            featuresType.setCanAutoNullLux(false);
            featuresType.setMinSpeed(0);
            featuresType.setMaxSpeed(100000);
            featuresType.setPTZMinContinuousLevel(10000);
            featuresType.setPTZMaxContinuousLevel(100000);
            featuresType.setPTZContinuousSpeedFactor(1000);
        } else if (ptzChannel != null) {
            featuresType.setMinPan(-180000);
            featuresType.setMaxPan(180000);
            featuresType.setCanRelativePan(false);
            featuresType.setCanAbsolutePan(false);
            featuresType.setCanContinuousPan(true);
            featuresType.setMinTilt(0);
            featuresType.setMaxTilt(90000);
            featuresType.setCanRelativeTilt(false);
            featuresType.setCanAbsoluteTilt(false);
            featuresType.setCanContinuousTilt(true);
            featuresType.setCanPreset(true);
            featuresType.setCanAbsoluteZoom(false);
            featuresType.setCanContinuousZoom(true);
            featuresType.setCanRelativeZoom(false);
            featuresType.setMinZoom(0);
            featuresType.setMaxZoom(100000);
            featuresType.setCanCenterPT(true);
            featuresType.setCanFocus(true);
            featuresType.setCanAutoFocus(true);
            featuresType.setCanIris(true);
            featuresType.setCanAutoIris(true);
            featuresType.setCanNullLux(false);
            featuresType.setCanAutoNullLux(false);
            featuresType.setMinSpeed(0);
            featuresType.setMaxSpeed(100000);
            featuresType.setPTZMinContinuousLevel(10000);
            featuresType.setPTZMaxContinuousLevel(100000);
            featuresType.setPTZContinuousSpeedFactor(1000);
        }
        return featuresType;
    }

    private int getCurrentMaxFps(int width, int height, int stream, int maxFps, Codec codec, int channelNumber) throws SeeTecException, SAXException, JAXBException {
        this.setResolution(width, height, stream, codec, channelNumber);
        String url = "/ISAPI/Streaming/channels/" + channelNumber + "0" + stream + "/capabilities";
        if (this.isCGIDevice() && this.getNumberOfVideoSourcesFromDevice() <= 1 && this.getHikvisionDeviceType().contains("ip")) {
            url = "/Streaming/channels/" + stream + "/capabilities";
        }
        StreamingChannel streamingChannel = this.getHikvisionObject(StreamingChannel.class, url);
        int max = 0;
        if (streamingChannel.getVideo() != null && streamingChannel.getVideo().getMaxFrameRate() != null && streamingChannel.getVideo().getMaxFrameRate().getOpt() != null) {
            String[] opts;
            String opt = streamingChannel.getVideo().getMaxFrameRate().getOpt();
            for (String opt1 : opts = opt.split(",")) {
                int fps = Integer.parseInt(opt1);
                if (fps <= max) continue;
                max = fps;
            }
        }
        return max == 0 ? maxFps : max;
    }

    private void checkGenericEventTrigger(String triggerName, String requestUrl, Class<?> xsdClass, List<String> eventList) {
        try {
            Object triggerResponse = this.getHikvisionObject(xsdClass, requestUrl);
            if (triggerResponse != null && triggerResponse.getClass() == xsdClass) {
                eventList.add(triggerName);
            }
        }
        catch (Exception e) {
            this.logger.warn("No " + triggerName + " available for " + this);
        }
    }

    protected int getMaximalNumberOfStreams(boolean cgiDevice, int videoSourceNumber) {
        int maxNumberOfStreams;
        block5: {
            maxNumberOfStreams = 2;
            try {
                StreamingChannelList streamingChannelList = this.getHikvisionObject(StreamingChannelList.class, "/ISAPI/Streaming/channels");
                maxNumberOfStreams = streamingChannelList.getStreamingChannel().size();
                if (cgiDevice) {
                    if (maxNumberOfStreams > 2) {
                        maxNumberOfStreams = 2;
                    }
                    break block5;
                }
                List<StreamingChannel> streamingChannels = streamingChannelList.getStreamingChannel();
                int result = 0;
                for (StreamingChannel streamingChannel : streamingChannels) {
                    HikvisionStreamId hikvisionStreamId = new HikvisionStreamId(streamingChannel.getId().getValue());
                    if (hikvisionStreamId.getChannel() != videoSourceNumber) continue;
                    ++result;
                }
                return this.limitStreams(result, 5);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while reading number of streams from device " + this + " : " + ex.getMessage());
                this.logger.warn("Using fallback option of 2 streams for " + this);
                maxNumberOfStreams = 2;
            }
        }
        return maxNumberOfStreams;
    }

    protected int limitStreams(int numberOfStreams, int limit) {
        return numberOfStreams < limit ? numberOfStreams : limit;
    }

    protected boolean supportsEdgeStorage() {
        try {
            String[] recordSearchTypes;
            RacmCap racmCap = this.getHikvisionObject(RacmCap.class, "/ISAPI/ContentMgmt/capabilities");
            for (String type : recordSearchTypes = racmCap.getRecordSearchType().getOpt().split(",")) {
                if (!type.equalsIgnoreCase("cmr")) continue;
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    protected String checkEdgeStorageReady(int channelNumber) {
        List<TimeRange> lastRecordings = this.getRecordingInfosFromDevice(System.currentTimeMillis() - 60000L, System.currentTimeMillis(), channelNumber);
        ArrayList<String> multiLineLog = new ArrayList<String>();
        multiLineLog.add("Edge Storage Information for " + this);
        multiLineLog.add("Channel: " + channelNumber);
        if (lastRecordings.isEmpty()) {
            multiLineLog.add("Edge Storage is not ready, because there are no recordings available from the last 60 seconds");
        } else {
            multiLineLog.add("Edge Storage is ready on the camera.");
            try {
                String url = "/ISAPI/ContentMgmt/storage";
                String result = this.getHttpHandler().readGetRequest(url);
                String[] configurationLines = result.split("\r\n");
                multiLineLog.add("");
                multiLineLog.add("Additional Information from camera:");
                for (String configurationLine : configurationLines) {
                    multiLineLog.add("\t" + configurationLine);
                }
            }
            catch (Exception ex) {
                multiLineLog.add("Could not gather additional edge storage information from camera for " + this);
            }
        }
        return Basic.generateIndentedMultiLineLog(multiLineLog);
    }

    @Override
    public List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp, int channelNumber) {
        List<Object> tracks = new ArrayList();
        try {
            String xmlData = this.getHttpHandler().readGetRequest("/ISAPI/ContentMgmt/record/tracks");
            tracks = HikvisionHelper.getTracklist(xmlData, channelNumber);
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception while getting channel number. Assuming it is channel 1");
            Track dummyTrack = new Track();
            dummyTrack.setId("101");
            tracks.add(dummyTrack);
        }
        ArrayList<TimeRange> returnList = new ArrayList<TimeRange>();
        try {
            long adaptedStartTimestampToCameraTime = this.convertTimestampToCamera(startTimestamp, this.getTimeDifferenceFromDevice());
            long adaptedEndTimestampToCameraTime = this.convertTimestampToCamera(endTimestamp, this.getTimeDifferenceFromDevice());
            LocalDateTime startDateTime = LocalDateTime.ofEpochSecond(adaptedStartTimestampToCameraTime / 1000L, 0, ZoneOffset.UTC);
            LocalDateTime endDateTime = LocalDateTime.ofEpochSecond(adaptedEndTimestampToCameraTime / 1000L, 0, ZoneOffset.UTC);
            String formattedStartDate = startDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            String formattedEndDate = endDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            for (Track track : tracks) {
                String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CMSearchDescription><searchID>" + UUID.randomUUID().toString() + "</searchID><trackIDList><trackID>" + track.getId() + "</trackID></trackIDList><timeSpanList><timeSpan><startTime>" + formattedStartDate + "</startTime><endTime>" + formattedEndDate + "</endTime></timeSpan></timeSpanList><maxResults>40</maxResults><searchResultPostion>0</searchResultPostion><metadataList><metadataDescriptor>//recordType.meta.std-cgi.com</metadataDescriptor></metadataList></CMSearchDescription>";
                String url = "/ISAPI/ContentMgmt/search";
                this.getLogger().info("Searching " + formattedStartDate + " - " + formattedEndDate);
                String result = this.getHttpHandler().readPostRequest(url, xmlString);
                CMSearchResult cmSearchResult = this.unmarshalHikvisionObject(CMSearchResult.class, result.getBytes());
                List<MatchElement> matchElements = cmSearchResult.getMatchList().getSearchMatchItem();
                for (MatchElement matchElement : matchElements) {
                    XMLGregorianCalendar start = matchElement.getTimeSpan().get(0).getStartTime();
                    XMLGregorianCalendar end = matchElement.getTimeSpan().get(0).getEndTime();
                    String startString = start.toString();
                    String endString = end.toString();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
                    Date startRange = sdf.parse(startString);
                    Date endRange = sdf.parse(endString);
                    this.getLogger().info(String.format("Found Timerange [%s]-[%s] for %s", sdf.format(startRange), sdf.format(endRange), this));
                    long camStartTimestamp = startRange.getTime();
                    long camEndTimestamp = endRange.getTime();
                    long newStartTimestamp = this.convertCameraTimeToTimestamp(camStartTimestamp, this.getTimeDifferenceFromDevice());
                    long newEndTimestamp = this.convertCameraTimeToTimestamp(camEndTimestamp, this.getTimeDifferenceFromDevice());
                    TimeRange range = new TimeRange(newStartTimestamp, newEndTimestamp, track.getId());
                    returnList.add(range);
                }
            }
        }
        catch (Throwable throwable) {
            this.getLogger().error("Error getting timerange for device " + this + ": " + throwable.getMessage());
        }
        return returnList;
    }

    protected boolean isDvrDevice() {
        if (!this.getHikvisionDeviceType().equalsIgnoreCase("ipcamera")) {
            try {
                VideoCap videoCap = this.getHikvisionObject(VideoCap.class, "/ISAPI/System/Video/capabilities");
                int numberOfAnalogVideoChannels = videoCap.getVideoInputPortNums().getValue().intValue();
                RacmCap racmCap = this.getHikvisionObject(RacmCap.class, "/ISAPI/ContentMgmt/capabilities");
                int numberOfIpVideoChannels = racmCap.getInputProxyNums().getValue().intValue();
                return numberOfAnalogVideoChannels + numberOfIpVideoChannels >= 4;
            }
            catch (Exception ex) {
                this.getLogger().warn("Exception while reading device information for " + this + ": " + ex.getMessage());
            }
        }
        return false;
    }

    protected synchronized Long getTimeDifferenceFromDevice() throws Exception {
        if (this.timeDiff != null) {
            return this.timeDiff;
        }
        if (this.isDvrDevice()) {
            String url = "/ISAPI/System/time";
            Time time = this.getHikvisionObject(Time.class, url);
            ZonedDateTime cameraTime = ZonedDateTime.parse(time.getLocalTime().getValue().toString());
            LocalTime cameraLocalTime = cameraTime.toLocalTime();
            ZonedDateTime localTime = this.getLocalTime();
            this.timeDiff = ChronoUnit.MILLIS.between(cameraLocalTime, localTime);
            HikvisionDevice hikvisionDevice = this;
            hikvisionDevice.timeDiff = hikvisionDevice.timeDiff + this.getDstTimeDifference(localTime, time.getTimeZone().getValue());
            this.getLogger().info("CAMERA TIME (LOCAL): " + cameraLocalTime.toString());
            this.getLogger().info("DM TIME (UTC): " + localTime.toString());
            this.getLogger().info("TIME DIFFERENCE: " + this.timeDiff + " ms for " + this);
        } else {
            String url = "/ISAPI/System/time";
            Time time = this.getHikvisionObject(Time.class, url);
            ZonedDateTime cameraTime = ZonedDateTime.parse(time.getLocalTime().getValue().toString());
            ZonedDateTime localTime = this.getLocalTime();
            this.timeDiff = ChronoUnit.MILLIS.between(cameraTime, localTime);
            HikvisionDevice hikvisionDevice = this;
            hikvisionDevice.timeDiff = hikvisionDevice.timeDiff + this.getDstTimeDifference(localTime, time.getTimeZone().getValue());
            this.getLogger().info("CAMERA TIME (UTC): " + cameraTime.toString());
            this.getLogger().info("DM TIME (UTC): " + localTime.toString());
            this.getLogger().info("TIME DIFFERENCE: " + this.timeDiff + " ms for " + this);
        }
        return this.timeDiff;
    }

    protected ZonedDateTime getLocalTime() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    protected long getDstTimeDifference(ZonedDateTime time, String timeZone) throws SeeTecException {
        if (timeZone.toLowerCase().contains("dst")) {
            String[] timeLines = timeZone.split(",");
            int yearStart = time.getYear();
            int yearEnd = time.getYear();
            if (!this.dstInOneYear(timeLines[1], timeLines[2])) {
                ++yearEnd;
            }
            ZonedDateTime start = this.getDate(yearStart, timeLines[1]);
            ZonedDateTime end = this.getDate(yearEnd, timeLines[2]);
            long difference = this.convertTimeZoneStringToMillis(timeLines[0]);
            if (time.isAfter(start) && time.isBefore(end)) {
                return difference;
            }
        }
        return 0L;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected ZonedDateTime getDate(int year, String dstDate) throws SeeTecException {
        if (year <= 0 || dstDate == null || dstDate.isEmpty() || !dstDate.contains("/") || !dstDate.contains(".") || !dstDate.contains(":")) {
            throw new SeeTecException(-20002, "Invalid Data");
        }
        try {
            String inputDate = dstDate.replace("M", "");
            String[] input = inputDate.split("/");
            String[] inputDateLines = input[0].split("\\.");
            int month = Integer.parseInt(inputDateLines[0]);
            int weekDayOfMonth = Integer.parseInt(inputDateLines[1]);
            int weekDayAsNumber = Integer.parseInt(inputDateLines[2]) + 1;
            String[] timeLines = input[1].split(":");
            int hour = Integer.parseInt(timeLines[0]);
            Calendar calendar = Calendar.getInstance();
            calendar.set(7, weekDayAsNumber);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(8, weekDayOfMonth);
            ZonedDateTime zonedDateTime = ZonedDateTime.of(year, month, calendar.get(5), hour, 0, 0, 0, ZoneId.of("UTC"));
            return zonedDateTime;
        }
        catch (Exception ex) {
            throw new SeeTecException(-20002, "Invalid Data: " + ex.getMessage());
        }
    }

    protected long convertTimeZoneStringToMillis(String timeZoneString) throws SeeTecException {
        if (timeZoneString == null || timeZoneString.isEmpty() || !timeZoneString.contains("DST")) {
            throw new SeeTecException(-20002, "Invalid Data");
        }
        try {
            String timeString = timeZoneString.substring(timeZoneString.indexOf("DST") + 3);
            String[] timeLines = timeString.split(":");
            int hours = Integer.parseInt(timeLines[0]);
            int minutes = Integer.parseInt(timeLines[1]);
            int seconds = Integer.parseInt(timeLines[2]);
            return (hours * 3600 + minutes * 60 + seconds) * 1000;
        }
        catch (Exception ex) {
            throw new SeeTecException(-20002, "Error while parsing data");
        }
    }

    protected boolean dstInOneYear(String first, String second) throws SeeTecException {
        if (first == null || first.isEmpty() || !first.contains("M") || !first.contains(".") || second == null || second.isEmpty() || !second.contains("M") || !second.contains(".")) {
            throw new SeeTecException(-20002, "Invalid Data");
        }
        String firstDate = first.replace("M", "");
        String secondDate = second.replace("M", "");
        String[] firstLines = firstDate.split("\\.");
        String[] secondLines = secondDate.split("\\.");
        try {
            int firstMonth = Integer.parseInt(firstLines[0]);
            int secondMonth = Integer.parseInt(secondLines[0]);
            return firstMonth <= secondMonth;
        }
        catch (Exception ex) {
            throw new SeeTecException(-20002, "Parsing month number did not work: " + firstLines[0] + " or " + secondLines[0]);
        }
    }

    protected long convertCameraTimeToTimestamp(long cameraTimestamp, Long diff) {
        long t = cameraTimestamp - (diff == null ? 0L : diff);
        return t;
    }

    protected long convertTimestampToCamera(long timestamp, Long diff) {
        long t = timestamp + (diff == null ? 0L : diff);
        return t;
    }

    protected List<GenericEventDefinitionType> getIsapiThermalEventTrigger(int videoSources) {
        ArrayList<GenericEventDefinitionType> genericEventDefinitionTypes = new ArrayList<GenericEventDefinitionType>();
        try {
            DeviceCap deviceCap = this.getHikvisionObject(DeviceCap.class, "/ISAPI/System/capabilities");
            if (deviceCap.getThermalCap().getIsSupportThermometry().isValue()) {
                for (int i = 1; i <= videoSources; ++i) {
                    String url2;
                    String url1 = "/ISAPI/Thermal/channels/" + i + "/thermometry/0/regions";
                    ThermometryRegionList thermometryRegionList = this.getHikvisionObject(ThermometryRegionList.class, url1, url2 = "/ISAPI/Thermal/channels/" + i + "/thermometry/1/regions");
                    if (thermometryRegionList == null) continue;
                    List<ThermometryRegion> thermometryRegions = thermometryRegionList.getThermometryRegion();
                    for (ThermometryRegion thermometryRegion : thermometryRegions) {
                        if (!thermometryRegion.getEnabled().isValue()) continue;
                        GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                        String eventTypeThermalAlarm = "Temperature Alarm | " + thermometryRegion.getType().getValue() + " | " + thermometryRegion.getId().getValue();
                        genericEventDefinitionType.setEventType(eventTypeThermalAlarm);
                        genericEventDefinitionType.setSourceNumber(i);
                        genericEventDefinitionTypes.add(genericEventDefinitionType);
                        genericEventDefinitionType = new GenericEventDefinitionType();
                        String eventTypeThermalPreAlarm = "Temperature Pre-Alarm | " + thermometryRegion.getType().getValue() + " | " + thermometryRegion.getId().getValue();
                        genericEventDefinitionType.setEventType(eventTypeThermalPreAlarm);
                        genericEventDefinitionType.setSourceNumber(i);
                        genericEventDefinitionTypes.add(genericEventDefinitionType);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().info("Thermal event capabilities not found for " + this);
        }
        return genericEventDefinitionTypes;
    }

    protected List<GenericEventDefinitionType> getBodyTemperatureEventTrigger(int videoSources) {
        ArrayList<GenericEventDefinitionType> genericEventDefinitionTypes = new ArrayList<GenericEventDefinitionType>();
        try {
            DeviceCap deviceCap = this.getHikvisionObject(DeviceCap.class, "/ISAPI/System/capabilities");
            if (deviceCap.getThermalCap().getIsSupportFaceThermometry().isValue()) {
                for (int i = 1; i <= videoSources; ++i) {
                    FaceThermometryRegionList faceThermometryRegionList;
                    FaceThermometry faceThermometry = this.getHikvisionObject(FaceThermometry.class, "/ISAPI/Thermal/channels/" + i + "/faceThermometry/capabilities");
                    if (!faceThermometry.getFaceThermometryEnabled().isValue() || (faceThermometryRegionList = this.getHikvisionObject(FaceThermometryRegionList.class, "/ISAPI/Thermal/channels/" + i + "/faceThermometry/regions")) == null) continue;
                    List<ThermometryRegion> thermometryRegions = faceThermometryRegionList.getThermometryRegion();
                    for (ThermometryRegion thermometryRegion : thermometryRegions) {
                        GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                        String eventTypeThermalAlarm = "Body Temperature Alarm | " + thermometryRegion.getType().getValue() + " | " + thermometryRegion.getId().getValue();
                        genericEventDefinitionType.setEventType(eventTypeThermalAlarm);
                        genericEventDefinitionType.setSourceNumber(i);
                        genericEventDefinitionTypes.add(genericEventDefinitionType);
                        genericEventDefinitionType = new GenericEventDefinitionType();
                        String eventTypeThermalPreAlarm = "Body Temperature Pre-Alarm | " + thermometryRegion.getType().getValue() + " | " + thermometryRegion.getId().getValue();
                        genericEventDefinitionType.setEventType(eventTypeThermalPreAlarm);
                        genericEventDefinitionType.setSourceNumber(i);
                        genericEventDefinitionTypes.add(genericEventDefinitionType);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().info("Body temperature event capabilities not found for " + this);
        }
        return genericEventDefinitionTypes;
    }

    private String getAlternativeConfiguration(String xmlConfig, int stream) throws SAXException, JAXBException, SeeTecException, JDOMException {
        StreamingChannelList streamingChannelList = this.getHikvisionObject(StreamingChannelList.class, "/ISAPI/streaming/channels");
        boolean multicastEnabled = false;
        int multicastVideoPort = 0;
        int multicastAudioPort = 0;
        String multicastIpAddress = "";
        int mPacketSize = 1000;
        for (StreamingChannel streamingChannel : streamingChannelList.getStreamingChannel()) {
            if (!streamingChannel.getId().getValue().equals("10" + stream)) continue;
            multicastEnabled = streamingChannel.getTransport().getMulticast().getEnabled().isValue();
            multicastIpAddress = streamingChannel.getTransport().getMulticast().getDestIPAddress().getValue();
            multicastVideoPort = streamingChannel.getTransport().getMulticast().getVideoDestPortNo().getValue().intValue();
            multicastAudioPort = streamingChannel.getTransport().getMulticast().getAudioDestPortNo().getValue().intValue();
            mPacketSize = streamingChannel.getTransport().getMaxPacketSize().getValue().intValue();
            break;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlConfig.getBytes());
        Document config = new SAXBuilder().build((InputStream)bais);
        Element root = config.getRootElement();
        Namespace ns = root.getNamespace();
        Element transport = root.getChild("Transport", ns);
        Element maxPacketSize = new Element("maxPacketSize");
        maxPacketSize.addContent(Integer.toString(mPacketSize));
        transport.addContent(maxPacketSize);
        Element multicast = new Element("Multicast");
        Element enabled = new Element("enabled");
        enabled.addContent(multicastEnabled ? "true" : "false");
        Element destIPAddress = new Element("destIPAddress");
        destIPAddress.addContent(multicastIpAddress);
        Element videoDestPortNo = new Element("videoDestPortNo");
        videoDestPortNo.addContent(Integer.toString(multicastVideoPort));
        Element audioDestPortNo = new Element("audioDestPortNo");
        audioDestPortNo.addContent(Integer.toString(multicastAudioPort));
        multicast.addContent(enabled);
        multicast.addContent(destIPAddress);
        multicast.addContent(videoDestPortNo);
        multicast.addContent(audioDestPortNo);
        transport.addContent(multicast);
        XMLOutputter outputter = new XMLOutputter();
        return outputter.outputString(config);
    }

    protected List<GenericEventDefinitionType> getVcaRules(int videoSources) {
        ArrayList<GenericEventDefinitionType> result = new ArrayList<GenericEventDefinitionType>();
        for (int i = 1; i <= videoSources; ++i) {
            try {
                String url = "/ISAPI/Intelligent/channels/" + i + "/behaviorRule/1";
                BehaviorRule behaviorRule = this.getHikvisionObject(BehaviorRule.class, url);
                BehaviorRule.RuleInfoList ruleInfoList = behaviorRule.getRuleInfoList();
                List<RuleInfo> ruleInfos = ruleInfoList.getRuleInfo();
                for (RuleInfo ruleInfo : ruleInfos) {
                    GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                    genericEventDefinitionType.setSourceNumber(i);
                    genericEventDefinitionType.setEventType("VCA rule " + ruleInfo.getRuleId());
                    result.add(genericEventDefinitionType);
                }
                continue;
            }
            catch (Exception ex) {
                this.getLogger().info("Could not read VCA trigger for " + this + " VideoChannel " + i + " : " + ex.getMessage());
            }
        }
        return result;
    }

    protected GenericEventDefinitionType createGenericEventDefinitionType(String eventName, int videoSource) {
        GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
        genericEventDefinitionType.setEventType(eventName);
        genericEventDefinitionType.setSourceNumber(videoSource);
        return genericEventDefinitionType;
    }

    protected SupportedEdgeStoragePlaybackSpeedsType getSupportedEdgeStoragePlaybackSpeedsType() {
        SupportedEdgeStoragePlaybackSpeedsType supportedEdgeStoragePlaybackSpeedsType = new SupportedEdgeStoragePlaybackSpeedsType();
        EdgeStoragePlaybackSpeedType maxSpeed = new EdgeStoragePlaybackSpeedType();
        maxSpeed.setSpeedValue(2);
        maxSpeed.setSpeedName("max");
        supportedEdgeStoragePlaybackSpeedsType.getEdgeStoragePlaybackSpeed().add(maxSpeed);
        EdgeStoragePlaybackSpeedType singleSpeed = new EdgeStoragePlaybackSpeedType();
        singleSpeed.setSpeedValue(1);
        singleSpeed.setSpeedName("1x");
        supportedEdgeStoragePlaybackSpeedsType.getEdgeStoragePlaybackSpeed().add(singleSpeed);
        return supportedEdgeStoragePlaybackSpeedsType;
    }

    private CaptureModeDefinitionType getCaptureModeDefinitionType(StreamingChannel streamingChannel, int channelNumber) throws SeeTecException, SAXException, JAXBException {
        int maxNumberOfStreams = this.getMaximalNumberOfStreams(this.isCGIDevice(), channelNumber);
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = this.getMultiStreamingDefinitionsType(streamingChannel, maxNumberOfStreams, channelNumber);
        CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
        CameraResolutionType captureModeCameraResolutionType = this.getCaptureModeCameraResolutionType(streamingChannel);
        captureModeDefinitionType.setRebootRequired(false);
        captureModeDefinitionType.setModeSuffix("");
        captureModeDefinitionType.setMaxTotalNumberOfStreams(maxNumberOfStreams);
        captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
        captureModeDefinitionType.setResolution(captureModeCameraResolutionType);
        captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
        return captureModeDefinitionType;
    }
}

