/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.CameraPreset;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.PTZPreset;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.PTZPresetList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.PTZStatus;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionCameraSrv;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionHelper;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class HikvisionCameraControl
extends CameraControl {
    private HikvisionDevice hikvisionDevice;
    private int errorCode;
    private static final String IRISLEVEL_OPEN = "<IrisLevel>";
    private static final String IRISLEVEL_CLOSE = "</IrisLevel>";
    private boolean irisFirstSet = false;
    private String[] irisLevels;
    private String urlPrefixPTZ = "/ISAPI/PTZCtrl";
    private String urlPrefixImage = "/ISAPI/Image";
    private int server = 1;

    private String getUrlPrefixImage() {
        return this.urlPrefixImage;
    }

    private void setUrlPrefixImage(String urlPrefixImage) {
        this.urlPrefixImage = urlPrefixImage;
    }

    @Override
    public int init(VideoSrv videoService, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        int errorCode = super.init(videoService, api, host, port, usr, pwd, presetList);
        if (errorCode != 0) {
            return errorCode;
        }
        try {
            Device device;
            if (this.getHikvisionDevice(videoService).isCGIDevice()) {
                this.setUrlPrefixPTZ("/PSIA/PTZ");
                this.setUrlPrefixImage("/PSIA/System/Video/inputs");
            }
            if ((device = this.videoSrv.getDevice()) != null && device.getVideoCameraDefinitionFromConfiguration() != null && device.getVideoCameraDefinitionFromConfiguration().getFeatures().isCanAbsoluteZoom()) {
                FeaturesType features = this.getHikvisionDevice().getVideoCameraDefinitionFromConfiguration().getFeatures();
                this.ptzInfo = new PtzInfo();
                this.ptzInfo.setMinZoom(features.getMinAbsoluteZoom());
                this.ptzInfo.setMaxZoom(features.getMaxAbsoluteZoom());
                this.getAbsolutePosition(true);
            }
            this.server = videoService.getVideoSourceCnf().getServerEntryNo();
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while getting device configuration for " + this + ": " + ex.getMessage());
        }
        return 0;
    }

    protected HikvisionDevice getHikvisionDevice() {
        return this.getHikvisionDevice(null);
    }

    protected HikvisionDevice getHikvisionDevice(VideoSrv videoSrv) {
        if (this.hikvisionDevice == null) {
            Device device;
            if (videoSrv == null) {
                Device device2 = ((HikvisionCameraSrv)this.videoSrv).getDevice();
                if (device2 instanceof HikvisionDevice) {
                    this.hikvisionDevice = (HikvisionDevice)device2;
                }
            } else if (videoSrv instanceof HikvisionCameraSrv && (device = ((HikvisionCameraSrv)videoSrv).getDevice()) instanceof HikvisionDevice) {
                this.hikvisionDevice = (HikvisionDevice)device;
            }
        }
        return this.hikvisionDevice;
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        try {
            String url = "/ISAPI/PTZCtrl/channels/" + this.getServer() + "/absolute";
            String ptzData = "<PTZData version=\"2.0\" xmlns=\"http://www.isapi.org/ver20/XMLSchema\"><AbsoluteHigh><elevation>" + this.ptzInfo.getTilt() + "</elevation><azimuth>" + this.ptzInfo.getPan() + "</azimuth><absoluteZoom>" + zoom + "</absoluteZoom></AbsoluteHigh></PTZData>";
            this.sendCameraCommand(url, ptzData);
            this.ptzInfo.setZoom(zoom);
            return 0;
        }
        catch (Throwable ex) {
            this.getLogger().error(ex + " for " + this, ex);
            return -21600;
        }
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        if (panSpeed != null || tiltSpeed != null || zoomSpeed != null) {
            String url = this.getUrlPrefixPTZ() + "/channels/" + this.getServer() + "/continuous";
            String ptzXmlBlock = "<PTZData version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">";
            if (panSpeed != null || tiltSpeed != null) {
                if (panSpeed != null) {
                    ptzXmlBlock = ptzXmlBlock + "<pan>" + panSpeed / 1000 + "</pan>";
                    this.previousPanSpeed = panSpeed / 1000;
                } else {
                    ptzXmlBlock = ptzXmlBlock + "<pan>" + this.previousPanSpeed + "</pan>";
                }
                if (tiltSpeed != null) {
                    ptzXmlBlock = ptzXmlBlock + "<tilt>" + tiltSpeed / 1000 + "</tilt>";
                    this.previousTiltSpeed = tiltSpeed / 1000;
                } else {
                    ptzXmlBlock = ptzXmlBlock + "<tilt>" + this.previousTiltSpeed + "</tilt>";
                }
            }
            if (zoomSpeed != null) {
                ptzXmlBlock = ptzXmlBlock + "<zoom>" + zoomSpeed / 1000 + "</zoom>";
            }
            ptzXmlBlock = ptzXmlBlock + "</PTZData>";
            this.errorCode = this.sendCameraCommand(url, ptzXmlBlock);
            this.getAbsolutePosition(true);
            return this.errorCode;
        }
        return 0;
    }

    private void getAbsolutePosition(boolean sendStatus) {
        VideoCameraDefinition config = this.videoSrv.getDevice().getVideoCameraDefinitionFromConfiguration();
        if (config == null || !config.getFeatures().isCanAbsoluteZoom()) {
            return;
        }
        try {
            String url = "/ISAPI/PTZCtrl/channels/" + this.videoSrv.getVideoSourceCnf().getServerEntryNo() + "/status";
            PTZStatus ptzStatus = this.getHikvisionDevice().getHikvisionObject(PTZStatus.class, url);
            int elevation = ptzStatus.getAbsoluteHigh().getElevation().getValue().intValue();
            int azimuth = ptzStatus.getAbsoluteHigh().getAzimuth().getValue().intValue();
            int absoluteZoom = ptzStatus.getAbsoluteHigh().getAbsoluteZoom().getValue().intValue();
            this.ptzInfo.setPan(azimuth);
            this.ptzInfo.setTilt(elevation);
            this.ptzInfo.setZoom(absoluteZoom);
            this.getLogger().debug("Absolute position: [" + Basic.longToFormattedString((long)this.ptzInfo.getPan()) + "]/[" + Basic.longToFormattedString((long)this.ptzInfo.getTilt()) + "]/[" + Basic.longToFormattedString((long)this.ptzInfo.getZoom()) + "] for " + this);
            if (sendStatus) {
                this.videoSrv.sendStatusAbsolutePTZ(null, this.ptzInfo.getPan(), this.ptzInfo.getTilt(), this.ptzInfo.getZoom());
            }
        }
        catch (Throwable ex) {
            this.getLogger().error(ex + " for " + this, ex);
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            int yPos = 100 - yPosition;
            int x = 255 * xPosition / 100;
            int y = 255 * yPos / 100;
            String url = "/ISAPI/PTZCtrl/channels/" + this.getServer() + "/position3D";
            StringBuilder ptzBlock = new StringBuilder();
            ptzBlock.append("<Position3D version=\"1.0\" xmlns=\"http://www.isapi.org/ver20/XMLSchema\">");
            ptzBlock.append("<StartPoint>");
            ptzBlock.append("<positionX>").append(x).append("</positionX>");
            ptzBlock.append("<positionY>").append(y).append("</positionY>");
            ptzBlock.append("</StartPoint>");
            ptzBlock.append("<EndPoint>");
            ptzBlock.append("<positionX>").append(x).append("</positionX>");
            ptzBlock.append("<positionY>").append(y).append("</positionY>");
            ptzBlock.append("</EndPoint>");
            ptzBlock.append("</Position3D>");
            this.getHikvisionDevice().getHttpHandler().readPutRequest(url, ptzBlock.toString());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
        }
        return 0;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        try {
            int xLeft = 255 * xPosition / 100;
            int yTop = 255 - 255 * yPosition / 100;
            int xRight = xLeft + 255 * width / 100;
            int yBottom = 255 - (yPosition + height) * 255 / 100;
            String url = "/ISAPI/PTZCtrl/channels/" + this.getServer() + "/position3D";
            StringBuilder ptzBlock = new StringBuilder();
            ptzBlock.append("<Position3D version=\"1.0\" xmlns=\"http://www.isapi.org/ver20/XMLSchema\">");
            ptzBlock.append("<StartPoint>");
            ptzBlock.append("<positionX>").append(xLeft).append("</positionX>");
            ptzBlock.append("<positionY>").append(yBottom).append("</positionY>");
            ptzBlock.append("</StartPoint>");
            ptzBlock.append("<EndPoint>");
            ptzBlock.append("<positionX>").append(xRight).append("</positionX>");
            ptzBlock.append("<positionY>").append(yTop).append("</positionY>");
            ptzBlock.append("</EndPoint>");
            ptzBlock.append("</Position3D>");
            this.getHikvisionDevice().getHttpHandler().readPutRequest(url, ptzBlock.toString());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
        }
        return 0;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousIris(Integer iris) {
        int irisValue = iris;
        int errorCode = 0;
        try {
            if (this.getHikvisionDevice().isCGIDevice()) {
                if (irisValue != 0) {
                    if (!this.irisFirstSet) {
                        this.irisFirstSet = true;
                        String url = this.getUrlPrefixImage() + "/channels/" + this.getServer() + "/Exposure";
                        StringBuilder sb = new StringBuilder(256);
                        sb.append("<Exposure version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
                        sb.append("<ExposureType>IrisFirst</ExposureType>");
                        sb.append("</Exposure>");
                        errorCode = this.sendCameraCommand(url, sb.toString());
                        if (errorCode != 0) {
                            this.getLogger().error("Error reading camera iris configuration for " + this);
                            return errorCode;
                        }
                        this.irisLevels = this.getIrisLevels();
                    }
                    try {
                        int endIndex;
                        String resultString = this.getHikvisionDevice().getHttpHandler().readGetRequest(this.getUrlPrefixImage() + "/channels/" + this.getServer() + "/Iris");
                        int startIndex = resultString.indexOf(IRISLEVEL_OPEN) + IRISLEVEL_OPEN.length();
                        if (startIndex != -1 && (endIndex = resultString.indexOf(IRISLEVEL_CLOSE)) != -1) {
                            String oldIrisLevel;
                            String newIrisLevel = oldIrisLevel = resultString.substring(startIndex, endIndex);
                            for (int i = 0; i < this.irisLevels.length; ++i) {
                                if (!oldIrisLevel.equals(this.irisLevels[i])) continue;
                                if (irisValue < 0) {
                                    if (i != this.irisLevels.length - 1) {
                                        newIrisLevel = this.irisLevels[i + 1];
                                    }
                                } else if (i != 0) {
                                    newIrisLevel = this.irisLevels[i - 1];
                                }
                                String url = this.getUrlPrefixImage() + "/channels/" + this.getServer() + "/Iris";
                                String sb = "<Iris version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\"><IrisLevel>" + newIrisLevel + "</IrisLevel></Iris>";
                                return this.sendCameraCommand(url, sb);
                            }
                        }
                    }
                    catch (SeeTecException ex) {
                        this.getLogger().error("Exception while setting iris level for " + this + ": " + ex.getMessage());
                    }
                    errorCode = -21655;
                }
            } else if (irisValue != 0) {
                this.setAutoIris(false);
                irisValue = irisValue < 0 ? -60 : irisValue;
                irisValue = irisValue > 0 ? 60 : irisValue;
                String url = "/ISAPI/System/Video/inputs/channels/" + this.getServer() + "/iris";
                StringBuilder sb = new StringBuilder();
                sb.append("<IrisData version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
                sb.append("<iris>");
                sb.append(irisValue);
                sb.append("</iris>");
                sb.append("</IrisData>");
                this.getHikvisionDevice().getHttpHandler().readPutRequest(url, sb.toString());
            }
            return errorCode;
        }
        catch (SeeTecException ex) {
            this.getLogger().warn("Exception while sending Iris command for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
    }

    @Override
    public int setAutoIris(Boolean active) {
        try {
            if (!this.getHikvisionDevice().isCGIDevice()) {
                String url = "/ISAPI/Image/channels/" + this.getServer() + "/exposure";
                StringBuilder sb = new StringBuilder(256);
                sb.append("<Exposure version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
                sb.append("<ExposureType>");
                if (active.booleanValue()) {
                    sb.append("auto");
                } else {
                    sb.append("manual");
                }
                sb.append("</ExposureType>");
                sb.append("</Exposure>");
                this.getHikvisionDevice().getHttpHandler().readPutRequest(url, sb.toString());
                return 0;
            }
        }
        catch (SeeTecException ex) {
            this.getLogger().error("Exception while setting AutoFocus for " + this + " : " + ex.getMessage());
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousFocus(Integer focus) {
        int focusValue = focus;
        if (focusValue != 0) {
            this.setAutoFocus(false);
            try {
                if (this.getHikvisionDevice().isCGIDevice()) {
                    String url = "/Image/channels/" + this.getServer() + "/Focus";
                    this.getHikvisionDevice().getHttpHandler().readGetRequest(url);
                } else {
                    focusValue = focusValue < 0 ? -60 : focusValue;
                    focusValue = focusValue > 0 ? 60 : focusValue;
                    String url = "/ISAPI/System/Video/inputs/channels/" + this.getServer() + "/focus";
                    StringBuilder sb = new StringBuilder(256);
                    sb.append("<FocusData version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
                    sb.append("<focus>").append(focusValue).append("</focus>");
                    sb.append("</FocusData>");
                    this.getHikvisionDevice().getHttpHandler().readPutRequest(url, sb.toString());
                    sb = new StringBuilder(256);
                    sb.append("<FocusData version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
                    sb.append("<focus>0</focus></FocusData>");
                    this.getHikvisionDevice().getHttpHandler().readPutRequest(url, sb.toString());
                }
            }
            catch (SeeTecException ex) {
                this.getLogger().error("Error setting focus values for " + this + ": " + ex.getMessage());
            }
        }
        return this.errorCode;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        try {
            if (this.getHikvisionDevice().isCGIDevice()) {
                String url = this.getUrlPrefixImage() + "/channels/" + this.getServer() + "/Focus";
                StringBuilder sb = new StringBuilder(256);
                sb.append("<Focus version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
                sb.append("<FocusStyle>").append(active != false ? "AUTO" : "MANUAL").append("</FocusStyle>");
                sb.append("<FocusLimited/>");
                sb.append("</Focus>");
                return this.sendCameraCommand(url, sb.toString());
            }
            String url = "/ISAPI/Image/channels/" + this.getServer() + "/focusConfiguration";
            StringBuilder sb = new StringBuilder(256);
            sb.append("<FocusConfiguration version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
            sb.append("<focusStyle>").append(active != false ? "AUTO" : "MANUAL").append("</focusStyle>");
            sb.append("<FocusLimited/>");
            sb.append("</FocusConfiguration>");
            this.getHikvisionDevice().getHttpHandler().readPutRequest(url, sb.toString());
        }
        catch (SeeTecException ex) {
            this.getLogger().error("Exception while setting AutoFocus for " + this + " : " + ex.getMessage());
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        String url = this.getUrlPrefixImage() + "/channels/" + this.getServer() + "/IrcutFilter";
        StringBuilder sb = new StringBuilder("<IrcutFilter version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\"><IrcutFilterType>");
        sb.append(active != false ? "night" : "day");
        sb.append("</IrcutFilterType></IrcutFilter>");
        return this.sendCameraCommand(url, sb.toString());
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        String url = this.getUrlPrefixImage() + "/channels/" + this.getServer() + "/IrcutFilter";
        StringBuilder sb = new StringBuilder("<IrcutFilter version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
        sb.append("<IrcutFilterType>");
        sb.append(active != false ? "auto" : "");
        sb.append("</IrcutFilterType></IrcutFilter>");
        return this.sendCameraCommand(url, sb.toString());
    }

    @Override
    public int setHomePosition() {
        String url = this.getUrlPrefixPTZ() + "/channels/" + this.getServer() + "/homeposition/goto";
        String ptzXmlBlock = "";
        this.errorCode = this.sendCameraCommand(url, ptzXmlBlock);
        this.getAbsolutePosition(true);
        return this.errorCode;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            String encodedPresetName = HikvisionHelper.encodeAndLimitPresetName(16, presetName);
            byte[] vector = new byte[256];
            for (i = 0; i < this.getPresetList().size(); ++i) {
                PresetCnf presetCnf = this.getPresetList().elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i < vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.getLogger().error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.getPresetList().addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            String url = this.getUrlPrefixPTZ() + "/channels/" + this.getServer() + "/presets/" + presetPosition;
            String sb = "<PTZPreset version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\"><enabled>true</enabled><id>" + presetPosition + "</id><presetName>" + encodedPresetName + "</presetName></PTZPreset>";
            return this.sendCameraCommand(url, sb);
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
            this.getLogger().error("Adding preset [" + presetName + "] failed :-(");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            for (int i = 0; i < this.getPresetList().size(); ++i) {
                PresetCnf presetCnf = this.getPresetList().elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                String url = this.getUrlPrefixPTZ() + "/channels/" + this.getServer() + "/presets/" + presetCnf.getPresetPosition() + "/goto";
                this.errorCode = this.sendCameraCommand(url, null);
                this.getAbsolutePosition(true);
                return this.errorCode;
            }
        }
        catch (Exception ex) {
            this.getLogger().error((Object)ex, (Throwable)ex);
            this.getLogger().error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.getLogger().error("Preset [" + presetName + "] not available");
        this.getLogger().error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            for (int i = 0; i < this.getPresetList().size(); ++i) {
                PresetCnf presetCnf = this.getPresetList().elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.getPresetList().removeElementAt(i);
                String url = this.getUrlPrefixPTZ() + "/channels/" + this.getServer() + "/presets/" + presetCnf.getPresetPosition();
                try {
                    this.getHikvisionDevice().getHttpHandler().readDeleteRequest(url);
                }
                catch (SeeTecException ex) {
                    this.getLogger().warn("Removing preset [" + presetCnf.getPresetName() + "] from " + this + " failed with error [" + ex.getErrorCode() + "]");
                    return ex.getErrorCode();
                }
                return 0;
            }
        }
        catch (Exception ex) {
            this.getLogger().error((Object)ex, (Throwable)ex);
            this.getLogger().error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.getLogger().error("Preset [" + presetName + "] not available");
        this.getLogger().error("PresetList=" + this.getPresetList());
        return -21683;
    }

    protected int sendCameraCommand(String url, String parameter) {
        try {
            this.getHikvisionDevice().getHttpHandler().readPutRequest(url, parameter, true);
            this.videoSrv.notifyForCameraControl();
        }
        catch (SeeTecException ex) {
            this.getLogger().error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
            return -21600;
        }
        return 0;
    }

    protected String[] getIrisLevels() {
        try {
            String iris;
            Element irisLevelElement;
            String xmlString = this.getHikvisionDevice().getHttpHandler().readGetRequest(this.getUrlPrefixImage() + "/channels/" + this.getServer() + "/capabilities");
            xmlString = xmlString.substring(xmlString.indexOf(">") + 1, xmlString.lastIndexOf(">") + 1);
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            Document cameraConf = new SAXBuilder().build((InputStream)bais);
            Element root = cameraConf.getRootElement();
            Namespace ns = root.getNamespace();
            Element irisElement = root.getChild("Iris", ns);
            if (irisElement != null && (irisLevelElement = irisElement.getChild("IrisLevel", ns)) != null && (iris = irisLevelElement.getAttributeValue("opt")) != null) {
                return iris.split(",");
            }
        }
        catch (SeeTecException ex) {
            this.getLogger().error("Exception while reading XML Data for " + this + ": " + ex.getMessage());
        }
        catch (JDOMException ex) {
            this.getLogger().error("Exception while reading XML Data for " + this + ": " + ex.getMessage());
        }
        return new String[0];
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        if (presets == null) {
            this.getLogger().warn("Received null camera presets object in addCameraPresets!");
            return -20002;
        }
        List<CameraPreset> cameraPresets = presets.getCameraPreset();
        for (CameraPreset cameraPreset : cameraPresets) {
            try {
                Element ptzPosition;
                byte[] cameraPresetPtzData = cameraPreset.getPtzData().getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(cameraPresetPtzData);
                Document ptzDocument = new SAXBuilder().build((InputStream)bais);
                String presetPosition = "1";
                Element root = ptzDocument.getRootElement();
                if (root != null && (ptzPosition = root.getChild("PresetPosition")) != null) {
                    presetPosition = ptzPosition.getText();
                }
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, cameraPreset.getName());
                this.getPresetList().addElement(presetCnf);
                this.getLogger().info("Adding preset configuration: " + presetCnf);
            }
            catch (JDOMException ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        try {
            String url = "/ISAPI/PTZCtrl/channels/" + this.getServer() + "/presets";
            PTZPresetList ptzPresetList = this.getHikvisionDevice().getHikvisionObject(PTZPresetList.class, url);
            ArrayOfCameraPreset arrayOfCameraPreset = new ArrayOfCameraPreset();
            if (ptzPresetList.getPTZPreset().size() > 0) {
                List<PTZPreset> presetListFromCamera = ptzPresetList.getPTZPreset();
                for (PTZPreset ptzPreset : presetListFromCamera) {
                    String name = ptzPreset.getPresetName().getValue();
                    if (name.toLowerCase().contains("remote reboot")) continue;
                    name = name.replace("%", "%25");
                    String presetName = URLDecoder.decode(name, "UTF-8");
                    String presetPosition = ptzPreset.getId().getValue();
                    if (!ptzPreset.getEnabled().isValue()) continue;
                    CameraPreset cameraPreset = new CameraPreset();
                    PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, presetName);
                    cameraPreset.setName(presetName);
                    cameraPreset.setPtzData(new String(presetCnf.getPresetCnf(), "UTF-8"));
                    arrayOfCameraPreset.getCameraPreset().add(cameraPreset);
                }
            }
            return arrayOfCameraPreset;
        }
        catch (Exception ex) {
            this.getLogger().error(ex + " for " + this, (Throwable)ex);
            return new ArrayOfCameraPreset();
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Vector<PresetCnf> getPresetList() {
        return this.presetList;
    }

    protected int getServer() {
        return this.server;
    }

    private void setUrlPrefixPTZ(String prefix) {
        this.urlPrefixPTZ = prefix;
    }

    private String getUrlPrefixPTZ() {
        return this.urlPrefixPTZ;
    }
}

