/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministrationBase;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionEncryption;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionSecurityConfiguration;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionUser;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionUserList;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;

public class HikvisionCameraAdministration
extends CameraAdministrationBase
implements CameraAdministration {
    private static final String ERROR = "error";

    public HikvisionCameraAdministration(SeetecHttpClient httpClient) throws SeeTecException {
        super(httpClient);
    }

    public HttpHandler getHttpHandler(NetworkParameter networkParameter) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        return new HttpHandlerImpl(networkParameter);
    }

    @Override
    protected void modifyPasswordOnDevice(String passwordToSet, NetworkParameter networkParameter) throws SeeTecException {
        try {
            HttpHandler httpHandler = this.getHttpHandler(networkParameter);
            HikvisionEncryption hikvisionEncryption = new HikvisionEncryption();
            String url = "/ISAPI/Security/users";
            String responseFromCamera = httpHandler.readGetRequest(url);
            HikvisionUserList userList = new HikvisionUserList(responseFromCamera);
            String userId = "1";
            String userName = networkParameter.getUserPWD()[0];
            String userLevel = "Administrator";
            boolean isUsingEncryptedData = true;
            for (HikvisionUser user : userList.getUserList()) {
                if (!user.getUserName().equals(userName)) continue;
                userId = user.getId();
                userLevel = user.getUserLevel();
                break;
            }
            url = "/ISAPI/Security/capabilities";
            responseFromCamera = httpHandler.readGetRequest(url);
            HikvisionSecurityConfiguration hikvisionSecurityConfiguration = null;
            try {
                hikvisionSecurityConfiguration = new HikvisionSecurityConfiguration(responseFromCamera);
            }
            catch (Exception ex) {
                isUsingEncryptedData = false;
            }
            if (isUsingEncryptedData && hikvisionSecurityConfiguration != null) {
                String initVector = hikvisionEncryption.getInitVector();
                String oldPassword = networkParameter.getUserPWD()[1];
                String encryptedUserName = hikvisionEncryption.encrypt(networkParameter, userName, hikvisionSecurityConfiguration.isIsIrreversible(), hikvisionSecurityConfiguration.getKeyIterateNum(), hikvisionSecurityConfiguration.getSalt(), initVector);
                String encryptedNewPassword = hikvisionEncryption.encrypt(networkParameter, passwordToSet, hikvisionSecurityConfiguration.isIsIrreversible(), hikvisionSecurityConfiguration.getKeyIterateNum(), hikvisionSecurityConfiguration.getSalt(), initVector);
                String encryptedOldPassword = hikvisionEncryption.encrypt(networkParameter, oldPassword, hikvisionSecurityConfiguration.isIsIrreversible(), hikvisionSecurityConfiguration.getKeyIterateNum(), hikvisionSecurityConfiguration.getSalt(), initVector);
                String body = "<?xml version=\"1.0\" encoding=\"utf-8\"?><User xmlns=\"http://www.isapi.org/ver20/XMLSchema\" version=\"2.0\"><id>" + userId + "</id><enabled>true</enabled><userName>" + encryptedUserName + "</userName><loginPassword>" + encryptedOldPassword + "</loginPassword><password>" + encryptedNewPassword + "</password><userLevel>" + userLevel + "</userLevel></User>";
                url = "/ISAPI/Security/users/" + userId + "?security=1&iv=" + initVector;
                this.getHttpHandler(networkParameter).readPutRequest(url, body);
            } else {
                String body = "<?xml version='1.0' encoding='utf-8'?><User><id>" + userId + "</id><userName>" + userName + "</userName><password>" + passwordToSet + "</password></User>";
                url = "/ISAPI/Security/users/" + userId;
                this.getHttpHandler(networkParameter).readPutRequest(url, body);
            }
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), "Error while setting password. Status: " + seeTecException.getNetworkStatus() + ". Message: " + seeTecException.getMessage());
        }
        catch (Exception exception) {
            throw new SeeTecException(-20001, "Error while setting password: " + exception.getMessage());
        }
    }

    @Override
    public void changeDeviceIP(String newIP, String networkMask, EntMgrProxy entMgrProxy, Entity entity, Core core) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void upgradeFirmwareOnDevice(byte[] firmwareData, NetworkParameter networkParameter) throws SeeTecException {
        networkParameter.setSoTimeout((int)TimeUnit.MINUTES.toMillis(15L));
        try {
            HttpHandler httpHandler = this.getHttpHandler(networkParameter);
            String responseBody = httpHandler.readPutRequest("/ISAPI/System/updateFirmware", firmwareData);
            if (this.isRebootRequired(responseBody)) {
                httpHandler.readPutRequest("/ISAPI/System/reboot", "");
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException exception) {
            throw new SeeTecException(-20001, "Error while upgrading firmware on device. Message: " + exception.getMessage());
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), "Error while upgrading firmware on device. Status: " + seeTecException.getNetworkStatus() + ". Message: " + seeTecException.getMessage());
        }
    }

    private boolean isRebootRequired(String responseBody) throws SeeTecException {
        return responseBody.toLowerCase().contains("reboot required");
    }
}

