/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.HTTPHeader;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HikvisionAudioOutServer
extends AudioOutServer
implements Runnable {
    private final NetworkParameter networkParameter;
    private final Logger logger;
    private Socket postSocket;
    private boolean isShutdown = false;
    private Thread thread;
    private boolean initializing;
    private HttpHandler httpHandler;
    private String urlSendAudio;
    private String urlOpenAudio;
    private String urlCloseAudio;

    public HikvisionAudioOutServer(NetworkParameter networkParameter, HttpHandler httpHandler, boolean isCGIDevice) {
        if (networkParameter != null) {
            this.networkParameter = networkParameter;
            this.httpHandler = httpHandler;
            this.logger = LogManager.getLogger(this.getClass());
            if (isCGIDevice) {
                this.urlSendAudio = "/TwowayAudio/sendData";
                this.urlOpenAudio = "/TwowayAudio/open";
                this.urlCloseAudio = "/TwowayAudio/close";
            } else {
                this.urlSendAudio = "/ISAPI/System/TwoWayAudio/channels/1/audioData";
                this.urlOpenAudio = "/ISAPI/System/TwoWayAudio/channels/1/open";
                this.urlCloseAudio = "/ISAPI/System/TwoWayAudio/channels/1/close";
            }
        } else {
            throw new IllegalArgumentException("NetworkParameter is null for HikvisionAudioOutServer");
        }
    }

    public int init() {
        this.initializing = true;
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
        this.logger.info(this + " initialized");
        return 0;
    }

    private void sendAudio(byte[] audioData) {
        try {
            this.establishStream();
            OutputStream os = this.postSocket.getOutputStream();
            os.write(audioData);
            os.flush();
        }
        catch (IOException iOException) {
            try {
                this.postSocket.close();
                this.postSocket = null;
                this.establishStream();
                OutputStream os = this.postSocket.getOutputStream();
                os.write(audioData);
                os.flush();
            }
            catch (IOException ioe) {
                this.logger.error("Sending audio data failed [" + iOException.getMessage() + "] for " + this);
            }
        }
    }

    private void establishStream() throws IOException {
        if (this.postSocket == null || this.postSocket.isClosed()) {
            if (!this.initializing) {
                this.closeConnection();
            }
            this.initializing = false;
            this.openConnection();
            this.postSocket = this.getPostSocket();
            this.establishPutStream();
        }
    }

    private Socket getPostSocket() {
        try {
            this.postSocket = this.networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getSSLport(), (boolean)true, (int)this.networkParameter.getSoTimeout()) : NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getHTTPport(), (boolean)false, (int)this.networkParameter.getSoTimeout());
            this.postSocket.setSoTimeout(0);
            this.postSocket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            this.logger.error("Error creating socket for " + this + " : " + ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while creating socket for " + this + " : " + ex.getMessage());
        }
        return this.postSocket;
    }

    private void establishPutStream() throws IOException {
        String authentication = this.createAudioOutAuthentication();
        OutputStream os = this.postSocket.getOutputStream();
        String putRequest = this.buildPutRequest(this.networkParameter.getHost(), authentication);
        os.write(putRequest.getBytes());
        os.flush();
        InputStream in = this.postSocket.getInputStream();
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (bytesRead > 0) {
            baos.write(buffer, 0, bytesRead);
            HTTPResponse httpResponse = new HTTPResponse(baos.toByteArray());
            HTTPHeader httpHeader = httpResponse.getHttpHeader();
            if (httpHeader != null && httpHeader.getStatusCode() == HTTPStatusCode.HTTP_UNAUTHORIZED.getStatusCode()) {
                if (httpHeader.getRealm() != null) {
                    this.networkParameter.setRealm(httpHeader.getRealm());
                }
                if (httpHeader.getNonce() != null) {
                    this.networkParameter.setNonce(httpHeader.getNonce());
                }
                if (httpHeader.getQop() != null) {
                    this.networkParameter.setQop(httpHeader.getQop());
                }
                this.postSocket.close();
                this.getPostSocket();
                os = this.postSocket.getOutputStream();
                authentication = this.createAudioOutAuthentication();
                putRequest = this.buildPutRequest(this.networkParameter.getHost(), authentication);
                os.write(putRequest.getBytes());
                os.flush();
            }
        }
    }

    private String createAudioOutAuthentication() {
        String authentication = "";
        String realm = this.networkParameter.getRealm();
        String nonce = this.networkParameter.getNonce();
        String qop = this.networkParameter.getQop();
        if (realm != null && nonce != null) {
            try {
                String requestURL = "http://" + this.networkParameter.getHost() + this.urlSendAudio;
                authentication = NetworkHelper.createDigestAuthorization((NetworkParameter)this.networkParameter, (String)realm, (String)nonce, (String)"PUT", (String)requestURL, (String)qop);
            }
            catch (Exception ex) {
                this.logger.error("Error creating authentication for " + this + " : " + ex.getMessage());
            }
        } else {
            authentication = NetworkHelper.createBasicAuthorization((String[])this.networkParameter.getUserPWD());
        }
        return authentication;
    }

    private String buildPutRequest(String host, String authentication) {
        String postRequest = "PUT " + this.urlSendAudio + " HTTP/1.1" + "\r\n" + "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*.*;q=0.8" + "\r\n" + "Accept-Charset: gb2312,utf8;q=0.7,*;q=0.7" + "\r\n" + "Content-Type: application/octet-stream" + "\r\n" + "Content-Length: 0" + "\r\n" + "Connection: keep-alive" + "\r\n" + "Cache-Control: no-cache" + "\r\n" + "User-Agent: Java/1.8.0" + "\r\n" + "Host: " + host + "\r\n" + authentication + "\r\n";
        return postRequest;
    }

    @Override
    public void run() {
        while (!this.isShutdown) {
            try {
                MediaFrame mediaFrameToSend = this.take();
                for (byte[] singlePayLoad : mediaFrameToSend.getPayload()) {
                    this.sendAudio(singlePayLoad);
                }
            }
            catch (InterruptedException exception) {
                this.logger.info("Sending thread interrupted for " + this);
            }
        }
        this.logger.info("Shutting down " + this);
    }

    @Override
    public int shutdown() {
        this.isShutdown = true;
        this.thread.interrupt();
        try {
            if (this.postSocket != null) {
                this.postSocket.close();
            }
        }
        catch (IOException ioe) {
            this.logger.info("Error closing socket for " + this);
        }
        this.postSocket = null;
        return super.shutdown();
    }

    private void closeConnection() {
        try {
            this.httpHandler.readPutRequest(this.urlCloseAudio, "");
        }
        catch (SeeTecException ex) {
            this.logger.error("Error closing audio connection for " + this + " : " + ex.getMessage());
        }
    }

    private void openConnection() {
        try {
            this.httpHandler.readPutRequest(this.urlOpenAudio, "");
        }
        catch (SeeTecException ex) {
            this.logger.error("Error opening audio connection for " + this + " : " + ex.getMessage());
        }
    }
}

