/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grundig;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.video.grundig.GrundigCameraSrv;
import de.seetec.v5.re.cm.device.video.grundig.GrundigDevice;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import java.net.URLEncoder;
import java.util.Vector;
import javax.xml.ws.Holder;
import org.onvif.ver10.schema.PTZPreset;
import org.onvif.ver20.ptz.wsdl.PTZ;

public class GrundigCameraControl
extends CameraControl {
    private OnvifCore onvifCore = null;
    private PTZ ptzService = null;

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        GrundigDevice grundigDevice = (GrundigDevice)((GrundigCameraSrv)this.videoSrv).getDevice();
        if (grundigDevice.isOnvifDevice()) {
            this.initializeOnvifCoreAndPtzService();
            try {
                this.onvifCore.getPtzService().sendContinuousPtzCommand("Profile1", panSpeed, tiltSpeed, zoomSpeed, 7, 250L);
                this.videoSrv.notifyForCameraControl();
            }
            catch (Exception exception) {
                this.logger.warn("Continuous PTZ command coud not be executed on " + grundigDevice.toString());
                this.logger.warn((Object)exception);
            }
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        try {
            GrundigDevice grundigDevice = (GrundigDevice)((GrundigCameraSrv)this.videoSrv).getDevice();
            if (grundigDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
                for (PTZPreset preset : this.ptzService.getPresets("Profile1")) {
                    try {
                        if (!preset.getName().equals(presetName)) continue;
                        this.ptzService.removePreset("Profile1", preset.getToken());
                        break;
                    }
                    catch (NullPointerException exception) {
                        this.ptzService.removePreset("Profile1", preset.getToken());
                    }
                }
                Holder presetToken = new Holder();
                this.ptzService.setPreset("Profile1", encodedPresetName, presetToken);
                PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, (String)presetToken.value, encodedPresetName);
                this.presetList.addElement(presetCnf);
                vResult.addElement(presetCnf.getPresetCnf());
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetName + "] failed :-(", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            GrundigDevice grundigDevice = (GrundigDevice)((GrundigCameraSrv)this.videoSrv).getDevice();
            if (grundigDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                String token = null;
                for (PTZPreset preset : this.ptzService.getPresets("Profile1")) {
                    try {
                        if (!preset.getName().equals(presetName)) continue;
                        token = preset.getToken();
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                this.ptzService.gotoPreset("Profile1", token, null);
                this.videoSrv.notifyForCameraControl();
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Going to preset [" + presetName + "] failed :-(", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            GrundigDevice grundigDevice = (GrundigDevice)((GrundigCameraSrv)this.videoSrv).getDevice();
            if (grundigDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                String token = null;
                for (PTZPreset preset : this.ptzService.getPresets("Profile1")) {
                    try {
                        if (!preset.getName().equals(presetName)) continue;
                        token = preset.getToken();
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                this.ptzService.removePreset("Profile1", token);
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Going to preset [" + presetName + "] failed :-(", (Throwable)exception);
            return -21600;
        }
    }

    private void initializeOnvifCoreAndPtzService() {
        GrundigDevice grundigDevice = (GrundigDevice)((GrundigCameraSrv)this.videoSrv).getDevice();
        if (this.onvifCore == null) {
            this.onvifCore = grundigDevice.getOnvifCore();
        }
        if (this.ptzService == null) {
            this.ptzService = this.onvifCore.getPtzService().getOnvifPtzService();
        }
    }
}

