/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeCameraSrv;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.EntityType;
import de.seetec.v5.shared.net.HTTPBody;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class GrandEyeEvolutionH264VideoSourceClient
extends StreamingVideoSourceClientRTSP
implements EntityType {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.grandeye.mpeg.GrandEyeEvolutionH264VideoSourceClient";
    private StringBuilder url = null;

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 1, 120);
        this.fps /= 1000L;
        this.fps = this.fps < 1L ? 1L : this.fps;
        this.quality /= 1000;
        this.bandwidth = this.bandwidth < 64 ? 64 : this.bandwidth;
        this.bandwidth = this.bandwidth > 5000000 ? 5000000 : this.bandwidth;
        GrandEyeCameraSrv grandEyeCameraSrv = (GrandEyeCameraSrv)this.getVideoSrv();
        int camera = grandEyeCameraSrv.getCameraNumber(this.width);
        String getUrl = "/geth264settings.cgi?camera=" + camera + "&bitrate&h264quality&goplength&ratecontrol&maxfps";
        this.url = new StringBuilder("/seth264settings.cgi?camera=");
        this.url.append(camera);
        try {
            boolean parameterChanged;
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)getUrl, (int)Integer.MAX_VALUE, (boolean)true);
            HTTPResponse httpResponse = new HTTPResponse(result);
            HTTPBody httpBody = httpResponse.getHttpBody();
            String parametersOnCamera = httpBody.getData();
            boolean bl = !parametersOnCamera.contains("goplength=" + this.iFrameDist) || !parametersOnCamera.contains("ratecontrol=" + (this.isConstantBitrateUsed ? "cbr" : "off")) || !parametersOnCamera.contains("maxfps=" + this.fps) ? true : (parameterChanged = false);
            if (this.isConstantBitrateUsed) {
                this.url.append("&ratecontrol=cbr");
                this.url.append("&bitrate=");
                this.url.append(this.bandwidth);
                parameterChanged |= !parametersOnCamera.contains("bitrate=" + this.bandwidth);
            } else {
                this.url.append("&ratecontrol=off");
                this.url.append("&h264quality=");
                this.url.append(this.quality);
                parameterChanged |= !parametersOnCamera.contains("h264quality=" + this.quality);
            }
            this.url.append("&goplength=");
            this.url.append(this.iFrameDist);
            this.url.append("&maxfps=");
            this.url.append(this.fps);
            if (parameterChanged) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.url.toString(), (int)Integer.MAX_VALUE);
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Error while setting camera parameters for " + this.getVideoSrv() + ": " + e.getMessage());
            return e.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error("Error while setting iFrame distance " + this.getVideoSrv());
            return -21601;
        }
        this.url = new StringBuilder("rtsp://");
        this.url.append(this.getHost());
        this.url.append("/h264/video.sdp?camera=");
        this.url.append(camera);
        try {
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.url.toString(), this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSP Handling failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.getListener().sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

