/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeIOHandler;
import de.seetec.v5.shared.util.SeeTecException;

public class GrandEyeDevice
extends VideoServer {
    private int nBitVector = 0;
    private int memoryUsed = 0;
    private int memoryUsedH264 = 0;

    public int getBitVector() {
        return this.nBitVector;
    }

    public void setBitVector(int position) {
        this.nBitVector |= 1 << position;
    }

    public void clearBitVector(int position) {
        this.nBitVector &= ~(1 << position);
    }

    @Override
    protected IOHandler createIOHandler() {
        return new GrandEyeIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public int getMemoryUsed() {
        return this.memoryUsed;
    }

    public void setMemoryUsed(int memoryUsed) {
        this.memoryUsed += memoryUsed;
    }

    public int getMemoryUsedH264() {
        return this.memoryUsedH264;
    }

    public void setMemoryUsedH264(int memoryUsedH264) {
        this.memoryUsedH264 += memoryUsedH264;
    }

    public int[] calculateMemoryUsed(int width, int height) {
        if (width == 160) {
            return new int[]{1, 2};
        }
        if (width == 320) {
            return new int[]{2, 4};
        }
        if (width == 640) {
            if (height == 208) {
                return new int[]{3, 5};
            }
            return new int[]{7, 9};
        }
        if (width == 1024) {
            if (height == 336) {
                return new int[]{8, 10};
            }
            if (height == 768) {
                return new int[]{17, 20};
            }
            return new int[]{23, 27};
        }
        if (width == 1424) {
            return new int[]{44, 50};
        }
        return new int[]{60, 100};
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

