/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeCameraControl;
import de.seetec.v5.re.cm.device.video.grandeye.jpeg.GrandEyeEvolutionJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.grandeye.jpeg.GrandEyeJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.grandeye.mpeg.GrandEyeEvolutionH264VideoSourceClient;
import de.seetec.v5.re.cm.device.video.grandeye.mpeg.GrandEyeH264VideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.HTTPBody;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class GrandEyeCameraSrv
extends LiveCameraSrv {
    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new GrandEyeCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        VideoSourceClient videoSourceClient = null;
        try {
            Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
            long deviceID = this.device.getDeviceType();
            if (deviceID == 201204L) {
                this.setCodecAndResolution(listener);
                videoSourceClient = streamingMode == Codec.H264 ? new GrandEyeEvolutionH264VideoSourceClient() : new GrandEyeEvolutionJPEGVideoSourceClient();
            } else {
                videoSourceClient = streamingMode == Codec.H264 ? new GrandEyeH264VideoSourceClient() : new GrandEyeJPEGVideoSourceClient();
            }
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    public int getVirtualCameraID(VideoProfileHandler listener) {
        try {
            int nCamera = -1;
            int serverEntryNo = -1;
            int[] resolution = null;
            if (listener != null) {
                serverEntryNo = listener.getVideoSourceParameter().getServerEntryNo();
                resolution = listener.getVideoSourceParameter().getImageSize();
            } else {
                serverEntryNo = this.getVideoSourceCnf().getServerEntryNo();
                resolution = this.getVideoSourceCnf().getImageSize(this.getVideoMode());
            }
            String resolutionString = (resolution[0] + "x" + resolution[1]).trim();
            if (serverEntryNo == 1 && resolutionString.equals("160x120")) {
                nCamera = 14;
            } else if (serverEntryNo == 1 && resolutionString.equals("320x240")) {
                nCamera = 8;
            } else if (serverEntryNo == 1 && resolutionString.equals("640x480")) {
                nCamera = 0;
            } else if (serverEntryNo == 1 && resolutionString.equals("1024x768")) {
                nCamera = 18;
            } else if (serverEntryNo == 2 && resolutionString.equals("160x120")) {
                nCamera = 15;
            } else if (serverEntryNo == 2 && resolutionString.equals("320x240")) {
                nCamera = 9;
            } else if (serverEntryNo == 2 && resolutionString.equals("640x480")) {
                nCamera = 1;
            } else if (serverEntryNo == 2 && resolutionString.equals("1024x768")) {
                nCamera = 19;
            } else if (serverEntryNo == 3 && resolutionString.equals("160x120")) {
                nCamera = 16;
            } else if (serverEntryNo == 3 && resolutionString.equals("320x240")) {
                nCamera = 10;
            } else if (serverEntryNo == 3 && resolutionString.equals("640x480")) {
                nCamera = 2;
            } else if (serverEntryNo == 3 && resolutionString.equals("1024x768")) {
                nCamera = 20;
            } else if (serverEntryNo == 4 && resolutionString.equals("160x120")) {
                nCamera = 17;
            } else if (serverEntryNo == 4 && resolutionString.equals("320x240")) {
                nCamera = 11;
            } else if (serverEntryNo == 4 && resolutionString.equals("640x480")) {
                nCamera = 3;
            } else if (serverEntryNo == 4 && resolutionString.equals("1024x768")) {
                nCamera = 21;
            } else if (serverEntryNo == 5) {
                nCamera = resolutionString.startsWith("1024") ? 23 : 6;
            } else if (serverEntryNo == 6) {
                nCamera = resolutionString.startsWith("1024") ? 24 : 7;
            } else if (serverEntryNo == 7) {
                nCamera = resolutionString.startsWith("1024") ? 22 : 4;
            } else if (serverEntryNo == 8) {
                nCamera = resolutionString.trim().startsWith("1024") ? 12 : 13;
            } else {
                throw new RuntimeException("ServerEntryNo [" + serverEntryNo + "] with resolution [" + resolutionString + "] not supported for " + this + " :-(");
            }
            return nCamera;
        }
        catch (ConfigurationException cex) {
            this.logger.error((Object)cex, (Throwable)cex);
            throw new RuntimeException(cex.getMessage());
        }
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public int setCodecAndResolution(VideoProfileHandler listener) {
        boolean isMultistreaming = false;
        if (this.getAdditionalVideoProfileHandler() != null && this.getAdditionalVideoProfileHandler().length > 0) {
            isMultistreaming = true;
        }
        try {
            int audioEnabled;
            String url = "/admin/getparam.cgi?mainvideostream&codectype&secondvideostream&secondcodectype&secondstreamenable&audioenable";
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.device.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            HTTPResponse httpResponse = new HTTPResponse(result);
            HTTPBody httpBody = httpResponse.getHttpBody();
            String parametersOnCamera = httpBody.getData();
            String parameterUrl = "/admin/setparam.cgi?";
            boolean parametersChanged = false;
            int n = audioEnabled = this.getBasicVideoProfileHandler().getVideoSourceParameter().isAudioEnabled() ? 1 : 0;
            if (isMultistreaming) {
                Codec codecSecondStream;
                Codec codecFirstStream;
                int cameraNumberSecondStream;
                int cameraNumberFirstStream;
                int[] additionalResolution;
                boolean basicVideoProfileAsFirstStream = true;
                int[] basicResolution = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize();
                if (basicResolution[0] * basicResolution[1] <= (additionalResolution = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize())[0] * additionalResolution[1]) {
                    basicVideoProfileAsFirstStream = false;
                }
                audioEnabled |= this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().isAudioEnabled() ? 1 : 0;
                if (basicVideoProfileAsFirstStream) {
                    cameraNumberFirstStream = this.getCameraNumber(this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0]);
                    cameraNumberSecondStream = this.getCameraNumber(this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize()[0]);
                    codecFirstStream = this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec();
                    codecSecondStream = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getMediaCodec();
                } else {
                    cameraNumberSecondStream = this.getCameraNumber(this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0]);
                    cameraNumberFirstStream = this.getCameraNumber(this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize()[0]);
                    codecSecondStream = this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec();
                    codecFirstStream = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getMediaCodec();
                }
                this.getBasicVideoProfileHandler().getVideoSourceParameter().isAudioEnabled();
                if (!(parametersOnCamera.contains("mainvideostream=" + cameraNumberFirstStream) && parametersOnCamera.contains("secondvideostream=" + cameraNumberSecondStream) && parametersOnCamera.contains("codectype=" + codecFirstStream.name().toLowerCase()) && parametersOnCamera.contains("secondcodectype=" + codecSecondStream.name().toLowerCase()) && parametersOnCamera.contains("audioenable=" + audioEnabled))) {
                    parametersChanged = true;
                }
                parameterUrl = parameterUrl + "mainvideostream=" + cameraNumberFirstStream + "&secondvideostream=" + cameraNumberSecondStream + "&codectype=" + codecFirstStream.name().toLowerCase() + "&secondcodectype=" + codecSecondStream.name().toLowerCase();
            } else {
                int cameraNumberFirstStream = this.getCameraNumber(this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0]);
                Codec codecFirstStream = this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec();
                if (!(parametersOnCamera.contains("mainvideostream=" + cameraNumberFirstStream) && parametersOnCamera.contains("codectype=" + codecFirstStream.name().toLowerCase()) && parametersOnCamera.contains("audioenable=" + audioEnabled))) {
                    parametersChanged = true;
                }
                parameterUrl = parameterUrl + "&mainvideostream=" + cameraNumberFirstStream + "&codectype=" + codecFirstStream.name().toLowerCase();
            }
            parameterUrl = parameterUrl + "&audioenable=" + audioEnabled;
            if (parametersChanged) {
                NetworkHelper.readGetRequest((NetworkParameter)this.device.getDeviceCnf().getNetworkParameter(), (String)parameterUrl, (int)Integer.MAX_VALUE, (boolean)true);
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while reading video configuration for " + this);
            return -20100;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading/setting camera parameters for " + this);
            return ex.getErrorCode();
        }
        return 0;
    }

    public int getCameraNumber(int width) {
        if (width == 1056) {
            return 12;
        }
        if (width == 1448) {
            return 25;
        }
        if (width == 2144) {
            return 13;
        }
        return 26;
    }
}

