/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeCameraSrv;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeDevice;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.util.Vector;

public class GrandEyeCameraControl
extends CameraControl {
    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        int errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        for (int i = 0; i < this.presetList.size(); ++i) {
            try {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                ((GrandEyeDevice)videoSrv.getDevice()).setBitVector(Integer.parseInt(presetCnf.getPresetPosition()));
                continue;
            }
            catch (Exception e) {
                this.logger.error("In the Position no position was coded. Funny guys!");
                return -20000;
            }
        }
        return errorCode;
    }

    private int sendCameraCommand(String sURL) {
        try {
            String sCompleteURL = "/com/ptz.cgi?" + sURL;
            this.logger.info("Sending URL=[" + sCompleteURL + "] for " + this + " ...");
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sCompleteURL);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
        return 0;
    }

    private int sendGenericCameraCommand(String sURL) {
        if (sURL == null) {
            this.logger.error("URL is null for " + this);
            return -20000;
        }
        try {
            this.logger.info("Sending URL=[" + sURL + "] for " + this + " ...");
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sURL);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
        return 0;
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        int errorCode = 0;
        StringBuilder sb = new StringBuilder(256);
        try {
            sb.append("camera=").append(((GrandEyeCameraSrv)this.videoSrv).getVirtualCameraID(null));
            if (pan != null) {
                sb.append("&pan=").append((double)(-((float)pan.intValue())) / 1000.0);
            }
            if (tilt != null) {
                sb.append("&tilt=").append((double)tilt.intValue() / 1000.0);
            }
            if (zoom != null) {
                sb.append("&zoom=").append(10000 - (zoom - 1) / 10);
            }
            if ((errorCode = this.sendCameraCommand(sb.toString())) != 0) {
                return errorCode;
            }
            errorCode = this.videoSrv.sendStatusAbsolutePTZ(sender, pan, tilt, zoom);
            if (errorCode != 0) {
                this.logger.error("Send HTTP request failed with error [" + errorCode + "] :-(");
                return errorCode;
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        int errorCode = 0;
        StringBuilder sb = new StringBuilder(256);
        try {
            sb.append("camera=").append(((GrandEyeCameraSrv)this.videoSrv).getVirtualCameraID(null));
            sb.append("&center=").append(xPosition).append(",").append(yPosition);
            errorCode = this.sendCameraCommand(sb.toString());
            if (errorCode != 0) {
                return errorCode;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoIris(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoFocus(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        int errorCode = 0;
        int nPresetPosition = -1;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            for (int i = 0; i < 10; ++i) {
                if ((((GrandEyeDevice)this.videoSrv.getDevice()).getBitVector() & 1 << i) != 0) continue;
                nPresetPosition = i;
                ((GrandEyeDevice)this.videoSrv.getDevice()).setBitVector(nPresetPosition);
                break;
            }
            if (nPresetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            int nCamera = ((GrandEyeCameraSrv)this.videoSrv).getVirtualCameraID(null);
            this.logger.info("Add preset '" + presetName + "'. ID = " + presetID + ". Position = " + nPresetPosition + " for VCAM: " + nCamera);
            String url = "/admin/setpreset.cgi?camera=" + nCamera;
            url = url + "&num=" + nPresetPosition;
            url = url + "&used=1";
            errorCode = this.sendGenericCameraCommand(url);
            if (errorCode != 0) {
                this.logger.warn("Error setting preset on camera. errorCode: " + errorCode);
                return -21600;
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + nPresetPosition, presetName);
            this.presetList.addElement(presetCnf);
            vResult.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed :-(");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        int errorCode = 0;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                int nCamera = ((GrandEyeCameraSrv)this.videoSrv).getVirtualCameraID(null);
                int position = Integer.parseInt(presetCnf.getPresetPosition());
                this.logger.info("Goto preset '" + presetName + "'. Position = " + position + " for VCAM: " + nCamera);
                String url = "/admin/viewpreset.cgi?camera=" + nCamera;
                url = url + "&num=" + position;
                errorCode = this.sendGenericCameraCommand(url);
                if (errorCode == 0) continue;
                this.logger.warn("Error going to preset on camera. errorCode: " + errorCode);
                return -21600;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed :-(");
            return -21600;
        }
        return errorCode;
    }

    @Override
    public int removePresetPosition(String presetName) {
        int errorCode = 0;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                int nCamera = ((GrandEyeCameraSrv)this.videoSrv).getVirtualCameraID(null);
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()) + " at position: " + i + " for VCAM: " + nCamera);
                this.presetList.removeElementAt(i);
                ((GrandEyeDevice)this.videoSrv.getDevice()).clearBitVector(Integer.parseInt(presetCnf.getPresetPosition()));
                String url = "/admin/setpreset.cgi?camera=" + nCamera;
                url = url + "&num=" + Integer.parseInt(presetCnf.getPresetPosition());
                url = url + "&used=0";
                errorCode = this.sendGenericCameraCommand(url);
                if (errorCode == 0) continue;
                this.logger.warn("Error removing preset from camera. errorCode: " + errorCode);
                return -21600;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed :-(");
            return -21600;
        }
        return errorCode;
    }
}

