/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.generic.video;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;

public final class GenericJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.generic.GenericJPEGVideoSourceClient";

    @Override
    protected final boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public void run() {
        int errorCode = 0;
        HttpServerPushHandler httpServerPushHandler = null;
        super.setRunFinished(CLASS_NAME, false);
        try {
            String url = this.getVideoSrv().getVideoSourceCnf().getGenericRTSPUrl();
            String protocolString = "http://";
            if (url.startsWith("http://")) {
                url = url.substring("http://".length());
                url = url.substring(url.indexOf("/"));
            }
            this.networkParameter.setSoTimeout(5000);
            boolean bAsynchronous = false;
            httpServerPushHandler = new HttpServerPushHandler();
            errorCode = httpServerPushHandler.init(this, this.networkParameter, url);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "]with " + httpServerPushHandler);
            } else {
                errorCode = httpServerPushHandler.startServerPush(bAsynchronous);
                if (errorCode != 0) {
                    this.logger.warn("ServerPush of " + httpServerPushHandler + " terminated with error [" + errorCode + "]");
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv());
            this.logger.error((Object)throwable, throwable);
            errorCode = -21651;
        }
        if (httpServerPushHandler != null) {
            httpServerPushHandler.shutdown();
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] contentData = httpServerPushContent.getContentBody();
        this.deliverContent(contentData);
    }
}

