/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.etrovision;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionCameraSrv;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class EtrovisionVideoSourceClientxx8x
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.etrovision.EtrovisionVideoSourceClientxx8x";
    private int streamNumber = 1;
    private EtrovisionDevice etrovisionDevice;

    @Override
    public final int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.networkParameter.setSoTimeout(5000);
        try {
            this.errorCode = ((EtrovisionDevice)this.getVideoSrv().getDevice()).setDeviceParameters(this.listener.getVideoSourceParameter().getRtspPort());
            if (this.errorCode != 0) {
                this.logger.error("Error while setting Device parameters for " + this);
                return this.errorCode;
            }
        }
        catch (ConfigurationException exception) {
            this.logger.warn("RTSP port could not be read", (Throwable)exception);
        }
        if (((EtrovisionCameraSrv)this.getVideoSrv()).setVideoSourceParameters(this.getRotationAngle()) != 0) {
            this.logger.error("Error while setting Video Source parameters for " + this);
            return this.errorCode;
        }
        try {
            this.errorCode = ((EtrovisionCameraSrv)this.getVideoSrv()).setStreamConfiguration(this.listener);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting Multistreaming configuration for " + this);
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting stream configuration for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration exception while setting stream configuration for " + this + " : " + ex.getMessage());
            return -20001;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.streamNumber = ((EtrovisionCameraSrv)this.getVideoSrv()).getStreamNumber(this.listener.getDynamicVideoProfileID());
        this.rtspUrl = "rtsp://" + this.getHost() + "/rtpvideo" + this.streamNumber + ".sdp";
        this.rtspSettings = new RTSPStreamSettings();
        this.logger.info("Starting stream with url " + this.rtspUrl);
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, 10000, this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.rtspSettings.setRange("npt=now-");
        this.rtspSettings.setUserAgent("LibVLC/2.0.2 (LIVE555 Streaming Media v2011.12.23)");
        this.etrovisionDevice = (EtrovisionDevice)this.getVideoSrv().getDevice();
        try {
            if (this.isAudioEnabled && !this.etrovisionDevice.readParameter("/config/audio.cgi", "codec", true).equals(this.isAudioEnabled ? "ulaw" : "none")) {
                StringBuilder url = new StringBuilder("/config/audio.cgi?codec=" + (this.isAudioEnabled ? "ulaw" : "none"));
                url.append("&bitrate=64");
                url.append("&vol_in=" + this.etrovisionDevice.readParameter("/config/audio.cgi", "vol_in"));
                url.append("&vol_out=" + this.etrovisionDevice.readParameter("/config/audio.cgi", "vol_out"));
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("URL for setting audio parameters is: " + url);
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)false);
            }
        }
        catch (SeeTecException see) {
            this.logger.error((Object)see, (Throwable)see);
            this.errorCode = see.getErrorCode();
            return this.errorCode;
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while creating RTSP Handler for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("RTSPHandler.init failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        ((EtrovisionCameraSrv)this.getVideoSrv()).addRTSPHandler(this.rtspHandler);
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public final void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error, new Throwable());
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final synchronized int shutdown() {
        this.logger.info("Shutting down " + this + " with rtsp Stream " + this.rtspUrl);
        ((EtrovisionCameraSrv)this.getVideoSrv()).removeRTSPHandler(this.rtspHandler);
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public final void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public final void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public final void processData(byte[] data) {
        this.processRtpData(data);
    }
}

