/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.etrovision;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionCameraSrv;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class EtrovisionVideoSourceClientxx5x
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.etrovision.EtrovisionVideoSourceClientxx5x";
    private int streamNumber = 1;
    private EtrovisionDevice etrovisionDevice;

    @Override
    public final int init() {
        byte[] result = null;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.etrovisionDevice = (EtrovisionDevice)this.getVideoSrv().getDevice();
        this.networkParameter.setSoTimeout(5000);
        try {
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/config/stream_info.cgi", (int)Integer.MAX_VALUE, (boolean)true);
            String resolutionString = this.etrovisionDevice.readParameter(result, "resolutions");
            String[] resolutions = resolutionString.split(",");
            for (int i = 0; i < resolutions.length; ++i) {
                String[] res = resolutions[i].split("x");
                if (Integer.parseInt(res[0]) != this.width) continue;
                this.height = Integer.parseInt(res[1]);
            }
            String bitratesString = this.etrovisionDevice.readParameter(result, "vibrates");
            String[] bitrates = bitratesString.split(",");
            int[] bitrateValues = new int[bitrates.length];
            for (int i = 0; i < bitrates.length; ++i) {
                bitrateValues[i] = Integer.parseInt(bitrates[i]);
            }
            this.bandwidth = Tools.convertToCameraValues(bitrateValues, this.bandwidth / 1024);
            String framerateString = this.etrovisionDevice.readParameter(result, "framerates");
            String[] framerates = framerateString.split(",");
            int[] framerateArray = new int[framerates.length];
            for (int i = 0; i < framerateArray.length; ++i) {
                framerateArray[i] = Integer.parseInt(framerates[i]);
            }
            this.fps = Tools.convertToCameraValues(framerateArray, (int)(this.fps / 1000L));
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading camera parameters for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        if (((EtrovisionCameraSrv)this.getVideoSrv()).setVideoSourceParameters(this.getRotationAngle()) != 0) {
            this.logger.error("Error while setting Video Source parameters for " + this);
            return this.errorCode;
        }
        this.networkParameter.setSoTimeout(10000);
        this.streamNumber = this.listener instanceof BasicVideoProfileHandler ? 1 : 2;
        try {
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/config/video.cgi?profileid=" + this.streamNumber), (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading port information from camera for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        int rtspPort = Integer.parseInt(this.etrovisionDevice.readParameter(result, "port"));
        this.listener.getVideoSourceParameter().setRtspPort(rtspPort);
        StringBuilder sb = new StringBuilder("/config/video.cgi?profileid=" + this.streamNumber);
        sb.append("&resolution=" + this.width + "x" + this.height);
        sb.append("&framerate=" + this.fps);
        sb.append("&format=RTP");
        if (this.videoCodec == Codec.H264) {
            int iFrameDistance = this.iFrameDistMS / 1000;
            iFrameDistance = iFrameDistance > 2 ? 2 : iFrameDistance;
            iFrameDistance = iFrameDistance < 0 ? 0 : iFrameDistance;
            sb.append("&codec=H264");
            sb.append("&goplength=" + iFrameDistance);
            sb.append("&bitrate=" + this.bandwidth);
        } else {
            this.quality = this.quality / 20000 + 1;
            this.quality = this.quality > 5 ? 5 : this.quality;
            sb.append("&codec=MJPEG");
            sb.append("&goplength=1");
            sb.append("&quality=" + this.quality);
        }
        sb.append("&port=" + rtspPort);
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting video parameters for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.rtspUrl = "rtsp://" + this.getHost();
        this.rtspSettings = new RTSPStreamSettings();
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        int[] resolutionForCheck = new int[]{this.width, this.height};
        this.rtspSettings.setCheckResolution(true, resolutionForCheck);
        this.rtspSettings.setRTSPPort(rtspPort);
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while creating RTSP Handler for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("RTSPHandler.init failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public final void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final synchronized int shutdown() {
        ((EtrovisionCameraSrv)this.getVideoSrv()).removeRTSPHandler(this.rtspHandler);
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public final void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public final void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public final void processData(byte[] data) {
        this.processRtpData(data);
    }
}

