/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dynacolor;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.dynacolor.DynacolorDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.List;

public class DynacolorVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dynacolor.DynacolorVideoSourceClient";
    private String[][] videoProfileInformation;
    private boolean isMultiStreaming;

    @Override
    public int init() {
        try {
            String command;
            String cayuga_rtspPort;
            String camera_rtspPort;
            String cayuga_quality;
            String camera_quality;
            int otherStreamIndex;
            int myStreamIndex;
            String stream;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.networkParameter.setSoTimeout(5000);
            String list_parameters = "/cgi-bin/admin/param.cgi?action=list";
            String getParameters = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)list_parameters, (int)Integer.MAX_VALUE, (boolean)true));
            StringBuilder update_parameters = new StringBuilder();
            update_parameters.append("/cgi-bin/admin/param.cgi?action=update");
            HashMap<String, String> cameraParameters = new HashMap<String, String>();
            Tools.parseParameters(cameraParameters, getParameters);
            String camera_capture = (String)cameraParameters.get("root.ImageSource.I0.Video.DetectedType");
            String cayuga_capture = this.getVideoSrv().getDevice().getDeviceCnf().getCaptureMode().getDisplayResolution().toLowerCase();
            if (!cayuga_capture.equals("") && !camera_capture.equals(cayuga_capture)) {
                String value = cayuga_capture.equals("pal") ? "1" : "0";
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/cgi-bin/tvsystem.cgi?tvsystem=" + value), (int)Integer.MAX_VALUE, (boolean)true);
            }
            this.isMultiStreaming = this.videoProfileInformation.length != 1;
            int myVideoProfileID = this.getListener().getDynamicVideoProfileID();
            int otherVideoProfileID = myVideoProfileID == 0 ? 1 : 0;
            List<String> resolutionOrder = ((DynacolorDevice)this.getVideoSrv().getDevice()).getResolutionOrder();
            if (this.isMultiStreaming) {
                if (this.videoProfileInformation[0][2].equals("H264") && this.videoProfileInformation[1][2].equals("H264")) {
                    int otherResolutionIndex;
                    int myResolutionIndex = resolutionOrder.indexOf(this.videoProfileInformation[myVideoProfileID][1]);
                    if (myResolutionIndex >= (otherResolutionIndex = resolutionOrder.indexOf(this.videoProfileInformation[otherVideoProfileID][1]))) {
                        stream = "H264";
                        myStreamIndex = 1;
                        otherStreamIndex = 2;
                        this.rtspUrl = "rtsp://" + this.getHost() + "/h264";
                    } else {
                        stream = "H264_2";
                        myStreamIndex = 2;
                        otherStreamIndex = 1;
                        this.rtspUrl = "rtsp://" + this.getHost() + "/h264_2";
                    }
                } else if (this.videoCodec == Codec.H264) {
                    stream = "H264";
                    myStreamIndex = 1;
                    otherStreamIndex = 0;
                    this.rtspUrl = "rtsp://" + this.getHost() + "/h264";
                } else {
                    stream = "Mjpeg";
                    myStreamIndex = 0;
                    otherStreamIndex = 1;
                    this.rtspUrl = "rtsp://" + this.getHost() + "/jpeg";
                }
            } else if (this.videoCodec == Codec.H264) {
                stream = "H264";
                myStreamIndex = 1;
                otherStreamIndex = -1;
                this.rtspUrl = "rtsp://" + this.getHost() + "/h264";
            } else {
                stream = "Mjpeg";
                myStreamIndex = 0;
                otherStreamIndex = -1;
                this.rtspUrl = "rtsp://" + this.getHost() + "/jpeg";
            }
            String[] camera_resolutions = ((String)cameraParameters.get("root.Image.I0.Appearance.Resolution")).split(",");
            boolean changes = false;
            for (int i = 0; i < camera_resolutions.length; ++i) {
                if (i == myStreamIndex) {
                    if (camera_resolutions[i].equals(this.videoProfileInformation[myVideoProfileID][1])) continue;
                    camera_resolutions[i] = this.videoProfileInformation[myVideoProfileID][1];
                    changes = true;
                    continue;
                }
                if (i == otherStreamIndex) {
                    if (camera_resolutions[i].equals(this.videoProfileInformation[otherVideoProfileID][1])) continue;
                    camera_resolutions[i] = this.videoProfileInformation[otherVideoProfileID][1];
                    changes = true;
                    continue;
                }
                if (camera_resolutions[i].equals("disable")) continue;
                camera_resolutions[i] = "disable";
                changes = true;
            }
            if (changes) {
                update_parameters.append("&Image.I0.Appearance.Resolution=");
                for (String string : camera_resolutions) {
                    update_parameters.append(string).append(",");
                }
                update_parameters.deleteCharAt(update_parameters.length() - 1);
            }
            if (cameraParameters.containsKey("root.Image.I0.Appearance.Rotation")) {
                String cayuga_rotation;
                String camera_rotation = (String)cameraParameters.get("root.Image.I0.Appearance.Rotation");
                switch (this.rotationAngle) {
                    case 90: {
                        cayuga_rotation = "clockwise";
                        break;
                    }
                    case 180: {
                        cayuga_rotation = "rotate";
                        break;
                    }
                    case 270: {
                        cayuga_rotation = "counterclockwise";
                        break;
                    }
                    default: {
                        cayuga_rotation = "0";
                    }
                }
                if (!camera_rotation.equals(cayuga_rotation)) {
                    update_parameters.append("&Image.I0.Appearance.Rotation=").append(cayuga_rotation);
                }
            }
            if (cameraParameters.containsKey("root.Framerate." + stream)) {
                String cayuga_fps;
                String camera_fps = (String)cameraParameters.get("root.Framerate." + stream);
                if (!camera_fps.equals(cayuga_fps = String.valueOf(this.fps / 1000L)) || update_parameters.indexOf("Resolution") > 0) {
                    String fps_limit = this.isMultiStreaming ? (this.videoProfileInformation[myVideoProfileID][1].equals("1080p") && this.videoProfileInformation[otherVideoProfileID][1].equals("1080p") ? (cayuga_capture.equals("pal") ? "13" : "15") : (this.videoProfileInformation[myVideoProfileID][1].equals("3m") || this.videoProfileInformation[otherVideoProfileID][1].equals("3m") ? "15" : (cayuga_capture.equals("pal") ? "25" : "30"))) : (cayuga_capture.equals("pal") ? "25" : "30");
                    if (Float.parseFloat(cayuga_fps) < 1.0f) {
                        cayuga_fps = "1";
                    } else if (Float.parseFloat(cayuga_fps) > Float.parseFloat(fps_limit)) {
                        cayuga_fps = fps_limit;
                    }
                    update_parameters.append("&Framerate.").append(stream).append("=").append(cayuga_fps);
                }
            } else {
                float cayuga_fps = (float)this.fps / 1000.0f;
                String camera_frameskip = (String)cameraParameters.get("root.Frameskip." + stream);
                HashMap<Float, String> allowed = new HashMap<Float, String>();
                allowed.put(Float.valueOf(25.0f), "0");
                allowed.put(Float.valueOf(12.5f), "4");
                allowed.put(Float.valueOf(5.0f), "1");
                allowed.put(Float.valueOf(2.5f), "2");
                allowed.put(Float.valueOf(1.5f), "3");
                float[] allowed_fps = new float[]{1.5f, 2.5f, 5.0f, 12.5f, 25.0f};
                float convertToCameraValues = Tools.convertToCameraValues(allowed_fps, cayuga_fps);
                String cayuga_frameskip = (String)allowed.get(Float.valueOf(convertToCameraValues));
                if (!cayuga_frameskip.equals(camera_frameskip)) {
                    update_parameters.append("&Frameskip.H264=").append(cayuga_frameskip);
                }
            }
            if (this.videoCodec == Codec.MJPEG && !(camera_quality = (String)cameraParameters.get("root.Image.I0.Appearance.MjpegQfactor")).equals(cayuga_quality = String.valueOf((int)((double)this.quality * 6.9E-4) + 1))) {
                update_parameters.append("&Image.I0.Appearance.").append(stream).append("Qfactor=").append(cayuga_quality);
            }
            if (this.videoCodec == Codec.H264) {
                int convertIFrameDistMStoFrameCount;
                String camera_iframe;
                String cayuga_bandwith;
                String camera_bandwith;
                String cayuga_ratecontrol;
                String camera_ratecontrol = (String)cameraParameters.get("root.Image.I0.RateControl.H264Mode");
                String string = cayuga_ratecontrol = this.isConstantBitrateUsed ? "cbr" : "vbr";
                if (!camera_ratecontrol.equals(cayuga_ratecontrol)) {
                    update_parameters.append("&Image.I0.RateControl.").append(stream).append("Mode=").append(cayuga_ratecontrol);
                }
                if (this.isConstantBitrateUsed && !(camera_bandwith = (String)cameraParameters.get("root.Image.I0.Appearance.H264Bitrate")).equals(cayuga_bandwith = String.valueOf(this.bandwidth / 1024))) {
                    if (Float.parseFloat(cayuga_bandwith) < 64.0f) {
                        cayuga_bandwith = "64";
                    } else if (!cameraParameters.containsKey("root.Framerate." + stream) && Float.parseFloat(cayuga_bandwith) > 4096.0f) {
                        cayuga_bandwith = "4096";
                    } else if (Float.parseFloat(cayuga_bandwith) > 8192.0f) {
                        cayuga_bandwith = "8192";
                    }
                    update_parameters.append("&Image.I0.Appearance.").append(stream).append("Bitrate=").append(cayuga_bandwith);
                }
                if (!(camera_iframe = (String)cameraParameters.get("root.Image.I0.Appearance.H264VideoKeyFrameInterval")).equals(String.valueOf(convertIFrameDistMStoFrameCount = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 2, 64))) || update_parameters.indexOf("Resolution") > 0) {
                    update_parameters.append("&Image.I0.Appearance.").append(stream).append("VideoKeyFrameInterval=").append(String.valueOf(convertIFrameDistMStoFrameCount));
                }
            }
            if (!(camera_rtspPort = (String)cameraParameters.get("root.Network.RTSP.Port")).equals(cayuga_rtspPort = String.valueOf(this.listener.getVideoSourceParameter().getRtspPort()))) {
                update_parameters.append("&Network.RTSP.Port=").append(cayuga_rtspPort);
            }
            boolean camera_useTitle = ((String)cameraParameters.get("root.Image.I0.Text.TextEnabled")).equals("yes");
            boolean camera_useDate = ((String)cameraParameters.get("root.Image.I0.Text.DateEnabled")).equals("yes");
            boolean camera_useTime = ((String)cameraParameters.get("root.Image.I0.Text.ClockEnabled")).equals("yes");
            String camera_title = (String)cameraParameters.get("root.Image.I0.Text.String");
            boolean cayuga_useDateAndTime = this.useDateTime;
            boolean cayuga_useTitle = this.useTitle;
            String cayuga_title = this.title;
            if (cayuga_useDateAndTime && (!camera_useDate || !camera_useTime) || !cayuga_useDateAndTime && (camera_useDate || camera_useTime)) {
                update_parameters.append("&Image.I0.Text.DateEnabled=").append(cayuga_useDateAndTime ? "yes" : "no").append("&Image.I0.Text.ClockEnabled=").append(cayuga_useDateAndTime ? "yes" : "no");
            }
            if (cayuga_useTitle != camera_useTitle) {
                update_parameters.append("&Image.I0.Text.TextEnabled=").append(this.useTitle ? "yes" : "no");
                if (cayuga_useTitle) {
                    update_parameters.append("&Image.I0.Text.String=").append(cayuga_title);
                }
            } else if (cayuga_useTitle && !camera_title.equals(cayuga_title)) {
                update_parameters.append("&Image.I0.Text.String=").append(cayuga_title);
            }
            if (cameraParameters.containsKey("root.Properties.Audio.Audio") && ((String)cameraParameters.get("root.Properties.Audio.Audio")).equals("yes")) {
                String camera_audio = (String)cameraParameters.get("root.Audio.DuplexMode");
                String audio_bitRate = (String)cameraParameters.get("root.AudioSource.A0.BitRate");
                if (this.isAudioEnabled) {
                    if (!camera_audio.equals("get")) {
                        update_parameters.append("&Audio.DuplexMode=get");
                    }
                    if (!audio_bitRate.equals("ulaw")) {
                        update_parameters.append("&AudioSource.A0.BitRate=ulaw");
                    }
                } else if (!camera_audio.equals("disable")) {
                    update_parameters.append("&Audio.DuplexMode=disable");
                }
            }
            if (!update_parameters.toString().equals("/cgi-bin/admin/param.cgi?action=update") && ((command = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)update_parameters.toString(), (int)Integer.MAX_VALUE, (boolean)true))).contains("Error:command time out") || update_parameters.indexOf("Framerate") > 0) && (command = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)update_parameters.toString(), (int)Integer.MAX_VALUE, (boolean)true))).contains("Error:command time out")) {
                this.logger.error("Two times in a row we get an time out error from the camera sending new parameters. Shutdown of VideoSourceClient");
                this.shutdown();
            }
            this.rtspSettings = new RTSPStreamSettings();
            if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4) != 0) {
                this.logger.error("Error while initializing RTSP settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.logger.info("Init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initialization for " + this);
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (ConfigurationException t) {
            this.logger.error("Unexpected exception while initialization for " + this);
            this.logger.error((Object)t, (Throwable)t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    public void setInformation(String[][] info) {
        this.videoProfileInformation = info;
    }
}

