/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dynacolor;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.dynacolor.DynacolorIOHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;

public class DynacolorDevice
extends VideoServer {
    @Override
    protected IOHandler createIOHandler() {
        return new DynacolorIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public String getResolutionTag(int[] resolution) {
        return this.getResolutionTag(resolution[0], resolution[1]);
    }

    public String getResolutionTag(int width, int height) {
        if (width == 352) {
            return "cif";
        }
        if (width == 640) {
            return "vga";
        }
        if (width == 720) {
            return "d1";
        }
        if (width == 800) {
            return "svga";
        }
        if (width == 1024) {
            return "xga";
        }
        if (width == 1280) {
            if (height == 720) {
                return "720p";
            }
            return "sxga";
        }
        if (width == 1920) {
            return "1080p";
        }
        if (width == 2048) {
            return "3m";
        }
        if (width == 2592) {
            return "5m";
        }
        return "1080p";
    }

    public List<String> getResolutionOrder() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("cif");
        result.add("vga");
        result.add("d1");
        result.add("svga");
        result.add("xga");
        result.add("720p");
        result.add("sxga");
        result.add("1080p");
        result.add("3m");
        result.add("5m");
        return result;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

