/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dynacolor;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.dynacolor.DynacolorCameraControl;
import de.seetec.v5.re.cm.device.video.dynacolor.DynacolorDevice;
import de.seetec.v5.re.cm.device.video.dynacolor.DynacolorHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.dynacolor.DynacolorHardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.dynacolor.DynacolorVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class DynacolorCameraSrv
extends LiveCameraSrv {
    private String[][] videoProfileInformation;
    private boolean tamperingEnabled = false;

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DynacolorCameraControl();
    }

    private void getInfomration() {
        try {
            VideoProfileHandler[] videoProfileHandlers = this.getAdditionalVideoProfileHandler();
            VideoProfileHandler basicProfileHandler = this.getBasicVideoProfileHandler();
            this.videoProfileInformation = this.device.getDeviceType() == 204150L && videoProfileHandlers.length == 0 ? new String[2][3] : new String[videoProfileHandlers.length + 1][3];
            this.videoProfileInformation[0][0] = String.valueOf(basicProfileHandler.getDynamicVideoProfileID());
            this.videoProfileInformation[0][1] = ((DynacolorDevice)this.getDevice()).getResolutionTag(basicProfileHandler.getVideoSourceParameter().getImageSize());
            this.videoProfileInformation[0][2] = basicProfileHandler.getVideoSourceParameter().getMediaCodec().name();
            for (int i = 0; i < videoProfileHandlers.length; ++i) {
                this.videoProfileInformation[i + 1][0] = String.valueOf(videoProfileHandlers[i].getDynamicVideoProfileID());
                this.videoProfileInformation[i + 1][1] = ((DynacolorDevice)this.getDevice()).getResolutionTag(videoProfileHandlers[i].getVideoSourceParameter().getImageSize());
                this.videoProfileInformation[i + 1][2] = videoProfileHandlers[i].getVideoSourceParameter().getMediaCodec().name();
            }
            if (this.device.getDeviceType() == 204150L && videoProfileHandlers.length == 0) {
                this.videoProfileInformation[1][0] = "1";
                this.videoProfileInformation[1][1] = "d1";
                this.videoProfileInformation[1][2] = "H264";
            }
        }
        catch (ConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        this.getInfomration();
        DynacolorVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        videoSourceClient = new DynacolorVideoSourceClient();
        videoSourceClient.setInformation(this.videoProfileInformation);
        int errorCode = videoSourceClient.init(core, this, listener);
        if (errorCode != 0) {
            videoSourceClient.shutdown();
            videoSourceClient = null;
            this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
            if (errorCode == HTTPStatusCode.HTTP_NOT_FOUND.getStatusCode()) {
                throw new SeeTecException(-21656, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
            throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
        }
        try {
            if (this.getVideoSourceCnf().isEnableTampering()) {
                long[] nTypeList = new long[]{9808L};
                Entity[] entities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, nTypeList);
                if (!this.tamperingEnabled && entities.length == 0) {
                    this.logger.info("No hardware motion detection entities enabled. Start tampering for " + this);
                    DynacolorHardwareMotionDetectionCnf dynacolorHardwareMotionDetectionCnf = new DynacolorHardwareMotionDetectionCnf();
                    HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf = new HardwareMotionDetectionCnf[]{dynacolorHardwareMotionDetectionCnf};
                    this.hardwareMotionDetection = new DynacolorHardwareMotionDetection();
                    this.hardwareMotionDetection.init(this, hardwareMotionDetectionCnf);
                    this.tamperingEnabled = true;
                }
            }
        }
        catch (Throwable ex) {
            videoSourceClient.shutdown();
            videoSourceClient = null;
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }
}

