/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dlink;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraPropertyHandler;
import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraSrv;
import de.seetec.v5.re.cm.device.video.dlink.DLinkDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.SeeTecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class DLinkVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dlink.DLinkVideoSourceClient";

    @Override
    public DLinkCameraSrv getVideoSrv() {
        return (DLinkCameraSrv)super.getVideoSrv();
    }

    public DLinkDevice getDevice() {
        return this.getVideoSrv().getDevice();
    }

    public DLinkCameraPropertyHandler getCameraPropertyHandler() {
        return this.getDevice().getCameraPropertyHandler();
    }

    @Override
    public int init() {
        try {
            String[] res;
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = 0;
            this.printDebug = false;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                throw new SeeTecException(this.errorCode, "Error while initializing. Code: " + this.errorCode + " for " + this);
            }
            String codecStr = "MJPEG";
            if (this.videoCodec == Codec.H264) {
                codecStr = "H.264";
            } else if (this.videoCodec == Codec.MJPEG) {
                codecStr = "MJPEG";
            } else if (this.videoCodec == Codec.MPEG4) {
                codecStr = "MPEG4";
            }
            ArrayList<Integer> allowedFramerates = new ArrayList<Integer>();
            for (String s : res = this.getCameraPropertyHandler().getProperty(DLinkCameraPropertyHandler.CATEGORY.STREAM_SETTINGS, "framerates").split(",")) {
                allowedFramerates.add(Integer.parseInt(s));
            }
            int fpsVal = Tools.getNearestAllowedValue(allowedFramerates, (int)(this.fps / 1000L));
            String[] availableQualities = this.getCameraPropertyHandler().getProperty(DLinkCameraPropertyHandler.CATEGORY.STREAM_SETTINGS, "qualities").split(",");
            int qIndex = availableQualities.length - (int)((double)this.quality / (100000.0 / (double)availableQualities.length) + 1.0);
            if (qIndex < 0) {
                qIndex = 0;
            }
            if (qIndex > availableQualities.length - 1) {
                qIndex = availableQualities.length - 1;
            }
            String qualityStr = "" + qIndex;
            int gop = (int)((double)fpsVal * ((double)this.iFrameDistMS / 1000.0));
            gop = gop < 1 ? 1 : gop;
            gop = gop > 30 ? 30 : gop;
            String gopStr = String.valueOf(gop);
            String[] availableBitrates = this.getCameraPropertyHandler().getProperty(DLinkCameraPropertyHandler.CATEGORY.STREAM_SETTINGS, "vbitrates").split(",");
            ArrayList<Integer> allowedBitrates = new ArrayList<Integer>();
            for (String br : availableBitrates) {
                if (br.toUpperCase().endsWith("K")) {
                    br = br.toUpperCase().replaceFirst("K", "");
                    allowedBitrates.add(Integer.parseInt(br));
                    continue;
                }
                if (br.toUpperCase().endsWith("M")) {
                    br = br.toUpperCase().replaceFirst("M", "");
                    allowedBitrates.add(Integer.parseInt(br) * 1024);
                    continue;
                }
                this.logger.error("Unknown bitrate found " + br);
            }
            int bitrate = Tools.getNearestAllowedValue(allowedBitrates, this.bandwidth / 1024);
            String bitrateStr = bitrate > 1023 ? "" + bitrate / 1024 + "M" : "" + bitrate + "K";
            boolean isPal = Tools.getNearestAspectRatio(this.width, this.height).equals((Object)Tools.ASPECTRATIO.ASPECTRATIO_4_3);
            this.getCameraPropertyHandler().setDebug(this.printDebug);
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_TYPE_SETTINGS, "profilenumber", "1");
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_TYPE_SETTINGS, "aspectratio", isPal ? "4:3" : "16:9");
            this.getCameraPropertyHandler().save(DLinkCameraPropertyHandler.CATEGORY.VIDEO_TYPE_SETTINGS);
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.SENSOR_SETTINGS, "videoinformat", isPal ? "PAL" : "NTSC");
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.SENSOR_SETTINGS, "flip", this.rotationAngle == 180 ? "on" : "off");
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.SENSOR_SETTINGS, "mirror", this.rotationAngle == 180 ? "on" : "off");
            this.getCameraPropertyHandler().save(DLinkCameraPropertyHandler.CATEGORY.SENSOR_SETTINGS);
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.DATETIME_SETTINGS, "date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.DATETIME_SETTINGS, "time", new SimpleDateFormat("HH:mm:ss").format(new Date()));
            this.getCameraPropertyHandler().save(DLinkCameraPropertyHandler.CATEGORY.DATETIME_SETTINGS);
            this.getCameraPropertyHandler().load(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "profileid=1");
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "profileid", "1");
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "resolution", this.width + "x" + this.height);
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "viewwindow", this.width + "x" + this.height);
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "framerate", "" + fpsVal);
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "codec", codecStr);
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "quality", qualityStr);
            if (this.videoCodec == Codec.H264) {
                this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "qualitymode", this.isConstantBitrateUsed ? "CBR" : "Fixquality");
                this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "goplength", gopStr);
                this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS, "bitrate", bitrateStr);
            }
            this.getCameraPropertyHandler().save(DLinkCameraPropertyHandler.CATEGORY.VIDEO_SETTINGS);
            if (this.isAudioEnabled) {
                this.getCameraPropertyHandler().load(DLinkCameraPropertyHandler.CATEGORY.AUDIO_SETTINGS, "profileid=1");
                this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.AUDIO_SETTINGS, "profileid", "1");
                if (this.audioCodec == Codec.G711U) {
                    this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.AUDIO_SETTINGS, "codec", "G.711");
                } else if (this.audioCodec == Codec.G726) {
                    this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.AUDIO_SETTINGS, "codec", "G.726");
                    this.audioBitrate = 64000;
                }
                this.getCameraPropertyHandler().save(DLinkCameraPropertyHandler.CATEGORY.AUDIO_SETTINGS);
            }
            int rtspPort = Integer.parseInt(this.getCameraPropertyHandler().getProperty(DLinkCameraPropertyHandler.CATEGORY.NETWORK_SETTINGS, "rtspport"));
            this.getCameraPropertyHandler().load(DLinkCameraPropertyHandler.CATEGORY.RTSP_SETTINGS, "profileid=1");
            this.getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.RTSP_SETTINGS, "profileid", "1");
            String rtspSite = this.getCameraPropertyHandler().getProperty(DLinkCameraPropertyHandler.CATEGORY.RTSP_SETTINGS, "urlentry");
            this.rtspUrl = "rtsp://" + this.networkParameter.getHost() + ":" + rtspPort + "/" + rtspSite;
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, rtspPort, this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                throw new SeeTecException(this.errorCode, "Initialization of RTSPSettings failed with errorCode " + this.errorCode + " for " + this.getVideoSrv());
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.rtspHandler.start();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception in DLinkVideoSourceClient!.init occured!", (Throwable)ex);
            this.errorCode = ex.getErrorCode();
        }
        return this.errorCode;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }
}

