/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dlink;

import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraPropertyChangedListener;
import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraPropertyHandler;
import de.seetec.v5.re.cm.device.video.dlink.DLinkDevice;
import de.seetec.v5.shared.util.SeeTecException;

public class DLinkIOHandler
extends IOHandler
implements DLinkCameraPropertyChangedListener {
    public DLinkDevice getDevice() {
        return (DLinkDevice)this.device;
    }

    @Override
    public void run() {
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] ");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            this.getDevice().getCameraPropertyHandler().setProperty(DLinkCameraPropertyHandler.CATEGORY.IO_SETTINGS, "out" + outputNumber, value == 0 ? "off" : "on");
            this.getDevice().getCameraPropertyHandler().save(DLinkCameraPropertyHandler.CATEGORY.IO_SETTINGS);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [ " + errorCode + " ] :-( ");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while writing digital output for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public String[] getRegisteredProperties() {
        return new String[]{"input", "output"};
    }

    @Override
    public void propertyChangedEvent(String property, String value) {
        try {
            int iVal = value.equals("on") ? 1 : 0;
            int intputNumber = Integer.parseInt(property.substring(property.length() - 1, property.length())) - 1;
            if (super.getDigitalInputSrv().length > intputNumber + 1) {
                super.getDigitalInputSrv()[2 * intputNumber].checkInput(iVal);
                super.getDigitalInputSrv()[2 * intputNumber + 1].checkInput(iVal);
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception in DLinkIOHandler.propertyChangedEvent! Digital input not processed!", (Throwable)ex);
        }
    }
}

