/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dlink;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraPropertyChangedHandler;
import de.seetec.v5.re.cm.device.video.dlink.DLinkCameraPropertyHandler;
import de.seetec.v5.re.cm.device.video.dlink.DLinkIOHandler;
import de.seetec.v5.shared.util.SeeTecException;

public class DLinkDevice
extends VideoServer {
    private DLinkCameraPropertyHandler cameraPropertyHandler;
    private DLinkCameraPropertyChangedHandler cameraPropertyChangedHandler;

    @Override
    public int initializeDevice(long nSrvType) {
        super.initializeDevice(nSrvType);
        int errorCode = 0;
        try {
            if (this.cameraPropertyHandler == null) {
                this.cameraPropertyHandler = new DLinkCameraPropertyHandler(this.getDeviceCnf());
                this.cameraPropertyHandler.setDebug(false);
                this.cameraPropertyHandler.load(DLinkCameraPropertyHandler.CATEGORY.BASIC_SETTINGS);
            }
            if (this.cameraPropertyChangedHandler == null || !this.cameraPropertyChangedHandler.isAlive()) {
                this.cameraPropertyChangedHandler = new DLinkCameraPropertyChangedHandler(this);
                this.cameraPropertyChangedHandler.setDebug(false);
                this.cameraPropertyChangedHandler.register(this.getIOHandler());
                this.cameraPropertyChangedHandler.start();
            }
        }
        catch (SeeTecException se) {
            this.logger.error("SeeTecException in DLinkDevice.initializeDevice!", (Throwable)se);
            errorCode = se.getErrorCode();
        }
        return errorCode;
    }

    public DLinkCameraPropertyChangedHandler getCameraPropertyChangedHandler() {
        return this.cameraPropertyChangedHandler;
    }

    public DLinkCameraPropertyHandler getCameraPropertyHandler() {
        return this.cameraPropertyHandler;
    }

    @Override
    protected DLinkIOHandler createIOHandler() {
        return new DLinkIOHandler();
    }

    @Override
    public DLinkIOHandler getIOHandler() {
        return (DLinkIOHandler)super.getIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    public int shutdown() {
        int errorCode = super.shutdown();
        if (this.cameraPropertyChangedHandler != null) {
            this.cameraPropertyChangedHandler.shutdown();
        }
        if (this.cameraPropertyHandler != null) {
            this.cameraPropertyHandler = null;
        }
        return errorCode;
    }
}

