/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dlink;

import de.seetec.v5.re.cm.device.video.dlink.DLinkNetworkHelper;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLinkCameraPropertyHandler {
    private static final EnumMap<CATEGORY, String> urls = new EnumMap(CATEGORY.class);
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private boolean debug = false;
    private DeviceCnf deviceCnf;
    private final List<String> changedProperties = new ArrayList<String>();
    private final EnumMap<CATEGORY, Properties> properties = new EnumMap(CATEGORY.class);
    private final EnumMap<CATEGORY, String> requestProperties = new EnumMap(CATEGORY.class);

    public DLinkCameraPropertyHandler(DeviceCnf deviceCnf) {
        this.deviceCnf = deviceCnf;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getProperty(CATEGORY category, String key) throws SeeTecException {
        if (!this.properties.containsKey((Object)category)) {
            this.load(category);
        }
        return this.properties.get((Object)category).getProperty(key);
    }

    public void setProperty(CATEGORY category, String key, String value) throws SeeTecException {
        String existingValue;
        if (!this.properties.containsKey((Object)category)) {
            this.load(category);
        }
        if ((existingValue = this.properties.get((Object)category).getProperty(key)) != null && existingValue.equals(value)) {
            if (this.debug) {
                this.logger.info("Property " + key + " not changed!");
            }
        } else {
            if (this.debug && existingValue != null) {
                this.logger.info("Property " + key + " changed from " + existingValue + " to " + value);
            } else if (this.debug) {
                this.logger.info("Property " + key + " set to " + value);
            }
            this.properties.get((Object)category).setProperty(key, value);
            this.changedProperties.add(category.toString() + "." + key);
        }
    }

    public Properties getProperties(CATEGORY category) throws SeeTecException {
        if (!this.properties.containsKey((Object)category)) {
            this.load(category);
        }
        return this.properties.get((Object)category);
    }

    public void save(CATEGORY category) throws SeeTecException {
        StringBuilder parameterSet = new StringBuilder("");
        for (Object key : this.properties.get((Object)category).keySet()) {
            if (!this.changedProperties.contains(category.toString() + "." + key.toString())) continue;
            String value = this.properties.get((Object)category).getProperty(key.toString());
            parameterSet.append(key).append("=").append(value).append("&");
        }
        String parameter = parameterSet.toString();
        if (parameter.endsWith("&")) {
            parameter = parameter.substring(0, parameter.length() - 1);
            try {
                String requestUrl = this.requestProperties.get((Object)category) == null ? urls.get((Object)category) + "?" + parameter : urls.get((Object)category) + "?" + this.requestProperties.get((Object)category) + "&" + parameter;
                NetworkParameter networkParameter = this.getNetworkParameter();
                String result = new String(DLinkNetworkHelper.readGetRequest(networkParameter, requestUrl));
                if (this.debug) {
                    this.logger.info("Requested url: " + requestUrl);
                    this.logger.info("Result is: " + result);
                }
                this.changedProperties.clear();
            }
            catch (ConfigurationException | IOException e) {
                this.logger.error("Exception in DLinkCameraPropertyHandler.save [" + e.getMessage() + "]");
            }
        } else if (this.debug) {
            this.logger.info("Nothing to save in DLinkCameraPropertyHandler.save!");
        }
    }

    private NetworkParameter getNetworkParameter() throws ConfigurationException {
        return this.deviceCnf.getNetworkParameter();
    }

    public void load(CATEGORY category) throws SeeTecException {
        this.load(category, null);
    }

    public void load(CATEGORY category, String requestParameter) throws SeeTecException {
        HttpURLConnection c = null;
        try {
            String url = urls.get((Object)category);
            if (requestParameter != null) {
                url = url + "?" + requestParameter;
                this.requestProperties.put(category, requestParameter);
            }
            NetworkParameter networkParameter = this.getNetworkParameter();
            c = DLinkNetworkHelper.getHttpURLConnection(networkParameter, url);
            Properties temp = new Properties();
            temp.load(c.getInputStream());
            this.properties.put(category, temp);
            if (this.debug) {
                for (Object key : temp.keySet()) {
                    this.logger.info(category.toString() + "." + key.toString() + "=" + temp.getProperty(key.toString()));
                }
            }
        }
        catch (ConfigurationException | IOException e) {
            int responseCode = 0;
            if (c != null) {
                try {
                    responseCode = c.getResponseCode();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.properties.remove((Object)category);
            if (responseCode == 401) {
                throw new SeeTecException(-21657, "Properties for DLink category " + category.toString() + " not loaded. Message: " + e.getMessage());
            }
            throw new SeeTecException(-20001, "Properties for DLink category " + category.toString() + " not loaded. Message: " + e.getMessage());
        }
    }

    static {
        urls.put(CATEGORY.BASIC_SETTINGS, "/common/info.cgi");
        urls.put(CATEGORY.NETWORK_SETTINGS, "/config/network.cgi");
        urls.put(CATEGORY.CAMERA_SETTINGS, "/config/camera_info.cgi");
        urls.put(CATEGORY.SENSOR_SETTINGS, "/config/sensor.cgi");
        urls.put(CATEGORY.VIDEO_TYPE_SETTINGS, "/config/video_type.cgi");
        urls.put(CATEGORY.STREAM_SETTINGS, "/config/stream_info.cgi");
        urls.put(CATEGORY.RTSP_SETTINGS, "/config/rtspurl.cgi");
        urls.put(CATEGORY.AUDIO_SETTINGS, "/config/audio.cgi");
        urls.put(CATEGORY.VIDEO_SETTINGS, "/config/video.cgi");
        urls.put(CATEGORY.NOTIFICATION_SETTINGS, "/config/notify.cgi");
        urls.put(CATEGORY.IO_SETTINGS, "/config/io.cgi");
        urls.put(CATEGORY.DATETIME_SETTINGS, "/config/datetime.cgi");
    }

    public static enum CATEGORY {
        BASIC_SETTINGS,
        NETWORK_SETTINGS,
        CAMERA_SETTINGS,
        SENSOR_SETTINGS,
        AUDIO_SETTINGS,
        VIDEO_TYPE_SETTINGS,
        VIDEO_SETTINGS,
        STREAM_SETTINGS,
        RTSP_SETTINGS,
        NOTIFICATION_SETTINGS,
        IO_SETTINGS,
        DATETIME_SETTINGS;

    }
}

