/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.digigram;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpRTPReaderUnicast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;

public final class DigigramAudioSourceClient
extends StreamingVideoSourceClientRTSP
implements RTSPHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.digigram.DigigramAudioSourceClient";
    private UdpRTPReaderUnicast udpReader;

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.rtspSettings = new RTSPStreamSettings();
        this.rtspSettings.setIsVideoEnabled(false);
        this.rtspSettings.setCallback(this);
        int httpPort = this.networkParameter.getHTTPport();
        this.udpReader = new UdpRTPReaderUnicast(this, httpPort);
        this.udpReader.init(524288, 10000, true, 65535);
        this.logger.info("UDP port '" + this.udpReader.getPort() + "' opened for " + this);
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.udpReader != null) {
            this.udpReader.shutdown();
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        if (this.audioSourceClient != null) {
            this.audioSourceClient.processData(data);
        }
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

