/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dallmeier.onvif;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.dallmeier.DallmeierDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.AudioEncoderConfiguration;
import org.onvif.ver10.schema.AudioEncoding;
import org.onvif.ver10.schema.H264Configuration;
import org.onvif.ver10.schema.H264Profile;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.TransportProtocol;
import org.onvif.ver10.schema.VideoEncoderConfiguration;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoEncoding;
import org.onvif.ver10.schema.VideoRateControl;
import org.onvif.ver10.schema.VideoResolution;
import org.onvif.ver10.schema.VideoSourceConfiguration;

public class DallmeierOnvifVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dallmeier.onvif.DallmeierOnvifVideoSourceClient";

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            Profile profile;
            Media mediaService;
            OnvifCore onvifCore;
            block41: {
                DallmeierDevice dallmeierDevice = (DallmeierDevice)this.getVideoSrv().getDevice();
                onvifCore = dallmeierDevice.getOnvifCore();
                mediaService = onvifCore.getMediaService().getOnvifMediaService();
                IntRange bitrateRange = new IntRange();
                bitrateRange.setMin(512);
                bitrateRange.setMax(8000);
                profile = (Profile)mediaService.getProfiles().get(0);
                VideoSourceConfiguration videoSourceConfiguration = mediaService.getVideoSourceConfiguration("source1");
                VideoEncoderConfiguration videoEncoderConfiguration = mediaService.getVideoEncoderConfiguration("encoder1");
                profile.setVideoSourceConfiguration(videoSourceConfiguration);
                profile.setVideoEncoderConfiguration(videoEncoderConfiguration);
                VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = mediaService.getVideoEncoderConfigurationOptions(videoEncoderConfiguration.getToken(), profile.getToken());
                if (this.videoCodec == Codec.H264) {
                    videoEncoderConfiguration.setEncoding(VideoEncoding.H_264);
                } else {
                    videoEncoderConfiguration.setEncoding(VideoEncoding.JPEG);
                }
                VideoResolution videoResolution = videoEncoderConfiguration.getResolution();
                videoResolution.setWidth(this.width);
                videoResolution.setHeight(this.height);
                videoEncoderConfiguration.setResolution(videoResolution);
                this.quality /= 1000;
                this.quality = this.quality * (videoEncoderConfigurationOptions.getQualityRange().getMax() - videoEncoderConfigurationOptions.getQualityRange().getMin()) / 100;
                this.quality += videoEncoderConfigurationOptions.getQualityRange().getMin();
                videoEncoderConfiguration.setQuality((float)this.quality);
                VideoRateControl videoRateControl = new VideoRateControl();
                this.fps = this.fps < 1000L ? 1000L : this.fps;
                this.fps /= 1000L;
                IntRange fpsRange = null;
                if (this.videoCodec == Codec.H264) {
                    fpsRange = videoEncoderConfigurationOptions.getH264().getFrameRateRange();
                } else if (this.videoCodec == Codec.MJPEG) {
                    fpsRange = videoEncoderConfigurationOptions.getJPEG().getFrameRateRange();
                }
                if (fpsRange != null) {
                    if (this.fps < (long)fpsRange.getMin()) {
                        this.fps = fpsRange.getMin();
                    } else if (this.fps > (long)fpsRange.getMax()) {
                        this.fps = fpsRange.getMax();
                    }
                }
                videoRateControl.setFrameRateLimit((int)this.fps);
                videoRateControl.setEncodingInterval(1);
                int bitrate = this.bandwidth / 1024;
                if (bitrate <= bitrateRange.getMin()) {
                    bitrate = bitrateRange.getMin();
                } else if (bitrate >= bitrateRange.getMax()) {
                    bitrate = bitrateRange.getMax();
                }
                if (this.videoCodec == Codec.MJPEG) {
                    bitrate = bitrateRange.getMax() / 2;
                }
                videoRateControl.setBitrateLimit(bitrate);
                videoEncoderConfiguration.setRateControl(videoRateControl);
                if (this.videoCodec == Codec.H264) {
                    IntRange govRange = videoEncoderConfigurationOptions.getH264().getGovLengthRange();
                    int[] govValues = new int[]{1, 2, 3, 4, 5, 6, 10, 15};
                    this.fps *= 1000L;
                    int govLength = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, govRange.getMin(), govRange.getMax());
                    this.fps /= 1000L;
                    govLength = Tools.convertToCameraValues(govValues, govLength);
                    this.logger.info("GOV: " + govLength);
                    H264Configuration h264Configuration = new H264Configuration();
                    h264Configuration.setGovLength(govLength);
                    h264Configuration.setH264Profile(H264Profile.BASELINE);
                    videoEncoderConfiguration.setH264(h264Configuration);
                } else if (this.videoCodec == Codec.MJPEG) {
                    videoEncoderConfiguration.setH264(null);
                }
                this.logger.info("Set new VideoEncoderConfig!");
                try {
                    mediaService.setVideoEncoderConfiguration(videoEncoderConfiguration, true);
                }
                catch (Exception exception) {
                    this.logger.warn("Configuration could not be set");
                    if (exception.getCause().getMessage().contains("401: Unauthorized")) {
                        this.logger.warn("=> Authorization failed");
                    }
                    if (!exception.getCause().getMessage().contains("Invalid QName in mapping: ter:InvalidArgVal")) break block41;
                    this.logger.warn("=> Invalid arguments");
                }
            }
            try {
                if (this.isAudioEnabled) {
                    AudioEncoding audioEncoding = null;
                    if (this.audioCodec == Codec.G711U) {
                        this.audioCodec = Codec.G711A;
                        audioEncoding = AudioEncoding.G_711;
                    }
                    AudioEncoderConfiguration audioEncoderConfiguration = profile.getAudioEncoderConfiguration();
                    audioEncoderConfiguration.setEncoding(audioEncoding);
                    if (audioEncoding == AudioEncoding.G_711) {
                        audioEncoderConfiguration.setBitrate(64);
                        audioEncoderConfiguration.setSampleRate(8);
                    }
                    mediaService.setAudioEncoderConfiguration(audioEncoderConfiguration, true);
                } else {
                    if (profile.getAudioSourceConfiguration() != null) {
                        mediaService.removeAudioSourceConfiguration(profile.getToken());
                    }
                    if (profile.getAudioEncoderConfiguration() != null) {
                        mediaService.removeAudioEncoderConfiguration(profile.getToken());
                    }
                }
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                this.logger.warn("Audio configuration could not be set");
                this.logger.info((Object)exception);
                this.isAudioEnabled = false;
            }
            try {
                String streamUri = onvifCore.getMediaService().getStreamUri(profile.getToken(), StreamType.RTP_UNICAST, TransportProtocol.UDP);
                this.logger.info("=======================");
                this.logger.info("Profile: " + profile.getToken());
                this.logger.info("VideoSourceConfiguration: " + profile.getVideoSourceConfiguration().getToken());
                this.logger.info("VideoEncoderConfiguration: " + profile.getVideoEncoderConfiguration().getToken());
                if (this.isAudioEnabled) {
                    this.logger.info("AudioSourceConfiguration: " + profile.getAudioSourceConfiguration().getToken());
                    this.logger.info("AudioEncoderConfiguration: " + profile.getAudioEncoderConfiguration().getToken());
                }
                this.logger.info("StreamUri: " + streamUri);
                this.logger.info("=======================");
                this.rtspUrl = streamUri;
            }
            catch (Exception exception) {
                this.logger.warn("GetStreamURI is not available");
                if (exception.getCause().getMessage().contains("401: Unauthorized")) {
                    this.logger.warn("=> Authorization failed");
                    return -21657;
                }
                if (exception.getCause().getMessage().contains("Invalid QName in mapping: ter:InvalidArgVal")) {
                    this.logger.warn("=> Invalid arguments");
                    return -21601;
                }
                return -21600;
            }
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            this.logger.info(exception.getMessage() + this);
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 2, this.rtspUrl) != 0) {
                this.logger.error("Error while initializing RTSP Settings for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("RTSPHandler.init failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

