/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dallmeier.mpeg;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReaderUnicast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.net.Socket;

public class DallmeierMPEGVideoSourceClient
extends StreamingVideoSourceClientRTSP
implements NetworkCallback {
    static final String DISCONNECT_URL = "/dlm/disconnect";
    static final String CONFIG_URL = "/dlm/config";
    static final String SHOWLIVE_URL = "/dlm/showLive";
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dallmeier.mpeg.DallmeierMPEGVideoSourceClient";
    private UdpReaderUnicast udpReader = null;
    private int resolutionValue = Integer.MIN_VALUE;
    private int iFrameDistValue = Integer.MIN_VALUE;
    private int encodingMode = Integer.MIN_VALUE;

    @Override
    public int init() {
        this.logger.info("init started for" + this.getVideoSrv());
        this.completeFrame = new ByteArrayOutputStream();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.iFrameDist /= 1000L;
        this.bandwidth /= 1024;
        this.fps /= 1000L;
        byte[] result = null;
        String[] userPasswd = new String[2];
        if (this.networkParameter.getUserPWD() != null) {
            userPasswd = this.networkParameter.getUserPWD();
        }
        String resolveHost = new LteHostResolver(this.getCore().getLTESupportConfiguration()).resolve(this.getHost());
        NetworkParameter nwParam = NetworkParameterFactory.createNetworkParameter((String)resolveHost, (int)8080, (String[])userPasswd);
        this.udpReader = new UdpReaderUnicast(this);
        this.udpReader.init(524288, 5000, true, true);
        this.logger.info("UDP port '" + this.udpReader.getPort() + "' opened for " + this.getVideoSrv());
        String localAddress = null;
        try (Socket tmpSocket2 = new Socket(this.getHost(), this.getPort());){
            localAddress = tmpSocket2.getLocalAddress().getHostAddress();
        }
        catch (Exception tmpSocket2) {
            // empty catch block
        }
        try {
            NetworkHelper.readPostRequest((NetworkParameter)nwParam, (String)DISCONNECT_URL, (String)"", (int)Integer.MAX_VALUE, (boolean)false, (String)"text/plain");
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting video settings for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        if (this.fps > 0L && this.fps <= 9L) {
            this.fps = 3L;
            if (this.iFrameDist <= 1L) {
                this.iFrameDistValue = 6;
            } else if (this.iFrameDist > 1L) {
                this.iFrameDistValue = 15;
            } else if (this.iFrameDist > 2L) {
                this.iFrameDistValue = 18;
            } else if (this.iFrameDist > 3L) {
                this.iFrameDistValue = 24;
            } else if (this.iFrameDist > 3L) {
                this.iFrameDistValue = 30;
            }
        } else if (this.fps > 9L && this.fps <= 18L) {
            this.fps = 1L;
            if (this.iFrameDist <= 1L) {
                this.iFrameDistValue = 15;
            } else if (this.iFrameDist > 1L) {
                this.iFrameDistValue = 24;
            } else if (this.iFrameDist > 2L) {
                this.iFrameDistValue = 30;
            }
        } else {
            this.fps = 0L;
            this.iFrameDistValue = this.iFrameDist > 1L ? 30 : 24;
        }
        if (this.width == 720 && this.height == 576) {
            this.resolutionValue = 0;
        } else if (this.width == 704 && this.height == 576) {
            this.resolutionValue = 1;
        } else if (this.width == 352 && this.height == 576) {
            this.resolutionValue = 2;
        } else if (this.width == 352 && this.height == 288) {
            this.resolutionValue = 3;
        } else if (this.width == 176 && this.height == 144) {
            this.resolutionValue = 4;
        } else if (this.width == 704 && this.height == 288) {
            this.resolutionValue = 8;
        } else {
            this.logger.error("Not known image resolution: " + this.width + "x" + this.height);
            return -21601;
        }
        int[] allowedValues = new int[]{250, 500, 1000, 1500, 2000, 2100, 2200, 2300, 2400, 2500, 2600, 2700, 2800, 2900, 3000, 3500, 3600, 3700, 3800, 3900, 4000, 6000, 8000};
        this.bandwidth = Tools.convertToCameraValues(allowedValues, this.bandwidth);
        this.encodingMode = 3;
        StringBuffer content = new StringBuffer("DlmConfig=<DlmSDK><DlmConfig>");
        content.append("<Live unicast_port=\"");
        content.append(this.udpReader.getPort());
        content.append("\" unicast_destination=\"");
        content.append(localAddress);
        content.append("\"/>");
        content.append("<SetEncoder resolution=\"");
        content.append(this.resolutionValue);
        content.append("\" gopsize=\"");
        content.append(this.iFrameDistValue);
        content.append("\" framerate=\"");
        content.append(this.fps);
        content.append("\" bitrate=\"");
        content.append(this.bandwidth);
        content.append("\" format=\"");
        content.append(this.encodingMode);
        content.append("\"/></DlmConfig></DlmSDK> ");
        try {
            this.logger.info("Setting resolution=" + this.resolutionValue + ", gopsize=" + this.iFrameDistValue + ", fps=" + this.fps + ", bitrate=" + this.bandwidth + ", encodingMode=" + this.encodingMode + " for " + this.getVideoSrv());
            result = NetworkHelper.readPostRequest((NetworkParameter)nwParam, (String)CONFIG_URL, (String)content.toString(), (int)Integer.MAX_VALUE, (boolean)false, (String)"text/plain");
            if (!new String(result).contains("Result=7")) {
                this.logger.error("Not all parameters could be set for " + this.getVideoSrv());
                return -21600;
            }
        }
        catch (SeeTecException e) {
            if (e.getErrorCode() == -21657) {
                return -21657;
            }
            this.logger.error("Exception while setting initial parameters for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        content = new StringBuffer("camera=");
        try {
            result = NetworkHelper.readPostRequest((NetworkParameter)nwParam, (String)SHOWLIVE_URL, (String)content.toString(), (int)Integer.MAX_VALUE, (boolean)false, (String)"text/plain");
            if (!new String(result).contains("Result=0")) {
                this.logger.error("ShowLive failed  for " + this.getVideoSrv());
                this.logger.info("Response from server was: " + new String(result));
                return -21600;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting video settings for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        String[] userNamePassword = new String[2];
        if (this.networkParameter.getUserPWD() != null) {
            userNamePassword = this.networkParameter.getUserPWD();
        }
        String resolveHost = new LteHostResolver(this.getCore().getLTESupportConfiguration()).resolve(this.getHost());
        NetworkParameter nwParam = NetworkParameterFactory.createNetworkParameter((String)resolveHost, (int)8080, (String[])userNamePassword);
        try {
            NetworkHelper.readPostRequest((NetworkParameter)nwParam, (String)DISCONNECT_URL, (String)"", (int)Integer.MAX_VALUE, (boolean)false, (String)"text/plain");
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting video settings for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        if (this.udpReader != null) {
            this.udpReader.shutdown();
        }
        this.udpReader = null;
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void onUdpData(byte[] data) {
        this.processData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
    }
}

