/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dallmeier;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.video.dallmeier.DallmeierIOHandler;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public final class DallmeierDevice
extends VideoServer {
    private OnvifCore onvifCore = null;

    @Override
    public int initializeDevice(long nSrvType) {
        block9: {
            super.initializeDevice(nSrvType);
            if (this.isOnvifDevice()) {
                try {
                    NetworkParameter networkParameter = this.getDeviceCnf().getNetworkParameter();
                    if (networkParameter == null) break block9;
                    if (this.onvifCore == null) {
                        this.onvifCore = new OnvifCore();
                    }
                    String user = null;
                    if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[0] != null) {
                        user = networkParameter.getUserPWD()[0];
                    }
                    String pw = null;
                    if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[1] != null) {
                        pw = networkParameter.getUserPWD()[1];
                    }
                    boolean useAuthorization = false;
                    if (user != null && pw != null) {
                        useAuthorization = true;
                    }
                    OnvifDevice onvifDevice = new OnvifDevice(this.getDeviceEntity().getEntityName(), networkParameter, user, pw, "PasswordDigest", useAuthorization);
                    try {
                        this.onvifCore.init(onvifDevice, this.logger.isDebugEnabled());
                    }
                    catch (OnvifException onvifException) {
                        this.onvifCore.shutdown();
                        int errorCode = onvifException.getErrorCode();
                        this.logger.error(onvifException.getCause().getMessage());
                        return errorCode;
                    }
                }
                catch (ConfigurationException exception) {
                    this.logger.info((Object)exception);
                }
            }
        }
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new DallmeierIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public OnvifCore getOnvifCore() {
        if (this.onvifCore != null) {
            return this.onvifCore;
        }
        return null;
    }

    public boolean isOnvifDevice() {
        long deviceType = this.getDeviceType();
        return deviceType == 201501L || deviceType == 201502L || deviceType == 201503L || deviceType == 201504L;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

