/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dallmeier;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.video.dallmeier.DallmeierCameraSrv;
import de.seetec.v5.re.cm.device.video.dallmeier.DallmeierDevice;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import java.net.URLEncoder;
import java.util.Vector;
import javax.xml.ws.Holder;
import org.onvif.ver10.schema.PTZPreset;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver20.ptz.wsdl.PTZ;

public class DallmeierCameraControl
extends CameraControl {
    private OnvifCore onvifCore = null;
    private PTZ ptzService = null;
    private String profileToken = null;

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        DallmeierDevice dallmeierDevice = (DallmeierDevice)((DallmeierCameraSrv)this.videoSrv).getDevice();
        if (dallmeierDevice.isOnvifDevice()) {
            this.initializeOnvifCoreAndPtzService();
            try {
                this.onvifCore.getPtzService().sendContinuousPtzCommand(this.profileToken, panSpeed, tiltSpeed, zoomSpeed, 10, 100L);
                this.videoSrv.notifyForCameraControl();
            }
            catch (Exception exception) {
                this.logger.warn("Continuous PTZ command coud not be executed on " + dallmeierDevice.toString());
                this.logger.warn((Object)exception);
            }
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        try {
            DallmeierDevice dallmeierDevice = (DallmeierDevice)((DallmeierCameraSrv)this.videoSrv).getDevice();
            if (dallmeierDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
                for (PTZPreset preset : this.ptzService.getPresets(this.profileToken)) {
                    try {
                        if (!preset.getName().equals(presetName)) continue;
                        this.ptzService.removePreset(this.profileToken, preset.getToken());
                        break;
                    }
                    catch (NullPointerException exception) {
                        this.ptzService.removePreset(this.profileToken, preset.getToken());
                    }
                }
                Holder presetToken = new Holder();
                this.ptzService.setPreset(this.profileToken, encodedPresetName, presetToken);
                PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, (String)presetToken.value, encodedPresetName);
                this.presetList.addElement(presetCnf);
                vResult.addElement(presetCnf.getPresetCnf());
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetName + "] failed :-(", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            DallmeierDevice dallmeierDevice = (DallmeierDevice)((DallmeierCameraSrv)this.videoSrv).getDevice();
            if (dallmeierDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                String token = null;
                for (PTZPreset preset : this.ptzService.getPresets(this.profileToken)) {
                    try {
                        if (!preset.getName().equals(presetName)) continue;
                        token = preset.getToken();
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                this.ptzService.gotoPreset(this.profileToken, token, null);
                this.videoSrv.notifyForCameraControl();
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Going to preset [" + presetName + "] failed :-(", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            DallmeierDevice dallmeierDevice = (DallmeierDevice)((DallmeierCameraSrv)this.videoSrv).getDevice();
            if (dallmeierDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                String token = null;
                for (PTZPreset preset : this.ptzService.getPresets(this.profileToken)) {
                    try {
                        if (!preset.getName().equals(presetName)) continue;
                        token = preset.getToken();
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                this.ptzService.removePreset(this.profileToken, token);
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Going to preset [" + presetName + "] failed :-(", (Throwable)exception);
            return -21600;
        }
    }

    private void initializeOnvifCoreAndPtzService() {
        DallmeierDevice dallmeierDevice = (DallmeierDevice)((DallmeierCameraSrv)this.videoSrv).getDevice();
        if (this.onvifCore == null) {
            this.onvifCore = dallmeierDevice.getOnvifCore();
        }
        if (this.ptzService == null) {
            this.ptzService = this.onvifCore.getPtzService().getOnvifPtzService();
        }
        if (this.profileToken == null) {
            this.profileToken = ((Profile)dallmeierDevice.getOnvifCore().getMediaService().getOnvifMediaService().getProfiles().get(0)).getToken();
        }
    }
}

