/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

public enum Resolution {
    D1("D1", 704, 576, 704, 480),
    HD1("HD1", 352, 576, 352, 480),
    BCIF("BCIF", 704, 288, 704, 240),
    CIF("CIF", 352, 288, 352, 240),
    QCIF("QCIF", 176, 144, 176, 120),
    NHD("NHD", 640, 360),
    VGA("VGA", 640, 480),
    QVGA("QVGA", 320, 240),
    SVCD("SVCD", 480, 480),
    QQVGA("QQVGA", 160, 128),
    SVGA("SVGA", 800, 592),
    SVGA1("SVGA1", 800, 600),
    WVGA("WVGA", 800, 480),
    FWVGA("FWVGA", 854, 480),
    DVGA("DVGA", 960, 640),
    XVGA("XVGA", 1024, 768),
    WXGA("WXGA", 1280, 800),
    WXGA2("WXGA2", 1280, 768),
    WXGA3("WXGA3", 1280, 854),
    WXGA4("WXGA4", 1366, 768),
    SXGA("SXGA", 1280, 1024),
    SXGA_PLUS("SXGA+", 1400, 1050),
    WSXGA("WSXGA", 1600, 1024),
    UXGA("UXGA", 1600, 1200),
    WUXGA("WUXGA", 1920, 1200),
    ND1("ND1", 240, 192),
    _720P("720P", 1280, 720),
    _1080P("1080P", 1920, 1080),
    QFHD("QFHD", 3840, 2160),
    _1280x960("1280x960", 1280, 960),
    _1872x1408("1872x1408", 1872, 1408),
    _3744x1408("3744x1408", 3744, 1408),
    _2048x1536("2048x1536", 2048, 1536),
    _2432x2048("2432x2048", 2432, 2048),
    _1216x1024("1216x1024", 1216, 1024),
    _1408x1024("1408x1024", 1408, 1024),
    _3296x2472("3296x2472", 3296, 2472),
    _2560x1920("2560x1920", 2560, 1920),
    _5_1M("5_1M", 2560, 1920),
    _960H("960H", 960, 576, 960, 480),
    DV720P("DV720P", 960, 720),
    _2560x1600("2560x1600", 2560, 1600),
    _2336x1752("2336x1752", 2336, 1752),
    _2592x2048("2592x2048", 2592, 2048),
    _2448x2048("2448x2048", 2448, 2048),
    _1920x1440("1920x1440", 1920, 1440),
    _2752x2208("2752x2208", 2752, 2208),
    _3840x2160("3840x2160", 3840, 2160),
    _4096x2160("4096x2160", 4096, 2160),
    _3072x2048("3072x2048", 3072, 2048),
    _2688x1520("2688x1520", 2688, 1520),
    _2560x1440("2560x1440", 2560, 1440),
    _2304x1296("2304x1296", 2304, 1296),
    _4000x3000("4000x3000", 4000, 3000),
    _2592x1520("2592x1520", 2592, 1520),
    _2880x2880("2880x2880", 2880, 2880),
    _2880x2160("2880x2160", 2880, 2160),
    _1080N("1080N", 960, 1080),
    _640x512("640x512", 640, 512),
    _320x256("320x256", 320, 256);

    private final String name;
    private final int widthPAL;
    private final int heightPAL;
    private final int widthNTSC;
    private final int heightNTSC;

    private Resolution(String name, int widthPAL, int heightPAL, int widthNTSC, int heightNTSC) {
        this.name = name;
        this.heightPAL = heightPAL;
        this.widthPAL = widthPAL;
        this.widthNTSC = widthNTSC;
        this.heightNTSC = heightNTSC;
    }

    private Resolution(String name, int widthPAL, int heightPAL) {
        this.name = name;
        this.heightPAL = heightPAL;
        this.widthPAL = widthPAL;
        this.widthNTSC = widthPAL;
        this.heightNTSC = heightPAL;
    }

    public int getWidthNTSC() {
        return this.widthNTSC;
    }

    public int getHeightNTSC() {
        return this.heightNTSC;
    }

    public int getWidthPAL() {
        return this.widthPAL;
    }

    public int getHeightPAL() {
        return this.heightPAL;
    }

    public String getName() {
        return this.name;
    }

    public static Resolution valueOf(int width, int height) {
        for (Resolution t : Resolution.values()) {
            if (width == t.getWidthNTSC() && height == t.getHeightNTSC()) {
                return t;
            }
            if (width != t.getWidthPAL() || height != t.getHeightPAL()) continue;
            return t;
        }
        return null;
    }

    public static Resolution getByName(String name) {
        for (Resolution t : Resolution.values()) {
            if (name == null || !name.toLowerCase().equals(t.getName().toLowerCase())) continue;
            return t;
        }
        return null;
    }
}

