/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.dahua.DahuaCameraSrv;
import de.seetec.v5.re.cm.device.video.dahua.DahuaCommand;
import de.seetec.v5.re.cm.device.video.dahua.DahuaDevice;
import de.seetec.v5.re.cm.device.video.dahua.DahuaHelper;
import de.seetec.v5.re.cm.device.video.dahua.Resolution;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;

public class DahuaVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dahua.DahuaVideoSourceClient";
    private int streamNumber;
    private DahuaDevice dahuaDevice;
    private String streamName;
    private int channelID;
    private String cameraConfiguration;
    private HttpHandler httpHandler;
    private DahuaHelper dahuaHelper;
    private int numberOfVideoSources;

    public void setHttpHandler(HttpHandler httpHandler) {
        this.httpHandler = httpHandler;
    }

    public HttpHandler getHttpHandler() {
        return this.httpHandler;
    }

    @Override
    public int init() {
        block52: {
            try {
                boolean isRTSPPortEnabled;
                int bitrate;
                boolean isFramerateSet;
                this.printDebug = false;
                this.errorCode = super.init();
                if (this.errorCode != 0) {
                    this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                    return this.errorCode;
                }
                this.dahuaDevice = (DahuaDevice)((DahuaCameraSrv)this.getVideoSrv()).getDevice();
                this.dahuaHelper = this.dahuaDevice.getDahuaHelper();
                this.channelID = this.videoSourceNr - 1;
                this.resolutionTag = "";
                this.numberOfVideoSources = this.dahuaDevice.getNumberOfVideoSourcesFromDevice();
                if (this.width == -1 || this.height == -1) break block52;
                Resolution resolution = Resolution.valueOf(this.width, this.height);
                this.resolutionTag = resolution != null ? resolution.getName() : this.width + "x" + this.height;
                int videoProfileID = this.listener.getDynamicVideoProfileID();
                this.errorCode = ((DahuaCameraSrv)this.getVideoSrv()).setStreamMatching(this.channelID, this.resolutionTag, this.listener.getVideoSourceParameter().getStreamName(), videoProfileID);
                if (this.errorCode != 0) {
                    this.logger.error("Error while setting channel parameters for " + this.getVideoSrv() + ": " + this.errorCode);
                    return this.errorCode;
                }
                this.cameraConfiguration = this.readGetRequest("/cgi-bin/configManager.cgi?action=getConfig&name=Encode&name=RTSP");
                this.iFrameDistMS = this.numberOfVideoSources > 1 && this.iFrameDistMS > 2000 ? 2000 : this.iFrameDistMS;
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, (int)this.fps / 1000, 150);
                this.streamNumber = ((DahuaCameraSrv)this.getVideoSrv()).getStreamNumber(videoProfileID);
                if (this.streamNumber == -1) {
                    this.logger.error("Error while selecting stream number for " + this);
                    return -20001;
                }
                this.streamName = DahuaVideoSourceClient.getStreamName(this.dahuaDevice.getDeviceEntity().getEntityType(), this.streamNumber, this.width);
                boolean isVideoCodecSet = DahuaHelper.checkIsVideoCodecSet(this.cameraConfiguration, this.channelID, this.streamName, this.videoCodec);
                boolean isVideoEnabled = DahuaHelper.checkIsVideoEnabled(this.cameraConfiguration, this.channelID, this.streamName, this.streamNumber);
                boolean isResolutionEnabled = DahuaHelper.checkIsResolutionEnabled(this.cameraConfiguration, this.channelID, this.streamName, this.height, this.width);
                boolean isAudioSet = DahuaHelper.checkIsAudioSet(this.cameraConfiguration, this.channelID, this.streamName, this.isAudioEnabled);
                StringBuilder url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig");
                String header = "&Encode[" + this.channelID + "]." + this.streamName + ".";
                if (!isVideoCodecSet) {
                    url.append(header);
                    url.append("Video.Compression=");
                    if (null != this.videoCodec) {
                        switch (this.videoCodec) {
                            case H264: {
                                url.append("H.264");
                                break;
                            }
                            case MJPEG: {
                                url.append("MJPG");
                                break;
                            }
                            case H265: {
                                url.append("H.265");
                                break;
                            }
                        }
                    }
                }
                if (!isVideoEnabled) {
                    url.append(header);
                    url.append("VideoEnable=true");
                }
                if (!isResolutionEnabled) {
                    this.dahuaDevice.setFramerate(1, header);
                    url.append(header);
                    url.append("Video.Width=");
                    url.append(this.width);
                    url.append(header);
                    url.append("Video.Height=");
                    url.append(this.height);
                }
                if (!isAudioSet) {
                    url.append(header);
                    if (this.isAudioEnabled) {
                        url.append("AudioEnable=true");
                    } else {
                        url.append("AudioEnable=false");
                    }
                }
                if (!(isAudioSet && isResolutionEnabled && isVideoCodecSet && isVideoEnabled)) {
                    try {
                        this.readGetRequest(url.toString());
                    }
                    catch (SeeTecException ex) {
                        if (ex.getErrorCode() == -20002) {
                            this.trySettingBitrates(url.toString(), header);
                        }
                        this.logger.error("Exception while setting Parameters. \r\n\tURL used: " + url.toString() + "\r\n\tHTTP statuscode: " + ex.getNetworkStatus() + "\r\n\tError: " + ex.getErrorCode() + "\r\n\tError: " + ex.getMessage() + "\r\n\tTrying to start stream anyway...");
                    }
                }
                this.cameraConfiguration = this.readGetRequest("/cgi-bin/configManager.cgi?action=getConfig&name=Encode&name=RTSP");
                this.fps /= 1000L;
                try {
                    String[] framerateLimit = this.dahuaHelper.getCaps(DahuaCommand.CAPS, "caps[" + this.channelID + "]." + this.streamName + ".Video.FPSMax", "caps.caps[" + this.channelID + "]." + this.streamName + ".Video.FPSMax");
                    int fpsMax = 25;
                    if (framerateLimit.length == 1) {
                        fpsMax = Integer.parseInt(framerateLimit[0]);
                    }
                    this.fps = this.fps < 1L ? 1L : this.fps;
                    this.fps = this.fps > (long)fpsMax ? (long)fpsMax : this.fps;
                    String[] parametersOnCamera = DahuaHelper.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.FPS");
                    isFramerateSet = parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Long.toString(this.fps));
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while getting Framerate capabilities for " + this + ": " + ex.getMessage());
                    return ex.getErrorCode();
                }
                if (!isFramerateSet) {
                    try {
                        url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig");
                        url.append(header);
                        url.append("Video.FPS=").append(this.fps);
                        this.readGetRequest(url.toString());
                    }
                    catch (SeeTecException ex) {
                        if (ex.getErrorCode() == -20002) {
                            this.trySettingBitrates(url.toString(), header);
                        }
                        this.logger.error("Exception while setting Framerate. \r\n\tStream configured: " + header + "\r\n\tHTTP statuscode: " + ex.getNetworkStatus() + "\r\n\tError: " + ex.getErrorCode() + "\r\n\tError: " + ex.getMessage() + "\r\n\tTrying to start stream anyway...");
                    }
                }
                this.cameraConfiguration = this.readGetRequest("/cgi-bin/configManager.cgi?action=getConfig&name=Encode&name=RTSP");
                url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig");
                String[] bitrateLimits = this.dahuaHelper.getCaps(DahuaCommand.CAPS, "caps[" + this.channelID + "]." + this.streamName + ".Video.BitRateOptions", "caps.caps[" + this.channelID + "]." + this.streamName + ".Video.BitRateOptions");
                int lowerBitrateLimit = 0;
                int upperBitrateLimit = 4096;
                if (bitrateLimits.length == 2) {
                    lowerBitrateLimit = Integer.parseInt(bitrateLimits[0]);
                    upperBitrateLimit = Integer.parseInt(bitrateLimits[1]);
                }
                bitrate = (bitrate = this.bandwidth / 1024) < lowerBitrateLimit ? lowerBitrateLimit : bitrate;
                bitrate = bitrate > upperBitrateLimit ? upperBitrateLimit : bitrate;
                boolean isBitrateEnabled = DahuaHelper.checkIsBitrateEnabled(this.cameraConfiguration, this.channelID, this.streamName, bitrate);
                boolean isBitrateControlEnabled = DahuaHelper.checkIsBitrateControlEnabled(this.cameraConfiguration, this.channelID, this.streamName, this.isConstantBitrateUsed);
                if (this.videoCodec == Codec.H264 || this.videoCodec == Codec.H265) {
                    this.quality = this.quality / 16000 + 1;
                    this.quality = this.quality > 6 ? 6 : this.quality;
                }
                boolean isQualitySet = DahuaHelper.checkIsQualitySet(this.cameraConfiguration, this.channelID, this.streamName, this.videoCodec, this.quality);
                boolean isProfileSet = DahuaHelper.checkIsProfileSet(this.cameraConfiguration, this.channelID, this.streamName, this.listener.getVideoSourceParameter().getMpegProfile().name());
                boolean isAudioCodecSet = DahuaHelper.checkIsAudioCodecSet(this.cameraConfiguration, this.channelID, this.streamName, this.isAudioEnabled, this.audioCodec, this.videoCodec);
                if (this.isConstantBitrateUsed) {
                    if (!isBitrateControlEnabled) {
                        url.append(header);
                        url.append("Video.BitRateControl=CBR");
                    }
                    if (!isBitrateEnabled) {
                        url.append(header);
                        url.append("Video.BitRate=");
                        url.append(bitrate);
                    }
                } else {
                    if (!isBitrateControlEnabled) {
                        url.append(header);
                        url.append("Video.BitRateControl=VBR");
                    }
                    if (!isQualitySet) {
                        url.append(header);
                        url.append("Video.Quality=");
                        url.append(this.quality);
                    }
                    if (!isBitrateEnabled) {
                        url.append(header);
                        url.append("Video.BitRate=");
                        url.append(bitrate);
                    }
                }
                if (!isProfileSet) {
                    url.append(header);
                    url.append("Video.Profile=");
                    String profile = this.listener.getVideoSourceParameter().getMpegProfile().name();
                    if (profile.toLowerCase().equals("default")) {
                        profile = "Main";
                    }
                    url.append(StringUtils.capitalize((String)profile.toLowerCase()));
                }
                boolean isIFrameDistanceSet = true;
                if (!(this.videoCodec != Codec.H264 && this.videoCodec != Codec.H265 || (isIFrameDistanceSet = DahuaHelper.checkIsIFrameDistanceSet(this.cameraConfiguration, this.channelID, this.streamName, this.iFrameDist, this.videoCodec)))) {
                    url.append(header);
                    url.append("Video.GOP=");
                    url.append(this.iFrameDist);
                }
                if (!isAudioCodecSet) {
                    url.append(header);
                    url.append("Audio.Compression=");
                    url.append(this.audioCodec.equals((Object)Codec.G711A) ? "G.711A" : "G.711Mu");
                }
                if (!(isProfileSet && isBitrateEnabled && (this.isConstantBitrateUsed || isQualitySet) && isBitrateControlEnabled && isIFrameDistanceSet && isAudioCodecSet)) {
                    try {
                        this.logger.info(url.toString());
                        this.readGetRequest(url.toString());
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception while setting Parameters. \r\n\tURL used: " + url.toString() + "\r\n\tHTTP statuscode: " + ex.getNetworkStatus() + "\r\n\tError: " + ex.getErrorCode() + "\r\n\tError: " + ex.getMessage() + "\r\n\tTrying to start stream anyway...");
                    }
                }
                if (!(isRTSPPortEnabled = DahuaHelper.checkIsRTSPPortSet(this.cameraConfiguration, this.listener.getVideoSourceParameter().getRtspPort()))) {
                    this.readGetRequest("/cgi-bin/configManager.cgi?action=setConfig&RTSP.Port=" + this.listener.getVideoSourceParameter().getRtspPort());
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while initialization for " + this, (Throwable)ex);
                return ex.getErrorCode();
            }
            catch (Throwable t) {
                this.logger.error("Unexpected exception while initialization for " + this, t);
                return -20000;
            }
        }
        try {
            if (this.width > 1900 && this.videoCodec == Codec.MJPEG && this.rotationAngle == 90 || this.rotationAngle == 270) {
                int tempWidth = this.width;
                this.width = this.height;
                this.height = tempWidth;
            }
            this.rtspUrl = "rtsp://" + this.getHost() + "/cam/realmonitor?channel=" + this.videoSourceNr + "&subtype=" + this.streamNumber;
            this.rtspSettings = new RTSPStreamSettings();
            this.networkParameter.setSoTimeout(10000);
            if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1) != 0) {
                this.logger.error("Error while initializing RTSP settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.disableBasicAuthentication();
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP stream for " + this, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while starting RTSP stream for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    public static String getStreamName(Long entityType, int streamNumber, int width) throws SeeTecException {
        if (entityType == null) {
            throw new SeeTecException(-20002, "EntityType is null for Dahua Device");
        }
        if (entityType == 205603L) {
            switch (streamNumber) {
                case 1: {
                    return "ExtraFormat[0]";
                }
                case 2: {
                    return "ExtraFormat[1]";
                }
            }
            return "MainFormat[0]";
        }
        if (width >= 1280) {
            return "MainFormat[0]";
        }
        return "ExtraFormat[0]";
    }

    private String readGetRequest(String url) throws SeeTecException {
        List<String> newUrls = this.extendMainStreamUrl(url);
        String result = "";
        for (String newUrl : newUrls) {
            result = this.getHttpHandler().readGetRequest(newUrl);
            if (!result.contains("ErrorID")) continue;
            throw new SeeTecException(-20002, "Error while setting parameter: " + url);
        }
        return result;
    }

    private void trySettingBitrates(String url, String header) {
        for (int bitrate = 4096; bitrate >= 4; bitrate /= 2) {
            try {
                String result = this.readGetRequest(url + header + "Video.BitRate=" + bitrate);
                if (!result.toLowerCase().contains("ok")) continue;
                break;
            }
            catch (Exception e) {
                this.logger.warn("Could not set url " + url + ", trying to set command with a lower bitrate...");
            }
        }
    }

    protected List<String> extendMainStreamUrl(String url) throws SeeTecException {
        List<String> splittedUrl = new ArrayList<String>();
        if (url != null) {
            String newUrl = url;
            if (newUrl.contains("MainFormat")) {
                String[] urlParts = newUrl.split("&");
                StringBuilder extendedUrl = new StringBuilder();
                for (String urlPart : urlParts) {
                    extendedUrl.append("&").append(urlPart);
                    if (!urlPart.contains("MainFormat[0]")) continue;
                    extendedUrl.append("&").append(urlPart.replace("MainFormat[0]", "MainFormat[1]"));
                    extendedUrl.append("&").append(urlPart.replace("MainFormat[0]", "MainFormat[2]"));
                }
                newUrl = extendedUrl.length() > 0 ? extendedUrl.toString().substring(1) : "";
            }
            splittedUrl = this.splitUrls(newUrl);
        }
        return splittedUrl;
    }

    protected List<String> splitUrls(String newUrl) throws SeeTecException {
        ArrayList<String> resultingLists = new ArrayList<String>();
        if (newUrl != null) {
            if (newUrl.length() <= 1024) {
                resultingLists.add(newUrl);
                return resultingLists;
            }
            String[] urlParts = newUrl.split("&");
            if (urlParts.length > 1) {
                String firstPartOfUrl = urlParts[0];
                StringBuilder limitedUrl = new StringBuilder(firstPartOfUrl);
                for (int i = 1; i < urlParts.length; ++i) {
                    if (limitedUrl.length() + urlParts[i].length() > 1023) {
                        resultingLists.add(limitedUrl.toString());
                        limitedUrl = new StringBuilder(firstPartOfUrl).append("&").append(urlParts[i]);
                        continue;
                    }
                    limitedUrl.append("&").append(urlParts[i]);
                }
                resultingLists.add(limitedUrl.toString());
            } else {
                throw new SeeTecException(-20002, "URL is too long, but cannot be splitted");
            }
        }
        return resultingLists;
    }
}

