/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.video.dahua.DahuaEvent;
import de.seetec.v5.re.cm.device.video.dahua.DahuaEventClock;
import de.seetec.v5.re.cm.device.video.dahua.DahuaEventClockIntf;
import de.seetec.v5.re.cm.device.video.dahua.DahuaHelper;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.HttpHandlerIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;

class DahuaTriggerHandler
extends GenericEventTriggerHandler
implements SSLConstantsIntf,
HttpHandlerIntf,
DahuaEventClockIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dahua.DahuaTriggerHandler";
    private boolean shutdown = false;
    private NetworkParameter networkParameter = null;
    private DahuaEventClock dahuaEventClock;
    private HashMap<String, Boolean> triggerStarted = new HashMap();
    private int status;
    private HttpHandlerImpl httpHandlerImpl;
    private ArrayList<String> startStopTriggerList;

    DahuaTriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int shutdown() {
        this.logger.info("Starting shutdown of Dahua Trigger Handling for " + this);
        if (this.shutdown) {
            this.logger.info("Shutdown already in progress for " + this);
            return 0;
        }
        this.shutdown = true;
        if (this.httpHandlerImpl != null) {
            this.httpHandlerImpl.shutdown();
            this.httpHandlerImpl = null;
        }
        if (this.dahuaEventClock != null) {
            this.dahuaEventClock.shutdown();
            this.dahuaEventClock = null;
        }
        this.shutdown = true;
        return super.shutdown();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.video.dahua.DahuaTriggerHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + "]";
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                if (this.device.getDeviceCnf() == null) {
                    this.shutdown();
                } else {
                    String eventName;
                    this.networkParameter = this.device.getDeviceCnf().getNetworkParameter();
                    this.startStopTriggerList = DahuaEvent.getStartStopTriggerList();
                    boolean startStopEventsAvailable = false;
                    for (GenericEventTriggerCnf event : this.genericEventTriggerCnfs) {
                        if (event == null || !event.isEnabled() || !this.startStopTriggerList.contains(DahuaHelper.removeNumber(eventName = event.getGenericEventTriggerType()))) continue;
                        startStopEventsAvailable = true;
                    }
                    if (this.dahuaEventClock == null && startStopEventsAvailable) {
                        this.dahuaEventClock = new DahuaEventClock(this);
                        for (GenericEventTriggerCnf event : this.genericEventTriggerCnfs) {
                            if (event == null || !event.isEnabled() || !this.startStopTriggerList.contains(DahuaHelper.removeNumber(eventName = event.getGenericEventTriggerType()))) continue;
                            this.dahuaEventClock.addEvent(new DahuaEvent(eventName, event.getSourceNumber()));
                        }
                        this.dahuaEventClock.startTriggering();
                    }
                }
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while getting Network Parameters for " + this);
            }
            if (this.httpHandlerImpl == null && !this.shutdown) {
                try {
                    String url = "/cgi-bin/eventManager.cgi?action=attach&codes=[All]";
                    this.networkParameter.setSoTimeout(30000);
                    this.httpHandlerImpl = new HttpHandlerImpl(this.networkParameter);
                    this.httpHandlerImpl.setBoundary("-- myboundary");
                    this.httpHandlerImpl.setServerPushHeaderOnly(true);
                    this.httpHandlerImpl.readServerPushRequest(url, (HttpHandlerIntf)this);
                }
                catch (Exception ex) {
                    this.logger.warn("Could not connect to device: " + ex.getMessage() + " for " + this);
                }
                this.shutdown = false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.logger.warn("Exception while sleeping in endless cycle for " + this + " : " + ex.getMessage());
            }
        }
    }

    @Override
    public void trigger(String eventName, int channelNumber) {
        List triggerEvents = this.genericEventTriggerCnfs;
        try {
            for (GenericEventTriggerCnf event : triggerEvents) {
                String evName;
                if (event == null || !event.isEnabled() || !(evName = event.getGenericEventTriggerType()).equals(eventName) || event.getSourceNumber() != channelNumber && event.getSourceNumber() != 0) continue;
                this.forwardTrigger(event);
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while forwarding trigger for " + this + " : " + ex.getMessage());
        }
    }

    @Override
    public boolean isTriggerStarted(String eventName, int channelNumber) {
        if (this.triggerStarted != null && this.triggerStarted.get(eventName + channelNumber) != null) {
            return this.triggerStarted.get(eventName + channelNumber);
        }
        return false;
    }

    public void deliverContent(byte[] data) {
        try {
            DahuaEvent dahuaEvent = new DahuaEvent(new String(data));
            if (dahuaEvent.getName() != null && !dahuaEvent.getName().isEmpty()) {
                List triggerEvents = this.genericEventTriggerCnfs;
                for (GenericEventTriggerCnf event : triggerEvents) {
                    String eventName;
                    if (event == null || !event.isEnabled() || !(eventName = event.getGenericEventTriggerType()).equals(dahuaEvent.getName()) && !this.equalsIgnoreIndex(eventName, dahuaEvent.getName()) || event.getSourceNumber() != dahuaEvent.getChannel() && event.getSourceNumber() != 0) continue;
                    if (dahuaEvent.getAction().toLowerCase().equals("start")) {
                        this.triggerStarted.put(eventName + event.getSourceNumber(), true);
                        continue;
                    }
                    if (dahuaEvent.getAction().toLowerCase().equals("stop")) {
                        this.triggerStarted.put(eventName + event.getSourceNumber(), false);
                        continue;
                    }
                    this.forwardTrigger(event);
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while reading trigger data for " + this + " : " + ex.getMessage());
        }
    }

    public void sendStatusService(int statusCode) {
        if (this.isShutdown()) {
            return;
        }
        if (statusCode != 0) {
            if (this.httpHandlerImpl != null) {
                this.httpHandlerImpl.shutdown();
                this.httpHandlerImpl = null;
            }
            if (this.dahuaEventClock != null) {
                this.dahuaEventClock.shutdown();
                this.dahuaEventClock = null;
            }
        }
    }

    public void setStatus(int statusCode) {
        this.status = statusCode;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    private boolean equalsIgnoreIndex(String eventName1, String eventName2) {
        boolean result = false;
        if (eventName1.contains("[") && DahuaEvent.removeSquareBrackets(eventName1).equalsIgnoreCase(eventName2)) {
            result = true;
        } else if (eventName2.contains("[") && DahuaEvent.removeSquareBrackets(eventName2).equalsIgnoreCase(eventName1)) {
            result = true;
        }
        return result;
    }
}

