/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.dahua.DahuaDevice;
import de.seetec.v5.re.cm.device.video.dahua.DahuaHelper;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.ConfigurationException;
import org.apache.logging.log4j.Logger;

public class DahuaPlaybackVideoSourceClient
extends PlaybackVideoSourceClient {
    private DahuaDevice device = null;
    private DahuaHelper dahuaHelper = null;

    @Override
    public int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.getLogger().error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.device = (DahuaDevice)this.getVideoSrv().getDevice();
            this.printDebug = false;
            this.setStartAllTrackIds(false);
            this.transmissionID = TransmissionType.RTP_OVER_RTSP_OVER_TCP;
            this.setLocalStorageReady(true);
        }
        catch (Throwable ex) {
            this.getLogger().error("Error while initalizing " + this, ex);
        }
        return 0;
    }

    @Override
    protected double getMaxPlaybackSpeed() {
        return this.edgeStorageParameter.getPlaybackSpeed();
    }

    @Override
    protected String getRtspUrl(long startTimestamp, long endTimestamp, String trackID) throws ConfigurationException {
        String startTimeFormatted = this.getDahuaHelper().convertTimestampToDahuaRtspDateTime(startTimestamp);
        String endTimeFormatted = this.getDahuaHelper().convertTimestampToDahuaRtspDateTime(endTimestamp);
        return "rtsp://" + this.getHost() + "/cam/playback?channel=" + this.getVideoSrv().getVideoSourceCnf().getServerEntryNo() + "&starttime=" + startTimeFormatted + "&endtime=" + endTimeFormatted;
    }

    @Override
    protected String getTimeRange(long startTimestamp, long endTimestamp, String nameOfTimerange) {
        return "npt=0.000-";
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected DahuaDevice getDevice() {
        return this.device;
    }

    @Override
    protected Long getTimeDifferenceFromDevice() throws Exception {
        Long time = this.getDahuaHelper().getTimeDifferenceFromDevice();
        return System.currentTimeMillis() - time;
    }

    @Override
    protected String getRequireField() {
        return "";
    }

    protected DahuaHelper getDahuaHelper() throws ConfigurationException {
        if (this.dahuaHelper == null) {
            this.dahuaHelper = new DahuaHelper(this.getDevice().getDahuaNetworkParameter());
        }
        return this.dahuaHelper;
    }
}

