/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.device.video.dahua.DahuaCommand;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DahuaHelper {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private String response = null;
    private final NetworkParameter networkParameter;
    private Long timeDifferenceBetweenDahuaTimeAndSystemTime = null;

    DahuaHelper(NetworkParameter networkParameter) {
        this.networkParameter = networkParameter;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected static String removeNumber(String eventName) {
        int index;
        String result = eventName;
        if (eventName != null && !eventName.isEmpty() && (index = eventName.indexOf("[")) != -1) {
            result = eventName.substring(0, index);
        }
        return result;
    }

    protected List<TimeRange> convertRecordingInformationToTimeRanges(String result) throws SeeTecException, ConfigurationException {
        ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
        String[] itemLines = result.split("\r\n");
        int numberOfResults = 0;
        for (String line : itemLines) {
            if (!line.contains("found")) continue;
            numberOfResults = Integer.parseInt(line.replace("found=", "").replace("\n", "").replace("\n", "").trim());
            break;
        }
        TimeRange timeRange = null;
        if (numberOfResults > 0) {
            long startTimestamp = this.getStartTime(itemLines, 0);
            long endTimestamp = this.getEndTime(itemLines, 0);
            timeRange = new TimeRange(startTimestamp, endTimestamp);
            for (int i = 1; i < numberOfResults; ++i) {
                startTimestamp = this.getStartTime(itemLines, i);
                endTimestamp = this.getEndTime(itemLines, i);
                if (startTimestamp == timeRange.getEndTimestamp()) {
                    timeRange.setEndTimestamp(endTimestamp);
                    continue;
                }
                timeRanges.add(timeRange);
                timeRange = new TimeRange(startTimestamp, endTimestamp);
            }
        }
        timeRanges.add(timeRange);
        return timeRanges;
    }

    protected long getTime(String type, String[] itemLines, int i) throws SeeTecException, ConfigurationException {
        for (String itemLine : itemLines) {
            String[] nameValue;
            if (!itemLine.contains("items[" + i + "]." + type) || (nameValue = itemLine.split("=")).length != 2) continue;
            return this.convertSimpleDateTimeToTimestamp(nameValue[1].replace("\r", "").replace("\n", "").trim());
        }
        return 0L;
    }

    protected long getStartTime(String[] itemLines, int i) throws SeeTecException, ConfigurationException {
        return this.getTime("StartTime", itemLines, i);
    }

    protected long getEndTime(String[] itemLines, int i) throws SeeTecException, ConfigurationException {
        return this.getTime("EndTime", itemLines, i);
    }

    public long getTimeDifferenceBetweenDahuaTimeAndSystemTime() {
        if (this.timeDifferenceBetweenDahuaTimeAndSystemTime == null) {
            try {
                this.timeDifferenceBetweenDahuaTimeAndSystemTime = this.getTimeDifferenceFromDevice();
                String ntpConfiguration = this.getHttpHandler().readGetRequest("/cgi-bin/configManager.cgi?action=getConfig&name=NTP");
                int timeZoneNumber = Integer.parseInt(DahuaHelper.getParameterValue(ntpConfiguration, "table.NTP.TimeZone"));
                DahuaHelper dahuaHelper = this;
                dahuaHelper.timeDifferenceBetweenDahuaTimeAndSystemTime = dahuaHelper.timeDifferenceBetweenDahuaTimeAndSystemTime - (long)(DahuaHelper.getTimeZoneOffset(timeZoneNumber) * 1000);
                if (this.isDaylightSavingTimeActive()) {
                    dahuaHelper = this;
                    dahuaHelper.timeDifferenceBetweenDahuaTimeAndSystemTime = dahuaHelper.timeDifferenceBetweenDahuaTimeAndSystemTime - 3600000L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getLogger().info("Difference between PC (GMT) time and Dahua device (local) time: " + this.timeDifferenceBetweenDahuaTimeAndSystemTime);
        }
        return this.timeDifferenceBetweenDahuaTimeAndSystemTime;
    }

    public static String getParameterValue(String responseString, String parameterName) {
        String[] result = DahuaHelper.getParameterValues(responseString, parameterName);
        if (result.length > 0) {
            return result[0];
        }
        return "";
    }

    public static String[] getParameterValues(String responseString, String ... parameterNames) {
        String[] ret = new String[]{};
        if (responseString != null && parameterNames != null && parameterNames.length > 0) {
            for (String parameterName : parameterNames) {
                String[] parameterList;
                parameterName = parameterName.replace("[", "\\[").replace("]", "\\]");
                for (String parameterLine : parameterList = responseString.split(new String(SSLConstantsIntf.CRLF_BYTE))) {
                    String[] parameterLineParts = parameterLine.split("=");
                    if (parameterLineParts.length != 2 || !parameterLineParts[0].toLowerCase().matches(parameterName.toLowerCase())) continue;
                    ret = parameterLineParts[1].split(",");
                    for (int j = 0; j < ret.length; ++j) {
                        ret[j] = ret[j].trim();
                    }
                    return ret;
                }
            }
        }
        return ret;
    }

    public String[] getCaps(DahuaCommand parameterGroup, String parameterName, String alternativParameterName) throws SeeTecException {
        return this.getCaps(parameterGroup, parameterName, alternativParameterName, true);
    }

    public String[] getCaps(DahuaCommand parameterGroup, String parameterName, String alternativParameterName, boolean readFromCamera) throws SeeTecException {
        String url = parameterGroup.getUrl();
        String responseString = null;
        if (!readFromCamera) {
            responseString = this.response;
        }
        if (responseString == null || readFromCamera) {
            this.response = responseString = this.getHttpHandler().readGetRequest(url);
        }
        return DahuaHelper.getParameterValues(responseString, parameterName, alternativParameterName);
    }

    public static int adaptSpeed(Integer ptzSpeed) {
        if (ptzSpeed == null) {
            return 0;
        }
        if (ptzSpeed <= -90000) {
            return -8;
        }
        if (ptzSpeed <= -80000) {
            return -7;
        }
        if (ptzSpeed <= -70000) {
            return -6;
        }
        if (ptzSpeed <= -60000) {
            return -5;
        }
        if (ptzSpeed <= -50000) {
            return -4;
        }
        if (ptzSpeed <= -40000) {
            return -3;
        }
        if (ptzSpeed <= -30000) {
            return -2;
        }
        if (ptzSpeed <= -20000) {
            return -1;
        }
        if (ptzSpeed < 20000) {
            return 0;
        }
        if (ptzSpeed < 30000) {
            return 1;
        }
        if (ptzSpeed < 40000) {
            return 2;
        }
        if (ptzSpeed < 50000) {
            return 3;
        }
        if (ptzSpeed < 60000) {
            return 4;
        }
        if (ptzSpeed < 70000) {
            return 5;
        }
        if (ptzSpeed < 80000) {
            return 6;
        }
        if (ptzSpeed < 90000) {
            return 7;
        }
        return 8;
    }

    public String[] readHttpValue(String url, String parameterName, String alternativParameterName) throws SeeTecException {
        try {
            String result = this.getHttpHandler().readGetRequest(url);
            if (result.toLowerCase().contains("detail=invalid authority")) {
                throw new SeeTecException(-21657, "Unauthorized");
            }
            return DahuaHelper.getParameterValues(result, parameterName, alternativParameterName);
        }
        catch (NullPointerException npe) {
            return new String[0];
        }
    }

    protected boolean changedHttpsSettings(NetworkParameter networkParameter) {
        return this.networkParameter.useHTTPS() != networkParameter.useHTTPS() || this.networkParameter.getHTTPport() != networkParameter.getHTTPport() || this.networkParameter.getSSLport() != networkParameter.getSSLport() || !this.networkParameter.getUserPWD()[0].equals(networkParameter.getUserPWD()[0]) || !this.networkParameter.getUserPWD()[1].equals(networkParameter.getUserPWD()[1]) || this.networkParameter.getSoTimeout() != networkParameter.getSoTimeout() || !this.networkParameter.getHost().equals(networkParameter.getHost());
    }

    protected synchronized HttpHandler getHttpHandler() {
        try {
            return new HttpHandlerImpl(this.networkParameter);
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while reading configuration for " + this + ": " + ex.getMessage());
            return null;
        }
    }

    public static boolean checkIsVideoCodecSet(String cameraConfiguration, int channelID, String streamName, Codec videoCodec) {
        String[] parametersOnCamera;
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty() && videoCodec != null && (parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Compression")).length == 1) {
            switch (videoCodec) {
                case H264: {
                    result = parametersOnCamera[0].toLowerCase().trim().equals("h.264");
                    break;
                }
                case H265: {
                    result = parametersOnCamera[0].toLowerCase().trim().equals("h.265");
                    break;
                }
                default: {
                    result = parametersOnCamera[0].toLowerCase().trim().equals("mjpg");
                }
            }
        }
        return result;
    }

    public static boolean checkIsVideoEnabled(String cameraConfiguration, int channelID, String streamName, int streamNumber) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".VideoEnable");
            result = streamNumber == 0 ? true : parametersOnCamera.length == 1 && parametersOnCamera[0].equalsIgnoreCase("true");
        }
        return result;
    }

    public static boolean checkIsResolutionEnabled(String cameraConfiguration, int channelID, String streamName, int height, int width) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Height");
            result = parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Integer.toString(height));
            parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Width");
            result &= parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Integer.toString(width));
        }
        return result;
    }

    public static boolean checkIsAudioSet(String cameraConfiguration, int channelID, String streamName, boolean isAudioEnabled) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".AudioEnable");
            result = parametersOnCamera.length == 1 && isAudioEnabled && parametersOnCamera[0].equalsIgnoreCase("true") || !isAudioEnabled && parametersOnCamera[0].equalsIgnoreCase("false");
        }
        return result;
    }

    public static boolean checkIsBitrateEnabled(String cameraConfiguration, int channelID, String streamName, int bitrate) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.BitRate");
            result = parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Integer.toString(bitrate));
        }
        return result;
    }

    public static boolean checkIsBitrateControlEnabled(String cameraConfiguration, int channelID, String streamName, boolean constantBitrateUsed) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.BitRateControl");
            result = parametersOnCamera.length == 1 && constantBitrateUsed && parametersOnCamera[0].toLowerCase().trim().equals("cbr") || !constantBitrateUsed && parametersOnCamera[0].toLowerCase().trim().equals("vbr");
        }
        return result;
    }

    public static boolean checkIsQualitySet(String cameraConfiguration, int channelID, String streamName, Codec videoCodec, int quality) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty() && videoCodec != null) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Quality");
            result = videoCodec == Codec.MJPEG ? true : parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Integer.toString(quality));
        }
        return result;
    }

    public static boolean checkIsIFrameDistanceSet(String cameraConfiguration, int channelID, String streamName, long iFrameDist, Codec videoCodec) {
        boolean result = false;
        if (videoCodec == Codec.MJPEG) {
            result = true;
        }
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty() && videoCodec != null) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.GOP");
            result = parametersOnCamera.length == 1 && parametersOnCamera[0].equals(Long.toString(iFrameDist));
        }
        return result;
    }

    public static boolean checkIsProfileSet(String cameraConfiguration, int channelID, String streamName, String profileName) {
        boolean result = false;
        if (!(cameraConfiguration == null || cameraConfiguration.isEmpty() || streamName == null || streamName.isEmpty() || profileName == null || profileName.isEmpty())) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Video.Profile");
            result = parametersOnCamera.length == 1 && parametersOnCamera[0].toLowerCase().equals(profileName.toLowerCase());
        }
        return result;
    }

    public static boolean checkIsAudioCodecSet(String cameraConfiguration, int channelID, String streamName, boolean audioEnabled, Codec audioCodec, Codec videoCodec) {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty() && streamName != null && !streamName.isEmpty() && audioCodec != null && videoCodec != null) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.Encode[" + channelID + "]." + streamName + ".Audio.Compression");
            result = !audioEnabled || videoCodec == Codec.MJPEG ? true : parametersOnCamera.length == 1 && (audioCodec.equals((Object)Codec.G711U) && parametersOnCamera[0].toLowerCase().trim().equals("g.711mu") || audioCodec.equals((Object)Codec.G711A) && parametersOnCamera[0].toLowerCase().trim().equals("g.711a"));
        }
        return result;
    }

    public static boolean checkIsRTSPPortSet(String cameraConfiguration, int rtspPort) throws SeeTecException {
        boolean result = false;
        if (cameraConfiguration != null && !cameraConfiguration.isEmpty()) {
            String[] parametersOnCamera = DahuaHelper.getParameterValues(cameraConfiguration, "table.RTSP.Port");
            try {
                result = parametersOnCamera.length == 1 && Integer.parseInt(parametersOnCamera[0].trim()) == rtspPort;
            }
            catch (NumberFormatException ex) {
                throw new SeeTecException(-20033, "Error while converting String to number. String to convert: " + parametersOnCamera[0].trim());
            }
        }
        return result;
    }

    public static boolean isFirmwareGreaterOrEqual(String firmwareGiven, int mayor, int minor) throws SeeTecException {
        String[] firmwareParts;
        boolean result = false;
        if (firmwareGiven != null && !firmwareGiven.isEmpty() && (firmwareParts = firmwareGiven.split("\\.")).length >= 2) {
            int secondPart;
            int firstPart;
            try {
                firstPart = Integer.parseInt(firmwareParts[0].trim());
            }
            catch (NumberFormatException ex) {
                throw new SeeTecException(-20002, "Exception while converting string to number. String to convert: " + firmwareParts[0].trim());
            }
            try {
                secondPart = Integer.parseInt(firmwareParts[1].trim());
            }
            catch (NumberFormatException ex) {
                throw new SeeTecException(-20002, "Exception while converting string to number. String to convert: " + firmwareParts[1].trim());
            }
            if (firstPart > mayor) {
                return true;
            }
            if (firstPart < mayor) {
                return false;
            }
            return secondPart >= minor;
        }
        return result;
    }

    public static String matchNames(String triggerName) {
        if (triggerName == null || triggerName.isEmpty()) {
            return "";
        }
        switch (triggerName) {
            case "AlarmLocal": {
                return "Alarm";
            }
            case "VideoBlind": {
                return "BlindDetect[0]";
            }
            case "LoginFailure": {
                return "LoginFailureAlarm";
            }
            case "VideoLoss": {
                return "LossDetect[0]";
            }
            case "VideoMotion": {
                return "MotionDetect[0]";
            }
            case "MoveDetection": {
                return "MovedDetect[0]";
            }
            case "AlarmNet": {
                return "NetAlarm[0]";
            }
            case "VideoUnFocus": {
                return "UnFocusDetect[0]";
            }
        }
        return triggerName;
    }

    protected static boolean genericEventListContainsEvent(List<GenericEventDefinitionType> eventList, GenericEventDefinitionType event) {
        for (GenericEventDefinitionType genericEventDefinitionType : eventList) {
            String eventWithoutChannel = "";
            eventWithoutChannel = event.getEventType().contains("[") ? event.getEventType().substring(0, event.getEventType().indexOf("[")) : event.getEventType();
            if (!event.getEventType().equals(genericEventDefinitionType.getEventType()) && !eventWithoutChannel.equals(genericEventDefinitionType.getEventType()) || event.getSourceNumber() != genericEventDefinitionType.getSourceNumber()) continue;
            return true;
        }
        return false;
    }

    protected long convertSimpleDateTimeToTimestamp(String simpleDateTime) throws SeeTecException, ConfigurationException {
        long timestamp = 0L;
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime localDateTime = LocalDateTime.parse(simpleDateTime, dateTimeFormatter);
            Instant instant = localDateTime.toInstant(ZoneOffset.UTC);
            timestamp = instant.toEpochMilli();
            timestamp += this.getTimeDifferenceBetweenDahuaTimeAndSystemTime();
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception whild trying to parse date " + simpleDateTime + " for " + this);
        }
        return timestamp;
    }

    protected String convertTimestampToSimpleDateTime(long timestamp) {
        long time = timestamp - this.getTimeDifferenceBetweenDahuaTimeAndSystemTime();
        String returnValue = LocalDateTime.ofEpochSecond(time / 1000L, 0, ZoneOffset.UTC).toString().replace("T", " ");
        return this.complementDateString(returnValue);
    }

    protected String complementDateString(String input) {
        String result = input;
        int numberOfColons = (int)input.chars().filter(c -> c == 58).count();
        if (numberOfColons == 1) {
            result = result + ":00";
        }
        return result;
    }

    protected String convertTimestampToDahuaRtspDateTime(long timestamp) {
        LocalDateTime time = LocalDateTime.ofEpochSecond(timestamp / 1000L, 0, ZoneOffset.UTC);
        time = time.minus(this.getTimeDifferenceBetweenDahuaTimeAndSystemTime(), ChronoUnit.MILLIS);
        return time.format(DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss"));
    }

    protected Long getTimeDifferenceFromDevice() throws ConfigurationException, SeeTecException {
        String currentTimeData = this.getHttpHandler().readGetRequest("/cgi-bin/global.cgi?action=getCurrentTime");
        String[] timeOnDevice = currentTimeData.split("=");
        if (timeOnDevice.length > 1) {
            String timeInSimpleDateFormat = timeOnDevice[1].replace("\r\n", "");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime localDateTime = LocalDateTime.parse(timeInSimpleDateFormat, dateTimeFormatter);
            Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
            long millis = instant.toEpochMilli();
            return System.currentTimeMillis() - millis;
        }
        return 0L;
    }

    protected static int getTimeZoneOffset(int timeZoneNumber) {
        int offset = 0;
        switch (timeZoneNumber) {
            case 1: {
                offset = 3600;
                break;
            }
            case 2: {
                offset = 7200;
                break;
            }
            case 3: {
                offset = 10800;
                break;
            }
            case 4: {
                offset = 12600;
                break;
            }
            case 5: {
                offset = 14400;
                break;
            }
            case 6: {
                offset = 16200;
                break;
            }
            case 7: {
                offset = 18000;
                break;
            }
            case 8: {
                offset = 19800;
                break;
            }
            case 9: {
                offset = 20700;
                break;
            }
            case 10: {
                offset = 21600;
                break;
            }
            case 11: {
                offset = 23400;
                break;
            }
            case 12: {
                offset = 25200;
                break;
            }
            case 13: {
                offset = 28800;
                break;
            }
            case 14: {
                offset = 32400;
                break;
            }
            case 15: {
                offset = 34200;
                break;
            }
            case 16: {
                offset = 36000;
                break;
            }
            case 17: {
                offset = 39600;
                break;
            }
            case 18: {
                offset = 43200;
                break;
            }
            case 19: {
                offset = 46800;
                break;
            }
            case 20: {
                offset = -3600;
                break;
            }
            case 21: {
                offset = -7200;
                break;
            }
            case 22: {
                offset = -10800;
                break;
            }
            case 23: {
                offset = -12600;
                break;
            }
            case 24: {
                offset = -14400;
                break;
            }
            case 25: {
                offset = -18000;
                break;
            }
            case 26: {
                offset = -21600;
                break;
            }
            case 27: {
                offset = -25200;
                break;
            }
            case 28: {
                offset = -28800;
                break;
            }
            case 29: {
                offset = -32400;
                break;
            }
            case 30: {
                offset = -36000;
                break;
            }
            case 31: {
                offset = -39600;
                break;
            }
            case 32: {
                offset = -43200;
                break;
            }
            case 33: {
                offset = -16200;
                break;
            }
            case 34: {
                offset = 37800;
                break;
            }
            case 35: {
                offset = 50400;
                break;
            }
            case 36: {
                offset = -34200;
                break;
            }
            case 37: {
                offset = 30600;
                break;
            }
            case 38: {
                offset = 31500;
                break;
            }
            case 39: {
                offset = 45900;
                break;
            }
        }
        return offset;
    }

    public boolean isDaylightSavingTimeActive() throws SeeTecException {
        String responseString = this.getHttpHandler().readGetRequest("/cgi-bin/configManager.cgi?action=getConfig&name=Locales");
        String result = DahuaHelper.getParameterValue(responseString, "table.Locales.DSTEnable");
        if (!result.equalsIgnoreCase("false")) {
            LocalDateTime localDateTime = LocalDateTime.now();
            int monthOnLocalMachine = localDateTime.getMonth().getValue();
            int dayOnLocalMachine = localDateTime.getDayOfMonth();
            int yearOnLocalMachine = localDateTime.getYear();
            int hour = localDateTime.getHour();
            int minute = localDateTime.getMinute();
            Calendar currentTime = Calendar.getInstance(TimeZone.getTimeZone(ZoneId.systemDefault().getId()));
            currentTime.set(1, yearOnLocalMachine);
            currentTime.set(2, monthOnLocalMachine);
            currentTime.set(5, dayOnLocalMachine);
            currentTime.set(11, hour);
            currentTime.set(12, minute);
            currentTime.set(13, localDateTime.getSecond());
            int startDSTYearOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTStart.Year"));
            int endDSTYearOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTEnd.Year"));
            int startDSTMonthOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTStart.Month"));
            int endDSTMonthOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTEnd.Month"));
            int startDSTDayOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTStart.Day"));
            int endDSTDayOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTEnd.Day"));
            int startDSTWeekOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTStart.Week"));
            int endDSTWeekOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTEnd.Week"));
            int startDSTHourOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTStart.Hour"));
            int endDSTHourOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTEnd.Hour"));
            int startDSTMinuteOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTStart.Minute"));
            int endDSTMinuteOnCamera = Integer.parseInt(DahuaHelper.getParameterValue(responseString, "table.Locales.DSTEnd.Minute"));
            Calendar startOfDST = this.getDaylightSavingTimeDate(startDSTYearOnCamera, startDSTMonthOnCamera, startDSTDayOnCamera, startDSTWeekOnCamera, startDSTHourOnCamera, startDSTMinuteOnCamera);
            Calendar endOfDST = this.getDaylightSavingTimeDate(endDSTYearOnCamera, endDSTMonthOnCamera, endDSTDayOnCamera, endDSTWeekOnCamera, endDSTHourOnCamera, endDSTMinuteOnCamera);
            if (currentTime.after(startOfDST) && currentTime.before(endOfDST)) {
                return true;
            }
        }
        return false;
    }

    protected Calendar getDaylightSavingTimeDate(int year, int month, int day, int week, int hour, int minute) {
        int dayOfMonth;
        Calendar calendar = Calendar.getInstance();
        if (week == 0) {
            dayOfMonth = day;
        } else {
            int adaptedDay = day == 0 ? 7 : day;
            DayOfWeek dayOfWeek = DayOfWeek.of(adaptedDay);
            LocalDate localDate = LocalDate.of(year, month, 1);
            dayOfMonth = week > 0 ? localDate.with(TemporalAdjusters.dayOfWeekInMonth(week, dayOfWeek)).getDayOfMonth() : localDate.with(TemporalAdjusters.lastInMonth(dayOfWeek)).getDayOfMonth();
        }
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, dayOfMonth);
        calendar.set(11, hour);
        calendar.set(12, minute);
        return calendar;
    }
}

