/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DahuaEvent {
    private static String CLASS_NAME = "de.seetec.v5.re.cm.device.video.dahua.DahuaEvent";
    private String name;
    private String triggerName;
    private int channel;
    private boolean active;
    private Logger logger = null;
    private String action = "";

    public DahuaEvent(String eventData) {
        String[] htmlElements;
        this.logger = LogManager.getLogger((String)CLASS_NAME);
        for (String htmlElement : htmlElements = eventData.split("\r\n")) {
            String[] eventElements;
            if (!htmlElement.contains("Code=")) continue;
            for (String eventElement : eventElements = htmlElement.split(";")) {
                if (eventElement.contains("Code=")) {
                    this.triggerName = eventElement.replace("Code=", "");
                    this.name = DahuaEvent.matchTriggerNameToConfigurationName(this.triggerName);
                    continue;
                }
                if (eventElement.contains("action=")) {
                    this.action = eventElement.replace("action=", "");
                    continue;
                }
                if (!eventElement.contains("index=")) continue;
                if (DahuaEvent.isAudioSourceEvent(this.name)) {
                    this.channel = 0;
                    continue;
                }
                try {
                    this.channel = Integer.parseInt(eventElement.replace("index=", "")) + 1;
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Error while trying to convert channel number to integer for inputstring " + eventElement.replace("index=", ""));
                }
            }
            if (this.channel <= 0 || !this.name.contains("[]")) continue;
            this.name = this.name.replace("[]", "[" + (this.channel - 1) + "]");
        }
    }

    DahuaEvent(String eventName, int sourceNumber) {
        this.name = eventName;
        this.channel = sourceNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public String getAction() {
        return this.action;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    protected static String matchTriggerNameToConfigurationName(String configurationName) {
        if (configurationName == null || configurationName.isEmpty()) {
            return "";
        }
        switch (configurationName) {
            case "AlarmLocal": {
                return "Alarm";
            }
            case "VideoBlind": {
                return "BlindDetect[]";
            }
            case "LoginFailure": {
                return "LoginFailureAlarm";
            }
            case "VideoLoss": {
                return "LossDetect[]";
            }
            case "VideoMotion": {
                return "MotionDetect[]";
            }
            case "MoveDetection": 
            case "SceneChange": {
                return "MovedDetect[]";
            }
            case "AlarmNet": {
                return "NetAlarm[]";
            }
            case "VideoUnFocus": {
                return "UnFocusDetect[]";
            }
            case "AudioAnomaly": {
                return "AudioDetect[]";
            }
        }
        return configurationName;
    }

    public static ArrayList<String> getAllowList() {
        ArrayList<String> allowList = new ArrayList<String>();
        allowList.add("LoginFailureAlarm");
        allowList.add("AudioDetect");
        allowList.add("BlindDetect");
        allowList.add("FaceDetection");
        allowList.add("LossDetect");
        allowList.add("MotionDetect");
        allowList.add("MovedDetect");
        allowList.add("ExAlarm");
        allowList.add("StorageFailure");
        allowList.add("StorageLowSpace");
        allowList.add("StorageNotExist");
        allowList.add("UnFocusDetect");
        allowList.add("CrossLineDetection");
        allowList.add("CrossRegionDetection");
        allowList.add("TakenAwayDetection");
        allowList.add("LeftDetection");
        return allowList;
    }

    public static ArrayList<String> getStartStopTriggerList() {
        ArrayList<String> allowList = new ArrayList<String>();
        allowList.add("MotionDetect");
        allowList.add("CrossLineDetection");
        allowList.add("CrossRegionDetection");
        allowList.add("TakenAwayDetection");
        allowList.add("LeftDetection");
        allowList.add("BlindDetect");
        allowList.add("MovedDetect");
        allowList.add("AudioDetect");
        allowList.add("AudioMutation");
        allowList.add("FaceDetection");
        allowList.add("UnFocusDetect");
        allowList.add("StorageNotExist");
        allowList.add("StorageFailure");
        allowList.add("StorageLowSpace");
        allowList.add("WanderDetection");
        allowList.add("AnatomyTempDetect");
        return allowList;
    }

    public static boolean isDeviceBasedEvent(String eventName) {
        String name = eventName.trim().toLowerCase();
        ArrayList<String> deviceEventList = new ArrayList<String>();
        deviceEventList.add("loginfailure");
        deviceEventList.add("batterypower");
        deviceEventList.add("batterylowpower");
        deviceEventList.add("batterycharging");
        deviceEventList.add("storagenotexist");
        deviceEventList.add("storagefailure");
        deviceEventList.add("storagelowspace");
        deviceEventList.add("anatomytempdetect");
        return deviceEventList.contains(name);
    }

    public static boolean isAudioSourceEvent(String eventName) {
        String name = eventName.trim().toLowerCase();
        name = DahuaEvent.removeSquareBrackets(name);
        ArrayList<String> deviceEventList = new ArrayList<String>();
        deviceEventList.add("audiomutation");
        deviceEventList.add("audioanomaly");
        deviceEventList.add("audiodetect");
        return deviceEventList.contains(name);
    }

    public static boolean isBlocklistedEvent(String eventName) {
        String name = eventName.trim().toLowerCase();
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add("alarmlocal");
        return blockList.contains(name);
    }

    public static String removeSquareBrackets(String eventName) {
        String result = eventName;
        if (result.contains("[")) {
            result = result.substring(0, result.indexOf("["));
        }
        return result;
    }
}

