/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.EdgeStoragePlaybackSpeedType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedEdgeStoragePlaybackSpeedsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.dahua.DahuaCommand;
import de.seetec.v5.re.cm.device.video.dahua.DahuaEvent;
import de.seetec.v5.re.cm.device.video.dahua.DahuaHelper;
import de.seetec.v5.re.cm.device.video.dahua.DahuaIOHandler;
import de.seetec.v5.re.cm.device.video.dahua.Resolution;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class DahuaDevice
extends VideoServer {
    private int streamSet;
    private Boolean isVideoSystemPAL = null;
    private DahuaHelper dahuaHelper;
    private NetworkParameter networkParameter;
    private boolean authorized;

    public DahuaHelper getDahuaHelper() throws ConfigurationException {
        if (this.dahuaHelper == null || this.dahuaHelper.changedHttpsSettings(this.getDeviceCnf().getNetworkParameter())) {
            this.dahuaHelper = new DahuaHelper(this.getDeviceCnf().getNetworkParameter());
        }
        return this.dahuaHelper;
    }

    public int getStreamSet() {
        return this.streamSet;
    }

    public void setStreamSet(int streamSet) {
        this.streamSet = streamSet;
    }

    public NetworkParameter getDahuaNetworkParameter() throws ConfigurationException {
        if (this.networkParameter == null) {
            this.networkParameter = this.getDeviceCnf().getNetworkParameter();
        }
        return this.networkParameter;
    }

    @Override
    public VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        try {
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer("Dahua");
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(MediaID.VIDEO_SOURCE_PTZ.getType());
            String[] parameters = this.getDahuaHelper().getCaps(DahuaCommand.DEVICE_TYPE, "type", "");
            String cameraName = "";
            if (parameters.length == 1) {
                cameraName = parameters[0].toUpperCase();
            }
            videoCameraDefinition.setName(cameraName);
            videoCameraDefinition.setEntityType(215603L);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = new FeaturesType();
            featuresType.setCanContinuousPan(true);
            featuresType.setCanContinuousTilt(true);
            featuresType.setCanContinuousZoom(true);
            featuresType.setCanAbsolutePan(false);
            featuresType.setCanAbsoluteTilt(false);
            featuresType.setCanAbsoluteZoom(false);
            featuresType.setCanRelativePan(false);
            featuresType.setCanRelativeTilt(false);
            featuresType.setCanRelativeZoom(false);
            featuresType.setMinPan(-180000);
            featuresType.setMaxPan(180000);
            featuresType.setMinTilt(0);
            featuresType.setMaxTilt(90000);
            featuresType.setMinZoom(0);
            featuresType.setMaxZoom(100000);
            featuresType.setMinSpeed(0);
            featuresType.setMaxSpeed(100000);
            featuresType.setPTZMinContinuousLevel(10000);
            featuresType.setPTZMaxContinuousLevel(100000);
            featuresType.setPTZContinuousSpeedFactor(1000);
            featuresType.setCanFocus(true);
            featuresType.setCanAutoFocus(true);
            featuresType.setCanIris(true);
            featuresType.setCanAutoIris(true);
            featuresType.setCanNullLux(true);
            featuresType.setCanAutoNullLux(true);
            featuresType.setCanPreset(true);
            try {
                String currentSignature = this.getDahuaHelper().readHttpValue("/cgi-bin/magicBox.cgi?action=getSoftwareVersion", "version", "")[0];
                if (DahuaHelper.isFirmwareGreaterOrEqual(currentSignature, 2, 423)) {
                    featuresType.setCanCenterPT(true);
                }
            }
            catch (Exception ex) {
                this.logger.warn("Error while reading Firmware for " + this + " : " + ex.getMessage());
            }
            videoCameraDefinition.setFeatures(featuresType);
            return videoCameraDefinition;
        }
        catch (Exception exception) {
            this.logger.warn("Error while reading information from " + this);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    public BitrateSettingsType getBitrateSettingsType(CodecType codecType) {
        BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
        bitrateSettingsType.setCanCBR(true);
        bitrateSettingsType.setMinBandwidth(1024);
        bitrateSettingsType.setSupportedBitrates(null);
        if (codecType.getValue() == Codec.H264.getType() || codecType.getValue() == Codec.H265.getType()) {
            bitrateSettingsType.setMaxBandwidth(0x1400000);
            bitrateSettingsType.setCanCBRQuality(false);
            bitrateSettingsType.setCanVBR(true);
            bitrateSettingsType.setCanVBRQuality(true);
            bitrateSettingsType.setCanVBRBandwidth(true);
        } else {
            bitrateSettingsType.setMaxBandwidth(0x3C00000);
        }
        return bitrateSettingsType;
    }

    public ImageRotationCapabilitiesType getImageRotationCapabilitiesType(String videoCaps) throws SeeTecException {
        ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
        SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
        String[] imageFlip = DahuaHelper.getParameterValues(videoCaps, "caps.Flip");
        String[] imageMirror = DahuaHelper.getParameterValues(videoCaps, "caps.Mirror");
        String[] imageRotate90 = DahuaHelper.getParameterValues(videoCaps, "caps.Rotate90");
        boolean flip = false;
        boolean mirror = false;
        boolean rotate90 = false;
        if (imageFlip.length == 1) {
            flip = imageFlip[0].trim().toLowerCase().equals("true");
        }
        if (imageMirror.length == 1) {
            mirror = imageMirror[0].trim().toLowerCase().equals("true");
        }
        if (imageRotate90.length == 1) {
            rotate90 = imageRotate90[0].trim().toLowerCase().equals("true");
        }
        if (flip && mirror) {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
            supportedRotationAnglesType.getInt().add(0);
            supportedRotationAnglesType.getInt().add(180000);
        }
        if (rotate90) {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
            supportedRotationAnglesType.getInt().add(90000);
            supportedRotationAnglesType.getInt().add(270000);
        }
        if (!(rotate90 || flip && mirror)) {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(false);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(false);
            supportedRotationAnglesType.getInt().add(0);
            supportedRotationAnglesType.getInt().add(180000);
        }
        imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        return imageRotationCapabilitiesType;
    }

    public AudioCapabilitiesType getAudioCapabilitiesType(String caps, String audioOut) throws SeeTecException {
        String[] audioValues;
        AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
        AudioCodecsType audioCodecsType = new AudioCodecsType();
        if (caps != null && !caps.isEmpty()) {
            String[] audioCodecList;
            for (String codec : audioCodecList = DahuaHelper.getParameterValues(caps, "caps.caps[0].MainFormat[0].Audio.CompressionTypes", "caps[0].MainFormat[0].Audio.CompressionTypes", "caps.MainFormat[0].Audio.CompressionTypes")) {
                Codec c = null;
                switch (codec.trim().toLowerCase()) {
                    case "g.711mu": {
                        c = Codec.G711U;
                        break;
                    }
                    case "g.726": {
                        c = Codec.G726;
                        break;
                    }
                }
                if (c == null) continue;
                AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
                CodecType codecType = new CodecType();
                codecType.setValue(c.getType());
                audioCodecDefinitionType.setAudioCodec(codecType);
                audioCodecDefinitionType.setBitrate(64000);
                audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
            }
        }
        boolean canAudioOut = false;
        if (audioOut != null && !audioOut.isEmpty() && (audioValues = DahuaHelper.getParameterValues(audioOut, "result")).length > 0) {
            try {
                int numberOfAudioOutputs = Integer.parseInt(audioValues[0].trim());
                if (numberOfAudioOutputs > 0) {
                    canAudioOut = true;
                }
            }
            catch (NumberFormatException ex) {
                this.logger.warn("Could not parse number of audio outputs for " + this + ". Text given: " + audioValues[0].trim());
            }
        }
        if (audioCodecsType.getAudioCodecDefinition().isEmpty()) {
            audioCapabilitiesType.setAudioCodecs(null);
            audioCapabilitiesType.setCanAudio(false);
            audioCapabilitiesType.setCanAudioOut(false);
            audioCapabilitiesType.setNumberOfPossibleAudioStreams(0);
        } else {
            audioCapabilitiesType.setAudioCodecs(audioCodecsType);
            audioCapabilitiesType.setCanAudio(true);
            audioCapabilitiesType.setCanAudioOut(canAudioOut);
            audioCapabilitiesType.setDefaultAudioCodecIndex(0);
            audioCapabilitiesType.setNumberOfPossibleAudioStreams(1);
        }
        return audioCapabilitiesType;
    }

    public List<CodecType> getVideoCodecTypes(String caps, String format) {
        ArrayList<CodecType> ret = new ArrayList<CodecType>();
        if (caps != null && !caps.isEmpty()) {
            String[] codecs;
            for (String codec : codecs = DahuaHelper.getParameterValues(caps, "caps.caps[0]." + format + ".Video.CompressionTypes", "caps[0]." + format + ".Video.CompressionTypes", "caps." + format + ".Video.CompressionTypes")) {
                CodecType codecType;
                if (codec.trim().toLowerCase().equals("h.264")) {
                    codecType = new CodecType();
                    codecType.setValue(Codec.H264.getType());
                    ret.add(codecType);
                    continue;
                }
                if (codec.trim().toLowerCase().equals("h.265")) {
                    codecType = new CodecType();
                    codecType.setValue(Codec.H265.getType());
                    ret.add(codecType);
                    continue;
                }
                if (!codec.trim().toLowerCase().equals("mjpg")) continue;
                codecType = new CodecType();
                codecType.setValue(Codec.MJPEG.getType());
                ret.add(codecType);
            }
        }
        return ret;
    }

    @Override
    protected IOHandler createIOHandler() {
        DahuaIOHandler dahuaIOHandler = new DahuaIOHandler();
        return dahuaIOHandler;
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    protected AvailableIOsType getAvailableIOsType() throws SeeTecException, ConfigurationException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        int i;
        AvailableIOsType availableIOsType = new AvailableIOsType();
        String[] numberOfInAlarms = this.getDahuaHelper().readHttpValue("/cgi-bin/alarm.cgi?action=getInSlots", "result", "");
        int numberOfInputs = 0;
        if (numberOfInAlarms.length == 1) {
            try {
                numberOfInputs = Integer.parseInt(numberOfInAlarms[0].trim());
            }
            catch (NumberFormatException ex) {
                this.logger.warn("Could not parse number of input alarms for " + this + " Value given: " + numberOfInAlarms[0].trim());
            }
        }
        int numberOfOutputs = 0;
        String[] numberOfOutAlarms = this.getDahuaHelper().readHttpValue("/cgi-bin/alarm.cgi?action=getOutSlots", "result", "");
        if (numberOfOutAlarms.length == 1) {
            try {
                numberOfOutputs = Integer.parseInt(numberOfOutAlarms[0].trim());
            }
            catch (NumberFormatException ex) {
                this.logger.warn("Could not parse number of alarm outputs for " + this + " Value given: " + numberOfOutAlarms[0].trim());
            }
        }
        for (i = 0; i < numberOfOutputs; ++i) {
            availableIOsType.getInputOutputCapabilities().add(1);
        }
        for (i = 0; i < numberOfInputs; ++i) {
            availableIOsType.getInputOutputCapabilities().add(0);
        }
        return availableIOsType;
    }

    protected Boolean isPal() throws SeeTecException, ConfigurationException {
        if (this.isVideoSystemPAL == null) {
            this.isVideoSystemPAL = this.readVideoSystem();
        }
        return this.isVideoSystemPAL;
    }

    protected Boolean readVideoSystem() throws SeeTecException, ConfigurationException {
        boolean isPal = false;
        String[] videoSystem = this.getDahuaHelper().getCaps(DahuaCommand.VIDEOSTANDARD, "table.VideoStandard", "");
        if (videoSystem.length == 1 && videoSystem[0].toLowerCase().equals("pal")) {
            isPal = true;
        } else if (videoSystem.length == 1 && !videoSystem[0].toLowerCase().equals("pal")) {
            isPal = false;
        } else {
            this.logger.error("Error while getting video system configuration for " + this);
            throw new SeeTecException(-20100, "Could not retrieve video system configuration ");
        }
        return isPal;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        block17: {
            try {
                String currentSignature = "<unknown>";
                try {
                    currentSignature = this.getDahuaHelper().readHttpValue("/cgi-bin/magicBox.cgi?action=getSoftwareVersion", "version", "")[0];
                }
                catch (Exception ex) {
                    SeeTecException see;
                    if (ex instanceof SeeTecException && (see = (SeeTecException)((Object)ex)).getErrorCode() == -21657) {
                        this.authorized = false;
                        throw see;
                    }
                    this.logger.warn("Error while reading Firmware for " + this + " : " + ex.getMessage());
                    this.logger.warn("Firmware is shown as :" + currentSignature);
                }
                this.authorized = true;
                String currentManufacturer = "Dahua Smart Driver";
                String[] parameters = this.getDahuaHelper().getCaps(DahuaCommand.DEVICE_TYPE, "type", "");
                String currentName = "";
                if (parameters.length == 1) {
                    currentName = parameters[0].toUpperCase();
                }
                String currentComments = "RE_APP_VERSION::7.4.1_11";
                if (signature != null && signature.equals(currentSignature) && manufacturer != null && manufacturer.equals(currentManufacturer) && name != null && name.equals(currentName) && comments != null && comments.equals(currentComments)) break block17;
                DeviceDefinition deviceDefinition = new DeviceDefinition();
                deviceDefinition.setCountFirstChannelOnly(true);
                deviceDefinition.setSignature(currentSignature);
                deviceDefinition.setManufacturer(currentManufacturer);
                CommentsType commentsType = new CommentsType();
                commentsType.getString().add(currentComments);
                deviceDefinition.setComments(commentsType);
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                String apiVersion = "API of HTTP Protocol Specification (Rev. 2.1)";
                SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                supportedApiVersionsType.getString().add("API of HTTP Protocol Specification (Rev. 2.1)");
                deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                deviceDefinition.setDefaultApiVersion("API of HTTP Protocol Specification (Rev. 2.1)");
                String url = "/cgi-bin/devVideoInput.cgi?action=getCaps&channel=0";
                String videoCaps = this.getDahuaHelper().getHttpHandler().readGetRequest(url);
                url = "/cgi-bin/encode.cgi?action=getConfigCaps&channel=0";
                String capabilities = this.getDahuaHelper().getHttpHandler().readGetRequest(url);
                int numberOfVideoSources = this.getNumberOfVideoSourcesFromDevice();
                deviceDefinition.setNoOfCams(numberOfVideoSources);
                DeviceNetworkDefinitionType deviceNetworkDefinitionType = this.getDeviceNetworkDefinitionType();
                deviceDefinition.setDeviceNetworkDefinition(deviceNetworkDefinitionType);
                int numberOfStreams = 1;
                String extraStreamString = this.getDahuaHelper().readHttpValue("/cgi-bin/magicBox.cgi?action=getProductDefinition&name=MaxExtraStream", "table.MaxExtraStream", "")[0];
                try {
                    numberOfStreams += Integer.parseInt(extraStreamString);
                }
                catch (NumberFormatException nfe) {
                    this.logger.warn("Could not read Number of Stream for " + this + " : " + nfe.getMessage() + " Trying to parse following string: " + extraStreamString);
                }
                String audioOut = "result=1";
                try {
                    audioOut = this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/devAudioOutput.cgi?action=getCollect");
                }
                catch (Exception ex) {
                    this.logger.warn("Exception while reading audio out capabilities for " + this + " : " + ex.getMessage());
                    this.logger.warn("Asuming there is one audio output...");
                }
                MultiStreamingDefinitionsType multiStreamingDefinitionsType = this.getMultiStreamingDefinitionsType(capabilities, numberOfStreams);
                SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
                CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
                captureModeDefinitionType.setRebootRequired(false);
                captureModeDefinitionType.setModeSuffix("");
                captureModeDefinitionType.setMaxTotalNumberOfStreams(numberOfStreams);
                captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
                captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
                supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
                deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                deviceDefinition.setDefaultCaptureModeIndex(0);
                ImageRotationCapabilitiesType imageRotationCapabilitiesType = this.getImageRotationCapabilitiesType(videoCaps);
                deviceDefinition.setImageRotationCapabilities(imageRotationCapabilitiesType);
                AudioCapabilitiesType audioCapabilitiesType = this.getAudioCapabilitiesType(capabilities, audioOut);
                deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                AvailableIOsType availableIOsType = this.getAvailableIOsType();
                deviceDefinition.setAvailableIOs(availableIOsType);
                MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = this.getMiscVideoServerCapabilitiesType(videoCaps);
                SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                supportedVideoSourceEntityTypesType.getLong().add(215603L);
                deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                if (miscVideoServerCapabilitiesType.isCanPTZ()) {
                    supportedVideoSourceEntityTypesType.getLong().add(219901L);
                }
                deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
                deviceGroupMembershipsType.getDeviceGroups().add("ShowChannelSelector");
                deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
                deviceGroupMembershipsType.getDeviceGroups().add("MultistreamResolutionCombinationWarning");
                deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
                if (DahuaHelper.isFirmwareGreaterOrEqual(currentSignature, 2, 423)) {
                    deviceGroupMembershipsType.getDeviceGroups().add("OpticalZoomAreaSupported");
                }
                if (this.supportsEdgeStorage()) {
                    deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorage");
                    deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorageVideoImport");
                    SupportedEdgeStoragePlaybackSpeedsType supportedEdgeStoragePlaybackSpeedsType = new SupportedEdgeStoragePlaybackSpeedsType();
                    EdgeStoragePlaybackSpeedType singleSpeed = new EdgeStoragePlaybackSpeedType();
                    singleSpeed.setSpeedValue(1);
                    singleSpeed.setSpeedName("1x");
                    supportedEdgeStoragePlaybackSpeedsType.getEdgeStoragePlaybackSpeed().add(singleSpeed);
                    deviceDefinition.setSupportedEdgeStoragePlaybackSpeeds(supportedEdgeStoragePlaybackSpeedsType);
                }
                deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                deviceDefinition.setEntityType(205603L);
                deviceDefinition.setName(currentName);
                if (this.logger.isDebugEnabled()) {
                    try {
                        String deviceDefinitionXml = Basic.marshalXML((Object)deviceDefinition);
                        this.logger.debug(deviceDefinitionXml);
                    }
                    catch (Exception ex) {
                        this.logger.debug("Exception while displaying device definition for " + this);
                    }
                }
                return deviceDefinition;
            }
            catch (Exception exception) {
                this.logger.warn("Error while reading information from " + this, (Throwable)exception);
                if (exception instanceof SeeTecException) {
                    throw (SeeTecException)((Object)exception);
                }
                throw new SeeTecException(-21600, exception.getMessage());
            }
        }
        return null;
    }

    protected boolean supportsEdgeStorage() {
        try {
            String url = "/cgi-bin/storage.cgi?action=getCaps";
            String edgeStorageCaps = this.getDahuaHelper().getHttpHandler().readGetRequest(url);
            return DahuaHelper.getParameterValue(edgeStorageCaps, "caps.IsLocalStore").equals("true");
        }
        catch (Exception ex) {
            return false;
        }
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just Dahua default pass which is a proper default setting in this case.")
    protected DeviceNetworkDefinitionType getDeviceNetworkDefinitionType() {
        DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
        deviceNetworkDefinitionType.setCanHttps(true);
        deviceNetworkDefinitionType.setDefaultHttpPort(80);
        deviceNetworkDefinitionType.setDefaultHttpsPort(443);
        deviceNetworkDefinitionType.setCanChangeHttpPort(true);
        deviceNetworkDefinitionType.setCanChangeHttpsPort(true);
        deviceNetworkDefinitionType.setDefaultPassword("admin");
        deviceNetworkDefinitionType.setDefaultUserName("admin");
        deviceNetworkDefinitionType.setUseAuthentication(true);
        return deviceNetworkDefinitionType;
    }

    private MultiStreamingDefinitionsType getMultiStreamingDefinitionsType(String caps, int maxNumberOfStreams) throws SeeTecException, ConfigurationException {
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        for (int i = 1; i < maxNumberOfStreams; ++i) {
            int height;
            int width;
            String format = "ExtraFormat[" + (i - 1) + "]";
            String[] resolutions = DahuaHelper.getParameterValues(caps, "caps[0]." + format + ".Video.ResolutionTypes", "caps.caps[0]." + format + ".Video.ResolutionTypes", "caps." + format + ".Video.ResolutionTypes");
            Resolution res = this.getSmallestResolution(resolutions);
            if (res == null) continue;
            if (this.isPal().booleanValue()) {
                width = res.getWidthPAL();
                height = res.getHeightPAL();
            } else {
                width = res.getWidthNTSC();
                height = res.getHeightNTSC();
            }
            this.setResolution(format, width, height);
        }
        int overallMaxFps = 0;
        for (int i = 0; i < maxNumberOfStreams; ++i) {
            String format = "MainFormat[0]";
            if (i > 0) {
                format = "ExtraFormat[" + (i - 1) + "]";
            }
            this.setFramerate(1, "&Encode[0]." + format + ".");
            List<CodecType> codecTypeList = this.getVideoCodecTypes(caps, format);
            for (int j = codecTypeList.size() - 1; j >= 0; --j) {
                CodecType codecType = codecTypeList.get(j);
                this.setCodec(codecType, format);
                StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
                streamDefinitionType.setStreamingMode(codecType);
                RtspSettingsType rtspSettingsType = new RtspSettingsType();
                rtspSettingsType.setCanChangeRtspPort(true);
                rtspSettingsType.setCanMultipleRtspPorts(false);
                rtspSettingsType.setDefaultRtspPort(554);
                SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
                if (codecType.getValue() == Codec.H264.getType()) {
                    streamDefinitionType.setMinIFrameDistance(1000);
                    streamDefinitionType.setMaxIFrameDistance(100000);
                    streamDefinitionType.setHideBandwithField(false);
                    streamDefinitionType.setHideKompressionField(false);
                    SupportedMPEGProfileIDs supportedMPEGProfileIDs = new SupportedMPEGProfileIDs();
                    for (int k = 0; k < 5; ++k) {
                        String[] profile = DahuaHelper.getParameterValues(caps, "caps[0]." + format + ".Video.H264Profile[" + k + "]", "caps.caps[0]." + format + ".Video.H264Profile[" + k + "]", "caps." + format + ".Video.H264Profile[" + k + "]");
                        if (profile.length != 1) continue;
                        MpegProfile h264Profile = null;
                        switch (profile[0].toLowerCase()) {
                            case "baseline": {
                                h264Profile = MpegProfile.BASELINE;
                                break;
                            }
                            case "main": {
                                h264Profile = MpegProfile.MAIN;
                                break;
                            }
                            case "extended": {
                                h264Profile = MpegProfile.EXTENDED;
                                break;
                            }
                            case "high": {
                                h264Profile = MpegProfile.HIGH;
                                break;
                            }
                        }
                        if (h264Profile == null) continue;
                        supportedMPEGProfileIDs.getInt().add(h264Profile.getType());
                    }
                    streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfileIDs);
                } else if (codecType.getValue() == Codec.H265.getType()) {
                    streamDefinitionType.setMinIFrameDistance(1000);
                    streamDefinitionType.setMaxIFrameDistance(100000);
                    streamDefinitionType.setHideBandwithField(false);
                    streamDefinitionType.setHideKompressionField(false);
                } else {
                    streamDefinitionType.setHideBandwithField(false);
                    streamDefinitionType.setHideKompressionField(true);
                }
                if (i == 0) {
                    streamDefinitionType.setName("Main Stream");
                } else {
                    streamDefinitionType.setName("Sub Stream " + i);
                }
                streamDefinitionType.setDefaultCameraResolutionIndex(0);
                streamDefinitionType.setDefaultMilliFPS(8000);
                streamDefinitionType.setDefaultTransmissionTypeIndex(0);
                streamDefinitionType.setHideFPSField(false);
                streamDefinitionType.setHideIFrameField(false);
                streamDefinitionType.setMaxNumberOfStreams(1);
                streamDefinitionType.setNoOfHWMDInputs(1);
                streamDefinitionType.setRtspSettings(rtspSettingsType);
                SupportedCameraResolutionsType supportedCameraResolutionsTypeStream = new SupportedCameraResolutionsType();
                String[] resolutions = DahuaHelper.getParameterValues(caps, "caps[0]." + format + ".Video.ResolutionTypes", "caps.caps[0]." + format + ".Video.ResolutionTypes", "caps." + format + ".Video.ResolutionTypes");
                if (i == 0) {
                    Collections.reverse(Arrays.asList(resolutions));
                }
                for (String resolution : resolutions) {
                    Resolution res = Resolution.getByName(resolution.toLowerCase());
                    int width = -1;
                    int height = -1;
                    String resolutionName = "";
                    if (res != null) {
                        resolutionName = res.getName();
                        width = res.getWidthNTSC();
                        height = res.getHeightNTSC();
                        if (this.isPal().booleanValue()) {
                            width = res.getWidthPAL();
                            height = res.getHeightPAL();
                        }
                    } else {
                        String[] resolutionParts = resolution.toLowerCase().trim().split("x");
                        if (resolutionParts.length == 2) {
                            try {
                                width = Integer.parseInt(resolutionParts[0]);
                                height = Integer.parseInt(resolutionParts[1]);
                            }
                            catch (NumberFormatException ex) {
                                this.logger.warn("Could not parse resolution " + resolutionParts[0] + "x" + resolutionParts[1]);
                            }
                            resolutionName = resolution;
                        }
                    }
                    if (width <= 0 || height <= 0) continue;
                    this.setResolution(format, width, height);
                    String url = "/cgi-bin/encode.cgi?action=getConfigCaps&channel=0";
                    caps = this.getDahuaHelper().getHttpHandler().readGetRequest(url);
                    CameraResolutionType cameraResolutionType = new CameraResolutionType();
                    cameraResolutionType.setDisplayResolution(resolutionName);
                    cameraResolutionType.setHeight(height);
                    cameraResolutionType.setWidth(width);
                    if (i == 0) {
                        String[] maxFramerate = DahuaHelper.getParameterValues(caps, "caps.caps[0]." + format + ".Video.FPSMax", "caps[0]." + format + ".Video.FPSMax", "caps." + format + ".Video.FPSMax");
                        int maxFps = 20000;
                        if (maxFramerate.length == 1) {
                            try {
                                maxFps = Integer.parseInt(maxFramerate[0].trim()) * 1000;
                            }
                            catch (NumberFormatException ex) {
                                this.logger.warn("Could not parse framerate value for " + this + ": Framerate read from device: " + maxFramerate[0]);
                            }
                        }
                        cameraResolutionType.setMaxMilliFPS(maxFps);
                        if (maxFps > overallMaxFps) {
                            overallMaxFps = maxFps;
                        }
                    } else {
                        cameraResolutionType.setMaxMilliFPS(overallMaxFps);
                    }
                    cameraResolutionType.setMinMilliFPS(1);
                    List<CameraResolutionType> cameraResolutions = supportedCameraResolutionsTypeStream.getCameraResolution();
                    if (DahuaDevice.containsResolution(cameraResolutions, cameraResolutionType)) continue;
                    if (i == 0) {
                        supportedCameraResolutionsTypeStream.getCameraResolution().add(0, cameraResolutionType);
                        continue;
                    }
                    supportedCameraResolutionsTypeStream.getCameraResolution().add(cameraResolutionType);
                }
                BitrateSettingsType bitrateSettingsType = this.getBitrateSettingsType(codecType);
                streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsTypeStream);
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
            }
        }
        return multiStreamingDefinitionsType;
    }

    protected void setResolution(String format, int width, int height) throws SeeTecException, ConfigurationException {
        String url = "/cgi-bin/configManager.cgi?action=setConfig&Encode[0]." + format + ".Video.Width=" + width + "&Encode[0]." + format + ".Video.Height=" + height;
        this.getDahuaHelper().getHttpHandler().readGetRequest(url);
    }

    protected MiscVideoServerCapabilitiesType getMiscVideoServerCapabilitiesType(String videoCaps) throws SeeTecException, ConfigurationException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
        String[] numberOfTitlesList = DahuaHelper.getParameterValues(videoCaps, "caps.TitleCount");
        int numberOfTitles = 0;
        if (numberOfTitlesList.length == 1) {
            try {
                numberOfTitles = Integer.parseInt(numberOfTitlesList[0].trim());
            }
            catch (NumberFormatException es) {
                this.logger.warn("Could not parse number of possible titles for " + this + " Number given: " + numberOfTitlesList[0].trim());
            }
        }
        miscVideoServerCapabilitiesType.setCanTimeDate(true);
        miscVideoServerCapabilitiesType.setCanTitle(numberOfTitles > 0);
        miscVideoServerCapabilitiesType.setCanDetectTampering(true);
        miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
        miscVideoServerCapabilitiesType.setNoOfRS232S(0);
        miscVideoServerCapabilitiesType.setCanTimeshift(false);
        miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
        miscVideoServerCapabilitiesType.setCanPTZ(true);
        return miscVideoServerCapabilitiesType;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws ConfigurationException, SeeTecException {
        GenericEventDefinitionType bodyTemperatureEvent;
        SupportedGenericEventsType supportedGenericEventsType = this.getGenericEventTriggerFromConfiguration();
        String eventList = "";
        try {
            eventList = this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/eventManager.cgi?action=getExposureEvents");
        }
        catch (Exception ex) {
            this.logger.info("Could not get list of smart events. Trying to get smart events from configuration for " + this);
        }
        if (!eventList.isEmpty()) {
            SupportedGenericEventsType additionalEventsType = this.getGenericEventTriggerFromCapabilityList(eventList);
            for (GenericEventDefinitionType genericEventDefinitionType : additionalEventsType.getGenericEventDefinition()) {
                if (DahuaHelper.genericEventListContainsEvent(supportedGenericEventsType.getGenericEventDefinition(), genericEventDefinitionType)) continue;
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
        }
        if ((bodyTemperatureEvent = this.getBodyTemperatureEventTrigger()) != null) {
            supportedGenericEventsType.getGenericEventDefinition().add(bodyTemperatureEvent);
        }
        return supportedGenericEventsType;
    }

    private void setCodec(CodecType codecType, String streamName) throws ConfigurationException, SeeTecException {
        StringBuilder url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig");
        url.append("&Encode[0].").append(streamName).append(".").append("Video.Compression=");
        if (codecType.getValue() == Codec.H264.getType()) {
            url.append("H.264");
        } else if (codecType.getValue() == Codec.MJPEG.getType()) {
            url.append("MJPG");
        } else {
            url.append("H.265");
        }
        this.getDahuaHelper().getHttpHandler().readGetRequest(url.toString());
    }

    protected void setFramerate(int fps, String format) throws ConfigurationException, SeeTecException {
        StringBuilder url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig");
        url.append(format);
        url.append("Video.FPS=").append(fps);
        this.getDahuaHelper().getHttpHandler().readGetRequest(url.toString());
    }

    protected boolean isAuthorized() {
        return this.authorized;
    }

    protected int getNumberOfVideoSourcesFromDevice() {
        int numberOfVideoSources = 1;
        try {
            String streams = this.getDahuaHelper().readHttpValue("/cgi-bin/devVideoInput.cgi?action=getCollect", "result", "")[0];
            numberOfVideoSources = Integer.parseInt(streams);
        }
        catch (Exception ex) {
            this.getLogger().warn("Could not read number of video inputs. Asuming one video source");
        }
        return numberOfVideoSources;
    }

    protected int getNumberOfAudioSourcesFromDevice() {
        int numberOfAudioSources = 1;
        try {
            String streams = this.getDahuaHelper().readHttpValue("/cgi-bin/devAudioInput.cgi?action=getCollect", "result", "")[0];
            numberOfAudioSources = Integer.parseInt(streams);
        }
        catch (Exception ex) {
            this.getLogger().warn("Could not read number of audio inputs. Asuming one audio source");
        }
        return numberOfAudioSources;
    }

    public static boolean containsResolution(List<CameraResolutionType> cameraResolutions, CameraResolutionType cameraResolution) {
        if (cameraResolution != null && cameraResolutions != null) {
            for (CameraResolutionType cr : cameraResolutions) {
                if (cr.getHeight() != cameraResolution.getHeight() || cr.getWidth() != cameraResolution.getWidth()) continue;
                return true;
            }
        }
        return false;
    }

    protected Resolution getSmallestResolution(String[] resolutions) {
        Resolution res = null;
        if (resolutions != null && resolutions.length > 0) {
            res = Resolution.getByName(resolutions[0]);
            for (String resolutionName : resolutions) {
                Resolution newResolution = Resolution.getByName(resolutionName);
                if (newResolution == null || newResolution.getHeightNTSC() * newResolution.getWidthNTSC() + newResolution.getHeightPAL() * newResolution.getWidthPAL() >= res.getHeightNTSC() * res.getWidthNTSC() + res.getHeightPAL() * res.getWidthPAL()) continue;
                res = newResolution;
            }
        }
        return res;
    }

    protected SupportedGenericEventsType getGenericEventTriggerFromConfiguration() throws ConfigurationException, SeeTecException {
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        String url = "/cgi-bin/configManager.cgi?action=getConfig&name=All";
        String configuration = this.getDahuaHelper().getHttpHandler().readGetRequest(url);
        String[] configLines = configuration.split("\r\n");
        ArrayList<String> allowList = DahuaEvent.getAllowList();
        String regex = "table.All.VideoAnalyseRule\\[.\\]\\[.+\\].Type.*";
        ArrayList<String> events = new ArrayList<String>();
        for (String configLine : configLines) {
            String eventName;
            if (!configLine.matches(regex) || !allowList.contains(DahuaHelper.removeNumber(eventName = configLine.substring(configLine.indexOf("=") + 1)))) continue;
            int channel = 0;
            int numberOfChannels = 0;
            numberOfChannels = DahuaEvent.isDeviceBasedEvent(eventName) ? 1 : (DahuaEvent.isAudioSourceEvent(eventName) ? this.getNumberOfAudioSourcesFromDevice() : this.getNumberOfVideoSourcesFromDevice());
            for (int i = 0; i < numberOfChannels; ++i) {
                if (!DahuaEvent.isDeviceBasedEvent(eventName)) {
                    eventName = eventName + "[" + i + "]";
                    channel = i + 1;
                }
                if (events.contains(eventName)) continue;
                events.add(eventName);
                GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(eventName);
                genericEventDefinitionType.setSourceNumber(channel);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
        }
        regex = "table.All.*.EventHandler.*";
        for (String configLine : configLines) {
            if (!configLine.matches(regex) || configLine.toLowerCase().contains("videoanalyserule")) continue;
            String configurationLine = configLine.replace("table.All.", "");
            if (!allowList.contains(DahuaHelper.removeNumber(configurationLine = configurationLine.substring(0, configurationLine.indexOf(".EventHandler"))))) continue;
            int channelNumber = 0;
            if (configurationLine.contains("[") && configurationLine.contains("]")) {
                String channel = configurationLine.substring(configurationLine.indexOf("[") + 1, configurationLine.indexOf("]"));
                try {
                    channelNumber = Integer.parseInt(channel) + 1;
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Exception while trying to parse " + channel + " to String");
                }
            }
            if (DahuaEvent.isAudioSourceEvent(configurationLine)) {
                channelNumber = 0;
            }
            if (events.contains(configurationLine)) continue;
            events.add(configurationLine);
            GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
            genericEventDefinitionType.setEventType(configurationLine);
            genericEventDefinitionType.setSourceNumber(channelNumber);
            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
        }
        return supportedGenericEventsType;
    }

    protected SupportedGenericEventsType getGenericEventTriggerFromCapabilityList(String capabilityList) {
        String[] eventList = capabilityList.split("\r\n");
        int numberOfVideoSources = this.getNumberOfVideoSourcesFromDevice();
        int numberOfAudioSources = this.getNumberOfAudioSourcesFromDevice();
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        for (String event : eventList) {
            String eventName = event.substring(event.indexOf("=") + 1);
            if (DahuaEvent.isBlocklistedEvent(eventName)) continue;
            int numberOfChannels = 0;
            numberOfChannels = DahuaEvent.isDeviceBasedEvent(eventName) ? 1 : (DahuaEvent.isAudioSourceEvent(eventName) ? numberOfAudioSources : numberOfVideoSources);
            for (int i = 0; i < numberOfChannels; ++i) {
                int sourceNumber = 0;
                String eventType = DahuaEvent.matchTriggerNameToConfigurationName(eventName).replace("[]", "");
                if (DahuaEvent.isAudioSourceEvent(eventName)) {
                    eventType = eventType + "[" + i + "]";
                } else if (!DahuaEvent.isDeviceBasedEvent(eventName)) {
                    eventType = eventType + "[" + i + "]";
                    sourceNumber = i + 1;
                }
                GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(eventType);
                genericEventDefinitionType.setSourceNumber(sourceNumber);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
        }
        return supportedGenericEventsType;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected GenericEventDefinitionType getBodyTemperatureEventTrigger() {
        GenericEventDefinitionType genericEventDefinitionType = null;
        try {
            String[] eventDataLines;
            String eventData = this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/devVideoAnalyse.cgi?action=getcaps&channel=1");
            for (String eventDataLine : eventDataLines = eventData.split("\r\n")) {
                String[] configLines = eventDataLine.split("=");
                if (configLines.length != 2 || !configLines[1].toLowerCase().contains("anatomytempdetect")) continue;
                genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(configLines[1]);
                genericEventDefinitionType.setSourceNumber(0);
            }
        }
        catch (Exception ex) {
            this.logger.info("Could not read body temperature event configuration. Probably not supported for " + this);
        }
        return genericEventDefinitionType;
    }

    @Override
    public List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp, int videoSourceNr) {
        this.logger.info("Looking for recording information on device " + this + " Start time: " + new Date(startTimestamp) + ", End time: " + new Date(endTimestamp));
        ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
        try {
            String resultStartSession = this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/mediaFileFind.cgi?action=factory.create");
            if (resultStartSession.contains("result=")) {
                String session = DahuaHelper.getParameterValue(resultStartSession, "result");
                String dateStart = this.getDahuaHelper().convertTimestampToSimpleDateTime(startTimestamp);
                String dateEnd = this.getDahuaHelper().convertTimestampToSimpleDateTime(endTimestamp);
                String url = "/cgi-bin/mediaFileFind.cgi?action=findFile&object=" + session + "&condition.Channel=" + videoSourceNr + "&condition.Types[0]=dav&condition.StartTime=" + dateStart + "&condition.EndTime=" + dateEnd;
                this.logger.info("URL for recording retrieval for " + this + " : " + url);
                String result = this.getDahuaHelper().getHttpHandler().readGetRequest(url);
                if (result.contains("OK")) {
                    do {
                        result = this.getDahuaHelper().getHttpHandler().readGetRequest("/cgi-bin/mediaFileFind.cgi?action=findNextFile&object=" + session + "&count=100");
                        timeRanges.addAll(this.getDahuaHelper().convertRecordingInformationToTimeRanges(result));
                    } while (result.contains("found=100"));
                } else {
                    this.logger.warn("Error while looking for recordings on " + this);
                }
                url = "/cgi-bin/mediaFileFind.cgi?action=close&object=" + session;
                this.getDahuaHelper().getHttpHandler().readGetRequest(url);
                url = "/cgi-bin/mediaFileFind.cgi?action=destroy&object=" + session;
                this.getDahuaHelper().getHttpHandler().readGetRequest(url);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error while getting recording infos from device for " + this, t);
        }
        return timeRanges;
    }
}

