/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.dahua.DahuaDevice;
import de.seetec.v5.re.cm.device.video.dahua.DahuaHelper;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Vector;

public class DahuaCameraControl
extends CameraControl {
    private Boolean autoFocusSet = null;
    private Boolean autoIrisSet = null;
    private int zoomLimitMin = -100;
    private int zoomLimitMax = 100;

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = DahuaHelper.adaptSpeed(panSpeed);
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = DahuaHelper.adaptSpeed(tiltSpeed);
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed / 1000;
        } else {
            zoom = this.previousZoomSpeed;
        }
        if (zoom < 0) {
            zoom = this.zoomLimitMin;
        } else if (zoom > 0) {
            zoom = this.zoomLimitMax;
        }
        String url = "Continuously&arg1=" + pan + "&arg2=" + tilt + "&arg3=" + zoom + "&arg4=50";
        boolean stopMovement = pan == 0 && tilt == 0 && zoom == 0;
        int errorCode = this.sendCameraCommand(url, stopMovement);
        if (errorCode != 0 && (this.zoomLimitMin == -100 || this.zoomLimitMax == 100)) {
            zoom = zoom == -100 ? -8 : zoom;
            zoom = zoom == 100 ? 8 : zoom;
            url = "Continuously&arg1=" + pan + "&arg2=" + tilt + "&arg3=" + zoom + "&arg4=50";
            errorCode = this.sendCameraCommand(url, stopMovement);
            if (errorCode == 0) {
                this.zoomLimitMin = -8;
                this.zoomLimitMax = 8;
            }
        }
        return errorCode;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            int xStart = (int)((double)xPosition.intValue() * 81.92);
            int yStart = (int)((double)yPosition.intValue() * 81.92);
            int xEnd = xStart;
            int yEnd = yStart;
            String url = "/cgi-bin/ptzBase.cgi?action=moveDirectly&channel=" + this.videoSrv.getVideoSourceCnf().getServerEntryNo() + "&startPoint[0]=" + xStart + "&startPoint[1]=" + yStart + "&endPoint[0]=" + xEnd + "&endPoint[1]=" + yEnd;
            ((DahuaDevice)this.videoSrv.getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration Exception while getting video source number for " + this + " : " + ex.getMessage());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while sending area zoom command for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        try {
            int xStart = (int)((double)xPosition.intValue() * 81.92);
            int yStart = (int)((double)yPosition.intValue() * 81.92);
            int xEnd = xStart + (int)((double)width.intValue() * 81.92);
            int yEnd = yStart + (int)((double)height.intValue() * 81.92);
            String url = "/cgi-bin/ptzBase.cgi?action=moveDirectly&channel=" + this.videoSrv.getVideoSourceCnf().getServerEntryNo() + "&startPoint[0]=" + xStart + "&startPoint[1]=" + yStart + "&endPoint[0]=" + xEnd + "&endPoint[1]=" + yEnd;
            ((DahuaDevice)this.videoSrv.getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration Exception while getting video source number for " + this + " : " + ex.getMessage());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while sending area zoom command for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (value == null) {
            return 0;
        }
        if (this.autoIrisSet == null || this.autoIrisSet.booleanValue() && value != 0) {
            this.setAutoIris(false);
        }
        String url = "IrisLarge&arg1=0&arg2=0&arg3=0&arg4=0";
        if (value != 0) {
            url = value < 0 ? "IrisSmall&arg1=1&arg2=0&arg3=0&arg4=0" : "IrisLarge&arg1=1&arg2=0&arg3=0&arg4=0";
            this.sendCameraCommand(url, false);
        } else {
            this.sendCameraCommand(url, true);
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        int channelNumber = 0;
        try {
            channelNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not determine channel number. Assuming it is 0 for " + this);
        }
        String url = "/cgi-bin/configManager.cgi?action=setConfig&VideoInExposure[" + channelNumber + "][0].Mode=" + (active != false ? "0" : "4") + "&VideoInExposure[" + channelNumber + "][1].Mode=" + (active != false ? "0" : "4") + "&VideoInExposure[" + channelNumber + "][2].Mode=" + (active != false ? "0" : "4");
        try {
            ((DahuaDevice)this.videoSrv.getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (ConfigurationException | SeeTecException ex) {
            this.logger.warn("Could not set AutoIris for " + this + " : " + ex.getMessage());
        }
        this.autoIrisSet = active;
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (value == null) {
            return 0;
        }
        if (this.autoFocusSet != null && this.autoFocusSet.booleanValue()) {
            this.setAutoFocus(false);
        }
        String url = "FocusNear&arg1=0&arg2=1&arg3=0&arg4=0";
        if (value != 0) {
            if (value < 0) {
                url = "FocusFar&arg1=0&arg2=1&arg3=0&arg4=0";
            }
            return this.sendCameraCommand(url, false);
        }
        return this.sendCameraCommand(url, true);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        String focusValue = active != false ? "2" : "4";
        String url = "/cgi-bin/configManager.cgi?action=setConfig&VideoInFocus[0][0].Mode=" + focusValue + "&VideoInFocus[0][1].Mode=" + focusValue + "&VideoInFocus[0][2].Mode=" + focusValue;
        try {
            ((DahuaDevice)this.videoSrv.getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not set AutoFocus for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not set AutoFocus for " + this + " : " + ex.getMessage());
            return -20001;
        }
        this.autoFocusSet = active;
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        try {
            String url = "/cgi-bin/configManager.cgi?action=setConfig&VideoInMode[0].Config[0].Mode=" + (active != false ? "1" : "0");
            ((DahuaDevice)this.videoSrv.getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not set Day/Night modus for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not set Day/Night modus for " + this + " : " + ex.getMessage());
            return -20001;
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        String url = "/cgi-bin/configManager.cgi?action=setConfig&VideoInMode[0].Config[0].Mode=2";
        try {
            ((DahuaDevice)this.videoSrv.getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not set Day/Night modus to Auto for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not set Day/Night modus to Auto for " + this + " : " + ex.getMessage());
            return -20001;
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        String encodedPresetName = presetName.trim();
        if (encodedPresetName.length() > 16) {
            encodedPresetName = encodedPresetName.substring(0, 16);
        }
        try {
            int i;
            byte[] vector = new byte[256];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i < vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + encodedPresetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            String url = "SetPreset&arg1=0&arg2=" + presetPosition + "&arg3=0&arg4=0";
            this.sendCameraCommand(url, false);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + encodedPresetName + "] failed :-(");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        String encodedPresetName = presetName.trim();
        if (encodedPresetName.length() > 16) {
            encodedPresetName = encodedPresetName.substring(0, 16);
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                String url = "GotoPreset&arg1=0&arg2=" + presetCnf.getPresetPosition() + "&arg3=0&arg4=0";
                return this.sendCameraCommand(url, false);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + encodedPresetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + encodedPresetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        String encodedPresetName = presetName.trim();
        if (encodedPresetName.length() > 16) {
            encodedPresetName = encodedPresetName.substring(0, 16);
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.presetList.removeElementAt(i);
                String url = "ClearPreset&arg1=0&arg2=" + presetCnf.getPresetPosition() + "&arg3=0&arg4=0";
                return this.sendCameraCommand(url, false);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + encodedPresetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + encodedPresetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    protected void readGetRequest(NetworkParameter networkParameter, String url, int wantedLength) throws SeeTecException, ConfigurationException {
        ((DahuaDevice)this.videoSrv.getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(url);
    }

    public int sendCameraCommand(String url, boolean stop) {
        try {
            String completeURL = "";
            this.videoSrv.notifyForCameraControl();
            completeURL = "/cgi-bin/ptz.cgi?action=" + (stop ? "stop" : "start") + "&channel=" + this.videoSrv.getVideoSourceCnf().getServerEntryNo() + "&code=" + url;
            ((DahuaDevice)this.videoSrv.getDevice()).getDahuaHelper().getHttpHandler().readGetRequest(completeURL);
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
        return 0;
    }
}

