/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.dahua;

import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DahuaAudioOutServer
extends AudioOutServer
implements Runnable {
    private final NetworkParameter networkParameter;
    private final Logger logger;
    private Socket postSocket;
    private boolean isShutdown = false;
    private Thread thread;

    public DahuaAudioOutServer(NetworkParameter networkParameter) {
        if (networkParameter == null) {
            throw new IllegalArgumentException("NetworkParameter is null for DahuaAudioOutServer");
        }
        this.networkParameter = networkParameter;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public int init() {
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
        this.logger.info(this + " initialized");
        return 0;
    }

    private void sendAudio(byte[] audioData) {
        try {
            this.establishStream();
            OutputStream os = this.postSocket.getOutputStream();
            os.write("--myboundary".getBytes());
            os.write(SSLConstantsIntf.CRLF_BYTE);
            os.write("Content-Type: Audio/G.711Mu".getBytes());
            os.write(SSLConstantsIntf.CRLF_BYTE);
            os.write(("Content-Length: " + audioData.length).getBytes());
            os.write(SSLConstantsIntf.DOUBLE_CRLF_BYTE);
            os.write(audioData);
            os.write(SSLConstantsIntf.CRLF_BYTE);
            os.flush();
        }
        catch (IOException iOException) {
            try {
                this.postSocket.close();
                this.postSocket = null;
                this.establishStream();
                OutputStream os = this.postSocket.getOutputStream();
                os.write(audioData);
                os.flush();
            }
            catch (IOException ioe) {
                this.logger.error("Sending audio data failed [" + iOException.getMessage() + "] for " + this);
            }
        }
    }

    private void establishStream() throws IOException {
        if (this.postSocket == null || this.postSocket.isClosed()) {
            this.postSocket = this.getPostSocket();
            if (this.postSocket != null) {
                this.establishPostStream();
            }
        }
    }

    private Socket getPostSocket() {
        try {
            this.postSocket = this.networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getSSLport(), (boolean)true, (int)this.networkParameter.getSoTimeout()) : NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getHTTPport(), (boolean)false, (int)this.networkParameter.getSoTimeout());
            this.postSocket.setSoTimeout(0);
            this.postSocket.setTcpNoDelay(true);
            this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"Opening socket for audio post request:", "   NetworkParameter: " + this.networkParameter}));
        }
        catch (SocketException socketException) {
            this.logger.error("Error creating socket for " + this + socketException.getMessage());
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while creating socket for " + this + exception.getMessage());
        }
        return this.postSocket;
    }

    private void establishPostStream() throws IOException {
        String authentication = this.createDahuaAudioOutAuthentication(this.networkParameter);
        try {
            OutputStream os = this.postSocket.getOutputStream();
            String postRequest = this.buildPostRequest(this.networkParameter.getHost(), authentication);
            os.write(postRequest.getBytes());
            os.flush();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private String createDahuaAudioOutAuthentication(NetworkParameter networkParameter) {
        String authentication = "";
        try {
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/", (int)Integer.MIN_VALUE);
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Error creating authentication for " + this + " : " + seeTecException.getMessage());
        }
        String realm = networkParameter.getRealm();
        String nonce = networkParameter.getNonce();
        String qop = networkParameter.getQop();
        if (realm != null && nonce != null) {
            try {
                String requestURL = "http://" + networkParameter.getHost() + "/";
                authentication = NetworkHelper.createDigestAuthorization((NetworkParameter)networkParameter, (String)realm, (String)nonce, (String)"POST", (String)requestURL, (String)qop);
            }
            catch (Exception exception) {
                this.logger.error("Error creating authentication for " + this + " : " + exception.getMessage());
            }
        } else {
            authentication = NetworkHelper.createBasicAuthorization((String[])networkParameter.getUserPWD());
        }
        return authentication;
    }

    private String buildPostRequest(String host, String authentication) {
        String postRequest = "POST /cgi-bin/audio.cgi?action=postAudio&httptype=multipart&channel=1 HTTP/1.1\r\nHost: " + host + "\r\n" + authentication + "Content-Type: multipart/x-mixed-replace; boundary=myboundary" + "\r\n" + "\r\n";
        return postRequest;
    }

    @Override
    public void run() {
        while (!this.isShutdown) {
            try {
                MediaFrame mediaFrameToSend = this.take();
                for (byte[] singlePayLoad : mediaFrameToSend.getPayload()) {
                    this.sendAudio(singlePayLoad);
                }
            }
            catch (InterruptedException exception) {
                this.logger.info("Sending thread interrupted for " + this);
            }
        }
        this.logger.info("Shutting down " + this);
    }

    public String toString() {
        String toString = "Audio out server [Host=[" + this.networkParameter.getHost() + "], " + (!this.networkParameter.useHTTPS() ? "HTTP port=[" + this.networkParameter.getHTTPport() : "HTTPS port=[" + this.networkParameter.getSSLport()) + "]]";
        return toString;
    }

    @Override
    public int shutdown() {
        this.isShutdown = true;
        this.thread.interrupt();
        if (this.postSocket != null) {
            try {
                this.postSocket.close();
            }
            catch (IOException ioe) {
                this.logger.warn("Error closing socket for " + this + " : " + ioe.getMessage());
            }
        }
        this.postSocket = null;
        return super.shutdown();
    }
}

