/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.convision.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;

public class ConvisionJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.convision.jpeg.ConvisionJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        try {
            StringBuilder sb = new StringBuilder(256);
            String sSeeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            if (this.resolutionTag == null || this.resolutionTag.trim().length() <= 0) {
                if (this.width == 176) {
                    sb.append("/halfsize.push");
                } else if (this.width == 352) {
                    sb.append("/fullsize.push");
                } else {
                    sb.append("/hugesize.push");
                }
            } else if (this.resolutionTag.indexOf("halfsize") >= 0) {
                sb.append("/halfsize.push");
            } else if (this.resolutionTag.indexOf("fullsize") >= 0) {
                sb.append("/fullsize.push");
            } else {
                sb.append("/hugesize.push");
            }
            sb.append("?sid=");
            sb.append(sSeeTecID);
            sb.append("&camera=");
            sb.append(this.videoSourceNr);
            this.logger.info("Using [" + sb.toString() + "] for " + this);
            try {
                boolean bAsynchronous = false;
                if (this.getVideoSrv().getDevice().getDeviceType() == 201103L) {
                    this.networkParameter.setHttpDoubleLineDelimitter("\n\n".getBytes());
                    this.networkParameter.setHttpSingleLineDelimitter("\n".getBytes());
                }
                this.httpServerPushHandler = new HttpServerPushHandler();
                this.networkParameter.setSoTimeout(5000);
                errorCode = this.httpServerPushHandler.init(this, this.networkParameter, sb.toString());
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                } else {
                    errorCode = this.httpServerPushHandler.startServerPush(bAsynchronous);
                }
                if (this.httpServerPushHandler != null) {
                    this.httpServerPushHandler.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                errorCode = -21601;
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }
}

