/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.convision;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URLEncoder;
import java.util.Vector;

public class ConvisionCameraControl
extends CameraControl {
    int errorCode = 0;

    private int sendCameraCommand(String url) {
        return this.sendCameraCommand(url, false);
    }

    private int sendCameraCommand(String url, boolean stopSet) {
        try {
            int ptzChannel = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            String completeURL = "/httpapi/SendPTZ?action=sendptz&PTZ_CHANNEL=" + ptzChannel + "&" + url + "&PTZ_TIMEOUT=5000";
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Sending URL=[ " + completeURL + " ] for " + this + " ...");
            }
            this.videoSrv.notifyForCameraControl();
            if (stopSet) {
                for (int i = 0; i < 2; ++i) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL, (int)Integer.MAX_VALUE, (boolean)true);
                }
            } else {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL, (int)Integer.MAX_VALUE, (boolean)true);
            }
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while sending PTZ command for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        StringBuilder sb = new StringBuilder(256);
        int pan = 0;
        int tilt = 0;
        int zoom = 0;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        boolean stopSet = false;
        try {
            sb.append("PTZ_MOVE=");
            if (panSpeed != null || tiltSpeed != null) {
                if (pan > 0) {
                    if (tilt > 0) {
                        sb.append("rightup");
                    } else if (tilt < 0) {
                        sb.append("rightdown");
                    } else {
                        sb.append("right");
                    }
                } else if (pan < 0) {
                    if (tilt > 0) {
                        sb.append("leftup");
                    } else if (tilt < 0) {
                        sb.append("leftdown");
                    } else {
                        sb.append("left");
                    }
                } else if (tilt > 0) {
                    sb.append("up");
                } else if (tilt < 0) {
                    sb.append("down");
                } else {
                    sb.append("stop");
                    stopSet = true;
                }
                if (!stopSet) {
                    sb.append(",").append(Math.abs(pan / 10000)).append(",").append(Math.abs(tilt / 10000));
                }
            }
            if (zoomSpeed != null) {
                if (zoom > 0) {
                    sb.append("zoomin,").append(Math.abs(zoom / 10000));
                } else if (zoom < 0) {
                    sb.append("zoomout,").append(Math.abs(zoom / 10000));
                } else {
                    sb.append("stop");
                }
            }
            if (panSpeed != null || tiltSpeed != null || zoomSpeed != null) {
                return this.sendCameraCommand(sb.toString(), stopSet);
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer heigth, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return this.sendCameraCommand("iris=" + value / 1000);
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (value != null && value != 0) {
            this.sendCameraCommand("PTZ_IRISAUTO=0");
            if (value > 0) {
                this.sendCameraCommand("PTZ_MOVE=irisopen");
            } else {
                this.sendCameraCommand("PTZ_MOVE=irisclose");
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("PTZ_IRISAUTO=1");
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return this.sendCameraCommand("focus=" + value / 1000);
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (value != null && value != 0) {
            if (value > 0) {
                this.sendCameraCommand("PTZ_MOVE=focusnear,10");
            } else {
                this.sendCameraCommand("PTZ_MOVE=focusfar,10");
            }
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("PTZ_FOCUSAUTO=1");
        }
        return this.sendCameraCommand("PTZ_FOCUSAUTO=0");
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("ircutfilter=off");
        }
        return this.sendCameraCommand("ircutfilter=on");
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("ircutfilter=auto");
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        String camera = "";
        try {
            camera = "&camera=" + this.videoSrv.getVideoSourceCnf().getServerEntryNo();
        }
        catch (ConfigurationException cex) {
            this.logger.warn((Object)cex, (Throwable)cex);
        }
        this.errorCode = this.sendCameraCommand(camera + "&move=home");
        return this.errorCode;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            byte[] vector = new byte[128];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i < vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [ " + presetName + " ], 'cause no more free preset positions are available for " + this + " :-( ");
                return -21600;
            }
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.sendCameraCommand("PTZ_PRESETSET=" + presetPosition);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [ " + presetName + " ] failed :-( ");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.sendCameraCommand("PTZ_PRESETGOTO=" + presetCnf.getPresetPosition());
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [ " + presetName + " ] failed :-( ");
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available :-( ");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                String presetNumber = presetCnf.getPresetPosition();
                this.presetList.removeElementAt(i);
                this.errorCode = this.sendCameraCommand("PTZ_PRESETCLR=" + presetNumber);
                if (this.errorCode != 0) {
                    this.logger.warn("Removing preset [ " + presetCnf.getPresetName() + " ] from " + this + " failed with error [ " + this.errorCode + " ] :-( ");
                }
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [ " + presetName + " ] failed :-( ");
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available :-( ");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

