/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.cbc.mpeg;

import de.seetec.v5.re.cm.device.video.cbc.mpeg.HttpStreamListenerIntf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpStreamHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.cbc.mpeg.HttpStreamHandler";
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Thread thread = null;
    private HttpStreamListenerIntf listener = null;
    private NetworkParameter networkParameter = null;
    private Socket socket = null;
    private String sURL = null;

    public int init(HttpStreamListenerIntf listener, NetworkParameter networkParameter, String sURL) {
        this.listener = listener;
        if (this.listener == null) {
            return -20002;
        }
        this.networkParameter = networkParameter;
        if (this.networkParameter == null) {
            return -20002;
        }
        this.sURL = sURL;
        if (this.sURL == null) {
            return -20002;
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.socket = null;
        }
        return 0;
    }

    public int startServerPush(boolean bAsynchronous) {
        if (this.listener == null) {
            return -20002;
        }
        if (this.networkParameter == null) {
            return -20002;
        }
        if (this.sURL == null) {
            return -20002;
        }
        this.logger.info("Starting HttpServerPush with following Parameter:");
        this.logger.info("   Listener        : " + this.listener);
        this.logger.info("   NetworkParameter: " + this.networkParameter);
        this.logger.info("   URL             : [" + this.sURL + "]");
        try {
            this.socket = NetworkHelper.establishServerPushStream((NetworkParameter)this.networkParameter, (String[])this.networkParameter.getUserPWD(), (String)this.sURL);
            this.listener.sendStatusService(0);
        }
        catch (Throwable ex) {
            int errorCode = -20100;
            this.logger.error((Object)ex, ex);
            this.listener.sendStatusService(errorCode);
            return errorCode;
        }
        if (bAsynchronous) {
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
            return 0;
        }
        return this.readHttpServerPush();
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            int errorCode = this.readHttpServerPush();
            if (errorCode != 0) {
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int readHttpServerPush() {
        int errorCode = 0;
        int len = -1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        try {
            InputStream is = this.socket.getInputStream();
            while (!this.isShutdown() && !this.listener.isShutdown()) {
                try {
                    try {
                        baos.reset();
                        len = is.read(buffer);
                        if (len > 0) {
                            baos.write(buffer, 0, len);
                            this.listener.deliverRawContent(baos.toByteArray());
                            continue;
                        }
                        break;
                    }
                    catch (InterruptedIOException soTimeoutException) {
                        if (this.networkParameter.getIgnoreSoTimeout()) continue;
                        throw soTimeoutException;
                    }
                }
                catch (NullPointerException npe) {
                    this.shutdown();
                    return 0;
                }
            }
        }
        catch (IOException ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            this.logger.warn("Network problems for " + this);
            this.listener.notifyForNetworkProblems();
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            this.logger.warn("Unexpected exception occured for " + this);
            this.listener.notifyForNetworkProblems();
        }
        try {
            if (this.socket == null) return errorCode;
            this.socket.close();
            this.socket = null;
            return errorCode;
        }
        catch (IOException ioex) {
            this.logger.warn((Object)ioex, (Throwable)ioex);
        }
        return errorCode;
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Listener=" + this.listener + ", " + this.networkParameter + ", " + this.socket + ", URL=[" + this.sURL + "]]";
    }
}

