/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.cbc.mpeg;

import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.cm.device.video.cbc.CBCHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.cbc.CBCIOHandler;
import de.seetec.v5.re.cm.device.video.cbc.CBCMotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.cbc.mpeg.HttpStreamHandler;
import de.seetec.v5.re.cm.device.video.cbc.mpeg.HttpStreamListenerIntf;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;

public class CBCMPEGVideoSourceClient
extends StreamingVideoSourceClient
implements HttpStreamListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.cbc.mpeg.CBCMPEGVideoSourceClient";
    private final byte[] MAGIC = new byte[]{51, 50, 57, 55, 20};
    private HttpStreamHandler httpStreamHandler = null;
    private byte[] previousPacket = null;

    @Override
    public int init() {
        Object[] values;
        this.logger.info("init started for" + this.getVideoSrv());
        this.completeFrame = new ByteArrayOutputStream();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.iFrameDist = this.iFrameDistMS <= 750 ? 0L : (this.iFrameDistMS <= 1500 ? 1L : 2L);
        this.fps = (this.fps + 999L) / 1000L;
        int[] allowedValues = new int[]{5, 10, 15, 20, 25, 30};
        this.fps = Tools.convertToCameraValues(allowedValues, (int)this.fps);
        String resolutionString = null;
        if (this.width == 1280) {
            resolutionString = this.height == 960 ? this.width + "x" + this.height : "sxga";
        } else if (this.width == 720) {
            resolutionString = "d1";
        } else if (this.width == 704 || this.width == 640) {
            resolutionString = "vga";
        } else if (this.width == 352) {
            resolutionString = "cif";
        } else if (this.width == 320) {
            resolutionString = "qvga";
        } else if (this.width == 176) {
            resolutionString = "qcif";
        } else if (this.width == 160) {
            resolutionString = "qqvga";
        }
        StringBuilder sb = new StringBuilder(256);
        if (this.videoCodec == Codec.MPEG4) {
            sb.append("/SetMultimedia.cgi?Mode=mpeg4");
            sb.append("&GOPSelect=");
            sb.append(this.iFrameDist);
            sb.append("&Compression_Type=");
            if (this.isConstantBitrateUsed) {
                int[] allowedBitrateValues = new int[]{64, 96, 128, 192, 256, 320, 384, 448, 512, 576, 640, 704, 768, 1000, 1500, 2000, 2500, 3000, 3500, 4000};
                this.bandwidth = Tools.convertToCameraValues(allowedBitrateValues, this.bandwidth / 1000);
                sb.append("0");
                sb.append("&Bitrate=");
                sb.append(this.bandwidth);
            } else {
                this.quality /= 10000;
                this.quality = this.quality < 1 ? 1 : this.quality;
                values = new int[]{4, 5, 7, 10, 14, 17, 19, 21, 24, 28};
                int apiValue = 4;
                for (int j = 1; j <= 10; ++j) {
                    if (j != this.quality) continue;
                    apiValue = values[10 - j];
                    break;
                }
                sb.append("1");
                sb.append("&VBR=");
                sb.append(apiValue);
            }
        } else {
            this.quality /= 20000;
            this.quality = this.quality < 1 ? 1 : this.quality;
            sb.append("/SetMultimedia.cgi?Mode=mjpeg");
            sb.append("&Jpeg_Quality=");
            sb.append(this.quality);
        }
        sb.append("&Resolution=");
        sb.append(resolutionString);
        sb.append("&Fps=");
        sb.append(this.fps);
        if (!this.isAudioEnabled) {
            sb.append("&Audio=0");
        }
        if (this.rotationAngle == 180) {
            sb.append("&Flip=1");
        } else {
            sb.append("&Flip=0");
        }
        try {
            values = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException ex) {
            this.logger.error("Error setting camera parameters for " + this.getVideoSrv().getDevice());
            this.logger.error("URL used: " + sb.toString());
            this.logger.error("Exception occured setting camera parameters: " + ex.getMessage());
            return ex.getErrorCode();
        }
        try {
            String sURL = "/GetStream.cgi?Video=0&Audio=0";
            boolean bAsynchronous = true;
            this.httpStreamHandler = new HttpStreamHandler();
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = this.httpStreamHandler.init(this, this.networkParameter, sURL);
            if (this.errorCode != 0) {
                this.logger.error("Error [" + this.errorCode + "] with " + this.httpStreamHandler + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.errorCode = this.httpStreamHandler.startServerPush(bAsynchronous);
            if (this.errorCode != 0) {
                this.logger.warn("ServerPush of " + this.httpStreamHandler + " terminated with error [" + this.errorCode + "] for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (Exception e) {
            this.errorCode = this.errorCode != 0 ? this.errorCode : -21670;
            this.logger.error("HTTPHandler.init failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized void deliverRawContent(byte[] rawHTTPContent) {
        block22: {
            try {
                if (rawHTTPContent == null) break block22;
                if (rawHTTPContent.length >= 4 && rawHTTPContent[0] == 72 && rawHTTPContent[1] == 84 && rawHTTPContent[2] == 84 && rawHTTPContent[3] == 80) {
                    return;
                }
                byte[] receivedBytes = null;
                if (this.previousPacket != null) {
                    receivedBytes = new byte[this.previousPacket.length + rawHTTPContent.length];
                    System.arraycopy(this.previousPacket, 0, receivedBytes, 0, this.previousPacket.length);
                    System.arraycopy(rawHTTPContent, 0, receivedBytes, this.previousPacket.length, rawHTTPContent.length);
                    this.previousPacket = null;
                } else {
                    receivedBytes = new byte[rawHTTPContent.length];
                    System.arraycopy(rawHTTPContent, 0, receivedBytes, 0, rawHTTPContent.length);
                }
                int indexMagic = 0;
                int bytesProcessed = 0;
                while (bytesProcessed < receivedBytes.length) {
                    indexMagic = Basic.indexOfByteArray((byte[])receivedBytes, (byte[])this.MAGIC, (int)bytesProcessed, (boolean)true);
                    if (indexMagic == -1) {
                        this.previousPacket = new byte[receivedBytes.length - (bytesProcessed - this.MAGIC.length)];
                        System.arraycopy(receivedBytes, bytesProcessed - this.MAGIC.length, this.previousPacket, 0, receivedBytes.length - (bytesProcessed - this.MAGIC.length));
                        break;
                    }
                    if (indexMagic == 0) {
                        bytesProcessed = indexMagic + this.MAGIC.length;
                        continue;
                    }
                    int lengthOfEmbeddedData = indexMagic - (bytesProcessed - this.MAGIC.length);
                    byte[] newPacket = new byte[lengthOfEmbeddedData];
                    System.arraycopy(receivedBytes, bytesProcessed - this.MAGIC.length, newPacket, 0, lengthOfEmbeddedData);
                    byte proprietaryPayloadSpecifier = newPacket[5];
                    if (proprietaryPayloadSpecifier == 1 || proprietaryPayloadSpecifier == 2 || proprietaryPayloadSpecifier == 3) {
                        byte[] mpegByteArray = new byte[newPacket.length - 20];
                        System.arraycopy(newPacket, 20, mpegByteArray, 0, newPacket.length - 20);
                        int mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(mpegByteArray);
                        if (mediaType > 0) {
                            int[] currentResolution;
                            if (mediaType == 33 && (currentResolution = StreamingHelperMpeg4.extractMPEG4Part2Resolution(mpegByteArray)) != null) {
                                this.width = currentResolution[0];
                                this.height = currentResolution[1];
                            }
                            MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, this.width, this.height, mpegByteArray);
                            this.deliverFrameCreateServerTimestamp(mediaType, mediaFrame);
                        }
                    } else if (proprietaryPayloadSpecifier == 4) {
                        int indexFFD9;
                        int indexFFD8 = Basic.indexOfByteArray((byte[])newPacket, (byte[])new byte[]{-1, -40}, (int)0, (boolean)true);
                        if (indexFFD8 != -1 && (indexFFD9 = Basic.indexOfByteArray((byte[])newPacket, (byte[])new byte[]{-1, -39}, (int)indexFFD8)) != -1) {
                            byte[] jpegByteArray = new byte[indexFFD9 - indexFFD8];
                            System.arraycopy(newPacket, indexFFD8, jpegByteArray, 0, indexFFD9 - indexFFD8);
                            try {
                                MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MJPEG, jpegByteArray, false);
                                this.deliverFrameCreateServerTimestamp(0, mediaFrame);
                            }
                            catch (SeeTecException ex) {
                                this.logger.error("Exception while creating video frame for " + this + " : " + ex.getMessage());
                            }
                        }
                    } else if (proprietaryPayloadSpecifier == 6) {
                        if (this.getVideoSrv().getHardwareMotionDetection() != null) {
                            byte[] motionDetection = new byte[]{newPacket[20]};
                            ((CBCMotionDetectionHandler)((Object)((CBCHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processContent(motionDetection);
                        }
                    } else if (proprietaryPayloadSpecifier == 7 && this.getVideoSrv().getDevice().getIOHandler() != null) {
                        byte[] io = new byte[]{newPacket[20], newPacket[23]};
                        ((CBCIOHandler)this.getVideoSrv().getDevice().getIOHandler()).processContent(io);
                    }
                    bytesProcessed = indexMagic + this.MAGIC.length;
                }
            }
            catch (Exception e) {
                this.logger.error("Content length: " + rawHTTPContent.length + " for " + this.getVideoSrv(), (Throwable)e);
                if (rawHTTPContent.length < 100) {
                    this.logger.error("Content: " + Basic.byteArrayToHexString((byte[])rawHTTPContent, (int)0, (int)rawHTTPContent.length));
                }
                this.logger.error("Content: " + Basic.byteArrayToHexString((byte[])rawHTTPContent, (int)0, (int)100));
            }
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }
}

