/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.canon2;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.canon2.Canon2Device;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.AudioEncoderConfiguration;
import org.onvif.ver10.schema.AudioEncoderConfigurationOption;
import org.onvif.ver10.schema.AudioEncoding;
import org.onvif.ver10.schema.AudioSource;
import org.onvif.ver10.schema.AudioSourceConfiguration;
import org.onvif.ver10.schema.H264Configuration;
import org.onvif.ver10.schema.H264Profile;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.TransportProtocol;
import org.onvif.ver10.schema.VideoEncoderConfiguration;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoEncoding;
import org.onvif.ver10.schema.VideoRateControl;
import org.onvif.ver10.schema.VideoResolution;
import org.onvif.ver10.schema.VideoSource;
import org.onvif.ver10.schema.VideoSourceConfiguration;
import org.xml.sax.SAXException;

public final class Canon2VideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.canon2.Canon2VideoSourceClient";

    @Override
    public int init() {
        String rtspHost = "";
        int rtspPort = 554;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            String camera_capture = this.getCameraCapture();
            String sessionId = this.getSessionId();
            this.openSession(sessionId);
            String cayuga_capture = this.getVideoSrv().getDevice().getDeviceCnf().getCaptureMode().getDisplayResolution().toLowerCase();
            if (!cayuga_capture.equals("") && !camera_capture.contains(cayuga_capture)) {
                int capture = this.getCaptureNumber(cayuga_capture);
                String urlRequest = null;
                switch (capture) {
                    case 0: {
                        urlRequest = "/admin/-set-?pt=4&em=2&dr01=3&dr03=1&dh03-0=3&dh03-1=1&dp00=0";
                        break;
                    }
                    case 1: {
                        urlRequest = "/admin/-set-?pt=4&em=2&dr01=9&dr03=7&dh03-0=9&dh03-1=7&dp00=1";
                        break;
                    }
                    default: {
                        urlRequest = "/admin/-set-?pt=4&em=2&dr01=6&dr03=4&dh03-0=6&dh03-1=4&dp00=2";
                    }
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlRequest.trim(), (int)Integer.MAX_VALUE);
            }
            this.closeSession(sessionId);
        }
        catch (Throwable ex) {
            this.logger.error("Unexpected exception while initialization for " + this, ex);
            return -20000;
        }
        try {
            int videoSourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo() - 1;
            int videoStreamNumber = this.listener.getDynamicVideoProfileID();
            boolean audioSourceNumber = false;
            boolean audioStreamNumber = false;
            Canon2Device canon2Device = (Canon2Device)this.getVideoSrv().getDevice();
            OnvifCore onvifCore = canon2Device.getOnvifCore();
            Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
            Profile profile = onvifCore.getMediaService().getSeeTecProfile(videoSourceNumber, videoStreamNumber);
            VideoSourceConfiguration videoSourceConfiguration = (VideoSourceConfiguration)mediaService.getVideoSourceConfigurations().get(videoSourceNumber);
            videoSourceConfiguration.setSourceToken(((VideoSource)mediaService.getVideoSources().get(videoSourceNumber)).getToken());
            mediaService.setVideoSourceConfiguration(videoSourceConfiguration, true);
            if (profile.getVideoSourceConfiguration() == null || profile.getVideoSourceConfiguration() != null && !profile.getVideoSourceConfiguration().getToken().equals(videoSourceConfiguration.getToken())) {
                mediaService.addVideoSourceConfiguration(profile.getToken(), videoSourceConfiguration.getToken());
            }
            String selectedStreamName = this.videoCodec == Codec.MJPEG ? "" + (videoSourceNumber + 1) : "264-" + (videoSourceNumber + 1);
            VideoEncoderConfiguration videoEncoderConfiguration = null;
            videoEncoderConfiguration = mediaService.getVideoEncoderConfiguration(selectedStreamName);
            VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = mediaService.getVideoEncoderConfigurationOptions(selectedStreamName, null);
            IntRange qualityRange = videoEncoderConfigurationOptions.getQualityRange();
            IntRange govLengthRange = null;
            MpegProfile mpegProfile = this.listener.getVideoSourceParameter().getMpegProfile();
            VideoEncoding videoEncoding = null;
            if (this.videoCodec == Codec.MJPEG) {
                videoEncoding = VideoEncoding.JPEG;
                videoEncoderConfiguration.setMPEG4(null);
                videoEncoderConfiguration.setH264(null);
                if (this.width == 960) {
                    this.height = 544;
                } else if (this.width == 480) {
                    this.height = 272;
                } else if (this.width == 320 && this.height == 180) {
                    this.height = 184;
                }
            } else if (this.videoCodec == Codec.H264) {
                videoEncoding = VideoEncoding.H_264;
                H264Configuration h264Configuration = new H264Configuration();
                govLengthRange = videoEncoderConfigurationOptions.getH264().getGovLengthRange();
                h264Configuration.setGovLength(Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, govLengthRange.getMin(), govLengthRange.getMax()));
                if (mpegProfile == MpegProfile.BASELINE) {
                    h264Configuration.setH264Profile(H264Profile.BASELINE);
                } else if (mpegProfile == MpegProfile.EXTENDED) {
                    h264Configuration.setH264Profile(H264Profile.EXTENDED);
                } else if (mpegProfile == MpegProfile.HIGH) {
                    h264Configuration.setH264Profile(H264Profile.HIGH);
                } else if (mpegProfile == MpegProfile.MAIN) {
                    h264Configuration.setH264Profile(H264Profile.MAIN);
                } else {
                    h264Configuration.setH264Profile(null);
                }
                videoEncoderConfiguration.setH264(h264Configuration);
                videoEncoderConfiguration.setMPEG4(null);
            }
            videoEncoderConfiguration.setEncoding(videoEncoding);
            this.quality /= 1000;
            int calculatedQuality = this.quality * (qualityRange.getMax() - qualityRange.getMin()) / 100 + qualityRange.getMin();
            videoEncoderConfiguration.setQuality((float)calculatedQuality);
            VideoResolution videoResolution = new VideoResolution();
            videoResolution.setWidth(this.width);
            videoResolution.setHeight(this.height);
            videoEncoderConfiguration.setResolution(videoResolution);
            VideoRateControl videoRateControl = new VideoRateControl();
            videoRateControl.setBitrateLimit(this.bandwidth / 1024);
            videoRateControl.setEncodingInterval(this.listener.getVideoSourceParameter().getEncodingInterval() / 1000);
            videoRateControl.setFrameRateLimit((int)(this.fps / 1000L));
            videoEncoderConfiguration.setRateControl(videoRateControl);
            mediaService.setVideoEncoderConfiguration(videoEncoderConfiguration, true);
            if (profile.getVideoEncoderConfiguration() == null || profile.getVideoEncoderConfiguration() != null && !profile.getVideoEncoderConfiguration().getToken().equals(videoEncoderConfiguration.getToken())) {
                mediaService.addVideoEncoderConfiguration(profile.getToken(), videoEncoderConfiguration.getToken());
            }
            if (this.isAudioEnabled && this.audioCodec != Codec.UNKNOWN) {
                AudioSourceConfiguration audioSourceConfiguration = (AudioSourceConfiguration)mediaService.getAudioSourceConfigurations().get(0);
                audioSourceConfiguration.setSourceToken(((AudioSource)mediaService.getAudioSources().get(0)).getToken());
                mediaService.setAudioSourceConfiguration(audioSourceConfiguration, true);
                if (profile.getAudioSourceConfiguration() == null || profile.getAudioSourceConfiguration() != null && !profile.getAudioSourceConfiguration().getToken().equals(audioSourceConfiguration.getToken())) {
                    mediaService.addAudioSourceConfiguration(profile.getToken(), audioSourceConfiguration.getToken());
                }
                AudioEncoderConfiguration audioEncoderConfiguration = (AudioEncoderConfiguration)mediaService.getAudioEncoderConfigurations().get(0);
                AudioEncoding audioEncoding = null;
                if (this.audioCodec == Codec.G711U || this.audioCodec == Codec.G711A) {
                    audioEncoding = AudioEncoding.G_711;
                } else if (this.audioCodec == Codec.G726) {
                    audioEncoding = AudioEncoding.G_726;
                } else if (this.audioCodec == Codec.AAC) {
                    audioEncoding = AudioEncoding.AAC;
                }
                audioEncoderConfiguration.setEncoding(audioEncoding);
                int bitrate = 0;
                List audioEncoderConfigurationOptions = mediaService.getAudioEncoderConfigurationOptions(audioEncoderConfiguration.getToken(), profile.getToken()).getOptions();
                for (AudioEncoderConfigurationOption audioEncoderConfigurationOption : audioEncoderConfigurationOptions) {
                    if (bitrate != 0 || audioEncoderConfigurationOption.getEncoding() != audioEncoderConfiguration.getEncoding()) continue;
                    bitrate = OnvifHelper.getBiggestIntValueAndConvert(audioEncoderConfigurationOption.getBitrateList(), false);
                    break;
                }
                audioEncoderConfiguration.setBitrate(bitrate);
                int samplerate = 0;
                for (AudioEncoderConfigurationOption audioEncoderConfigurationOption : audioEncoderConfigurationOptions) {
                    if (samplerate != 0 || audioEncoderConfigurationOption.getEncoding() != audioEncoderConfiguration.getEncoding()) continue;
                    samplerate = OnvifHelper.getBiggestIntValueAndConvert(audioEncoderConfigurationOption.getSampleRateList(), false);
                    break;
                }
                audioEncoderConfiguration.setSampleRate(samplerate);
                mediaService.setAudioEncoderConfiguration(audioEncoderConfiguration, true);
                if (profile.getAudioEncoderConfiguration() == null || profile.getAudioEncoderConfiguration() != null && !profile.getAudioEncoderConfiguration().getToken().equals(audioEncoderConfiguration.getToken())) {
                    mediaService.addAudioEncoderConfiguration(profile.getToken(), audioEncoderConfiguration.getToken());
                }
            } else {
                if (profile.getAudioEncoderConfiguration() != null) {
                    mediaService.removeAudioEncoderConfiguration(profile.getToken());
                }
                if (profile.getAudioSourceConfiguration() != null) {
                    mediaService.removeAudioSourceConfiguration(profile.getToken());
                }
            }
            TransportProtocol transportProtocol = null;
            if (this.transmissionID == TransmissionType.RTP_OVER_UDP_UNICAST) {
                transportProtocol = TransportProtocol.UDP;
            } else if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_TCP) {
                transportProtocol = TransportProtocol.TCP;
            }
            this.rtspUrl = onvifCore.getMediaService().getStreamUri(profile.getToken(), StreamType.RTP_UNICAST, transportProtocol);
            this.logger.info("Use following ONVIF Profile: " + profile.getToken() + "and following RTSP URL: " + this.rtspUrl + " for " + this);
            try {
                String regex = "rtsp://([a-zA-Z0-9.-]+)[:]?([\\p{Digit}]*)/";
                String result1 = "";
                String result2 = "";
                Matcher matcher = Pattern.compile("rtsp://([a-zA-Z0-9.-]+)[:]?([\\p{Digit}]*)/").matcher(this.rtspUrl);
                if (matcher.find()) {
                    result1 = matcher.group(1);
                    result2 = matcher.group(2);
                }
                rtspHost = result1 != null && !result1.equals("") ? result1 : this.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter().getHost();
                rtspPort = result2 != null && !result2.equals("") ? Integer.parseInt(result2) : this.listener.getVideoSourceParameter().getRtspPort();
                this.logger.info("Use following RTSP host: " + rtspHost + " for " + this);
                this.logger.info("Use following RTSP port: " + rtspPort + " for " + this);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warn("RTSP port could not be read from given URL, so we use the default port (" + rtspPort + ")");
            }
        }
        catch (Throwable throwable) {
            this.logger.error("There are problems while setting parameters via ONVIF on the device", throwable);
            return -21662;
        }
        try {
            this.networkParameter.setSoTimeout(5000);
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, rtspPort, this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 3, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting RTSP parameters for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.setHost(rtspHost);
            this.rtspSettings.setUdpBuffer(65535);
            this.rtspSettings.setUserAgent("Java");
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP stream for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException exception) {
            this.logger.error("Error while first RTSP request. errorCode: " + exception.getErrorCode() + " for " + this.getVideoSrv(), (Throwable)exception);
            return exception.getErrorCode();
        }
        catch (Exception exception) {
            this.logger.error("Error while first RTSP request. errorCode: " + this.errorCode + " for " + this.getVideoSrv(), (Throwable)exception);
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    private void openSession(String sessionID) throws SeeTecException {
        String urlRequest = "/-wvhttp-01-/claim.cgi?s=" + sessionID.trim();
        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlRequest, (int)Integer.MAX_VALUE);
    }

    private void closeSession(String sessionID) throws SeeTecException {
        String urlRequest = "/-wvhttp-01-/yield.cgi?s=" + sessionID.trim();
        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlRequest, (int)Integer.MAX_VALUE);
    }

    private String getSessionId() throws SAXException, JAXBException, SeeTecException {
        String sessionId = "";
        String urlRequest = "/-wvhttp-01-/open.cgi?s.priority=5";
        byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlRequest, (int)Integer.MAX_VALUE);
        String responseFromCamera = new String(result);
        sessionId = responseFromCamera.substring(responseFromCamera.indexOf("s:=") + 3, responseFromCamera.indexOf("s.origin:=")).trim();
        return sessionId;
    }

    private String getCameraCapture() throws SeeTecException {
        String requestInfo = "/-wvhttp-01-/info.cgi?item=v.list";
        byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)requestInfo, (int)Integer.MAX_VALUE);
        String responseFromCamera = null;
        if (result != null) {
            responseFromCamera = new String(result);
        }
        HashMap<String, String> cameraInfo = new HashMap<String, String>();
        Tools.parseParameters(cameraInfo, responseFromCamera);
        String capture = (String)cameraInfo.get("v.list:");
        return capture;
    }

    private int getCaptureNumber(String cayuga_capture) {
        if (cayuga_capture.contains("1920x1080")) {
            return 2;
        }
        if (cayuga_capture.contains("1280x960")) {
            return 0;
        }
        return 1;
    }
}

