/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.canon2;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.video.canon2.Canon2EventHandler;
import de.seetec.v5.re.cm.device.video.canon2.Canon2IoHandler;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public final class Canon2Device
extends VideoServer {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.canon2.Canon2Device";
    private OnvifCore canon2Core = null;
    private Canon2EventHandler canon2EventHandler = null;
    private final Object SEMAPHORE = new Object();

    @Override
    protected IOHandler createIOHandler() {
        return new Canon2IoHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnvifCore getOnvifCore() throws SeeTecException {
        if (this.canon2Core != null) {
            return this.canon2Core;
        }
        Object object = this.SEMAPHORE;
        synchronized (object) {
            try {
                if (this.canon2Core == null) {
                    NetworkParameter networkParameter = this.getDeviceCnf().getNetworkParameter();
                    if (networkParameter != null) {
                        this.canon2Core = new OnvifCore();
                        String user = null;
                        if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[0] != null) {
                            user = networkParameter.getUserPWD()[0];
                        }
                        String password = null;
                        if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[1] != null) {
                            password = networkParameter.getUserPWD()[1];
                        }
                        boolean useAuthorization = false;
                        if (user != null && password != null) {
                            useAuthorization = true;
                        }
                        String passwordType = "PasswordDigest";
                        OnvifDevice onvifDevice = new OnvifDevice(this.getDeviceEntity().getEntityName(), networkParameter, user, password, "PasswordDigest", useAuthorization);
                        try {
                            this.canon2Core.init(onvifDevice, this.logger.isDebugEnabled());
                            return this.canon2Core;
                        }
                        catch (OnvifException onvifException) {
                            this.canon2Core.shutdown();
                            throw new SeeTecException(onvifException.getErrorCode(), onvifException.getCause().getMessage());
                        }
                    }
                    return this.canon2Core;
                }
                throw new SeeTecException(-21601, "NetworkParameters are null");
            }
            catch (ConfigurationException exception) {
                this.logger.error("Problems while initializing ONVIF Core", (Throwable)exception);
                return null;
            }
        }
    }

    public Canon2EventHandler getGenericOnvifEventHandler() {
        if (this.canon2EventHandler == null) {
            try {
                this.canon2EventHandler = new Canon2EventHandler();
                this.canon2EventHandler.init(this.getOnvifCore(), this);
            }
            catch (SeeTecException exception) {
                this.logger.warn("GenericOnvifEventHandler could not be initialized", (Throwable)exception);
            }
        }
        return this.canon2EventHandler;
    }

    @Override
    public int shutdown() {
        if (this.canon2EventHandler != null) {
            this.canon2EventHandler.shutdown();
            this.canon2EventHandler = null;
        }
        return super.shutdown();
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

