/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.canon;

import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.video.canon.CanonDevice;
import java.util.List;
import org.onvif.ver10.deviceio.wsdl.DeviceIOPort;
import org.onvif.ver10.schema.RelayLogicalState;
import org.onvif.ver10.schema.RelayOutput;

public class CanonIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.canon.CanonIOHandler";
    private DeviceIOPort deviceIOservice = null;
    private int errorCode = 0;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public int writeDigitalOutput(int nOutputNumber, int value, long holdTime) {
        CanonDevice canonDevice = (CanonDevice)this.device;
        if (canonDevice.isOnvifDevice()) {
            OnvifCore onvifCore = canonDevice.getOnvifCore();
            this.deviceIOservice = onvifCore.getDeviceIoService().getOnvifDeviceIoService();
            DigitalOutputSrv service = super.getDigitalOutputSrv(nOutputNumber);
            if (service == null) {
                this.errorCode = -21601;
                return this.errorCode;
            }
            if (value < 0) {
                this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
                this.errorCode = -21601;
                return this.errorCode;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Writing value [" + value + "] to output [" + nOutputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
            }
            try {
                IOHandler.HoldTimer holdTimer;
                this.logger.info("holdTime: " + holdTime);
                this.logger.info("value: " + value);
                List relayOutputs = this.deviceIOservice.getRelayOutputs();
                RelayOutput relayOutput = (RelayOutput)relayOutputs.get(nOutputNumber - 1);
                RelayLogicalState relayLogicalState = value > 0 ? RelayLogicalState.ACTIVE : RelayLogicalState.INACTIVE;
                this.deviceIOservice.setRelayOutputState(relayOutput.getToken(), relayLogicalState);
                if (holdTime > 0L && (this.errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nOutputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                    holdTimer.shutdown();
                    this.logger.warn("Creating " + holdTimer + " failed with error [" + this.errorCode + "] :-(");
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
                this.logger.warn("Problems setting output [" + nOutputNumber + "] of " + this + " :-(");
            }
        }
        return this.errorCode;
    }
}

