/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;

public class VideoInputFormatExXML
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpXml.VideoInputFormatExXML";
    private int videoFormatMode;
    private int videoFormatID;
    private int imageRotation;

    public int getVideoFormatMode() {
        return this.videoFormatMode;
    }

    public void setVideoSource(int videoSource) {
        this.num = videoSource;
    }

    public void setVideoFormatMode(int videoFormatMode) {
        this.videoFormatMode = videoFormatMode;
    }

    public int getVideoFormatID() {
        return this.videoFormatID;
    }

    public void setVideoFormatID(int videoFormatID) {
        this.videoFormatID = videoFormatID;
    }

    public int getImageRotation() {
        return this.imageRotation;
    }

    public void setImageRotation(int imageRotation) {
        this.imageRotation = imageRotation;
    }

    public VideoInputFormatExXML() {
        this.command = Command.CMD_CONF_VIDEO_INPUT_FORMAT_EX;
        this.type = Type.TYPE_P_OCTET;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            byte[] payloadBytes = new byte[20];
            payloadBytes[0] = (byte)this.videoFormatMode;
            payloadBytes[1] = (byte)this.videoFormatID;
            payloadBytes[2] = (byte)this.imageRotation;
            this.payload = "0x" + Basic.byteArrayToHexString((byte[])payloadBytes);
        }
        super.send(device, direction);
        String videoInputData = this.getResultAsString().replace(" ", "").replace("\r", "").replace("\n", "");
        byte[] videoInput = Basic.hexStringToByteArray((String)videoInputData);
        this.videoFormatMode = videoInput[0];
        this.videoFormatID = videoInput[1];
        this.imageRotation = videoInput[2];
    }
}

