/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;

public class Mpeg4ResolutionXML
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpX.Mpeg4ResolutionXML";
    private int value = -1;
    private int width = -1;
    private int height = -1;

    public void setResolution(int resolution) {
        this.value = resolution;
    }

    public int getResolution() {
        return this.value;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Mpeg4ResolutionXML() {
        this.command = Command.CMD_MPEG4_RESOLUTION;
        this.type = Type.TYPE_T_DWORD;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            if (this.value == -1) {
                if (this.width == -1) {
                    throw new SeeTecException(-20037, "Resolution " + this.value + " not valid for " + this);
                }
                this.setPayload(this.getResolutionString(this.width, this.height));
            } else {
                this.setPayload(Integer.toString(this.value));
            }
        }
        super.send(device, direction);
        if (this.value == -1) {
            int res = this.getResultAsInt();
            byte[] widthHeight = Basic.int4ToByteArray((int)res);
            if (widthHeight.length == 4) {
                this.width = Basic.byteArrayToInt4((byte[])widthHeight, (int)0, (int)2);
                this.height = Basic.byteArrayToInt4((byte[])widthHeight, (int)2, (int)2);
            }
        } else {
            this.value = this.getResultAsInt();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\r\nMPEG4 Resolution: " + this.value;
    }

    private String getResolutionString(int width, int height) {
        String resolutionWidth = Integer.toHexString(width);
        while (resolutionWidth.length() < 4) {
            resolutionWidth = "0" + resolutionWidth;
        }
        String resolutionHeight = Integer.toHexString(height);
        while (resolutionHeight.length() < 4) {
            resolutionHeight = "0" + resolutionHeight;
        }
        return "0x" + resolutionWidth + resolutionHeight;
    }
}

