/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;

public class JpegStreamSetupXML
extends PacketXML {
    private int resolutionValue = -1;
    private int fpsValue = -1;
    private int qualityValue = -1;
    private boolean inverted;

    public final void setResolution(int resolution) {
        this.resolutionValue = resolution;
    }

    public final void setFPS(int fps) {
        this.fpsValue = fps;
    }

    public final void setQuality(int quality) {
        this.qualityValue = quality;
    }

    public final int getResolution() {
        return this.resolutionValue;
    }

    public final int getFPS() {
        return this.fpsValue;
    }

    public final int getQuality() {
        return this.qualityValue;
    }

    public JpegStreamSetupXML() {
        this.command = Command.CMD_CONF_JPEG_STREAM_SETUP;
        this.type = Type.TYPE_P_OCTET;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            if (this.payload == null && (this.resolutionValue == -1 || this.fpsValue == -1 || this.qualityValue == -1)) {
                throw new SeeTecException(-20037, "JPEG parameters not valid for " + this);
            }
            this.payload = this.inverted ? "0x" + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)(0x1000000 + this.resolutionValue))) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.fpsValue)) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.qualityValue)) : "0x" + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.resolutionValue)) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.fpsValue)) + Basic.byteArrayToHexString((byte[])Basic.int4ToByteArray((int)this.qualityValue));
        }
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length > 0) {
            byte[] resolutionData = new byte[4];
            byte[] fpsData = new byte[4];
            byte[] qualityData = new byte[4];
            System.arraycopy(data, 0, resolutionData, 0, 4);
            System.arraycopy(data, 4, fpsData, 0, 4);
            System.arraycopy(data, 8, qualityData, 0, 4);
            this.resolutionValue = Packet.bytesToInt(resolutionData);
            this.fpsValue = Packet.bytesToInt(fpsData);
            this.qualityValue = Packet.bytesToInt(qualityData);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\r\nJPEG Stream Setup: \r\n\tResolution Tag: " + this.resolutionValue + "\r\n\tFPS Value: " + this.fpsValue + "\r\n\tQuality Value: " + this.qualityValue;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }
}

