/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.shared.Resolution;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class JpegStreamSetupOptionsVerboseXML
extends PacketXML {
    private final List<Resolution> resolutionList = new ArrayList<Resolution>();

    public JpegStreamSetupOptionsVerboseXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_CONF_JPEG_STREAM_SETUP_OPTIONS_VERBOSE;
    }

    public List<Resolution> getResolutions() {
        return this.resolutionList;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length >= 20) {
            for (int offset = 0; offset < data.length; offset += 20) {
                int width = (int)Basic.byteArrayToInt8((byte[])data, (int)(offset + 8), (int)4);
                int height = (int)Basic.byteArrayToInt8((byte[])data, (int)(offset + 12), (int)4);
                int id = (int)Basic.byteArrayToInt8((byte[])data, (int)(offset + 4), (int)4);
                Resolution jpegResolution = new Resolution(id, width, height, String.valueOf(width) + "x" + String.valueOf(height));
                this.resolutionList.add(jpegResolution);
            }
        }
        Collections.sort(this.resolutionList, new JPEGResolutionComparator());
    }

    private static class JPEGResolutionComparator
    implements Comparator<Resolution>,
    Serializable {
        private static final long serialVersionUID = 3941345901702932490L;

        private JPEGResolutionComparator() {
        }

        @Override
        public int compare(Resolution res1, Resolution res2) {
            int result = res1.getWidth().compareTo(res2.getWidth());
            if (result == 0) {
                result = res1.getHeight().compareTo(res2.getHeight());
            }
            return result;
        }
    }
}

