/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.BoschResolution;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfEncBaseOperationModeType;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.OperationMode;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.ResolutionComparator;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class H264EncBaseOperationModeCapsXML
extends PacketXML {
    public List<OperationMode> operationModes = new ArrayList<OperationMode>();

    public List<OperationMode> getOperationModes() {
        return this.operationModes;
    }

    public H264EncBaseOperationModeCapsXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_H264_ENC_BASE_OPERATION_MODE_CAPS;
    }

    private boolean containsResolution(List<BoschResolution> res, BoschResolution resolution) {
        for (BoschResolution r : res) {
            if (r.getWidth().intValue() != resolution.getWidth().intValue() || r.getHeight().intValue() != resolution.getHeight().intValue() || !r.getName().equals(resolution.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        super.send(device, direction);
        ConfEncBaseOperationModeType confEncBaseOperationModeType = new ConfEncBaseOperationModeType();
        try {
            confEncBaseOperationModeType.send(device, Direction.READ);
        }
        catch (Exception ex) {
            this.logger.warn("Operation Mode Types not supported for " + this);
        }
        int operationModeType = confEncBaseOperationModeType.getOperationModeType();
        byte[] data = this.getResultAsByteArray();
        if (operationModeType == 1 || operationModeType == -1) {
            if (data != null && data.length > 4) {
                for (int offset = 4; offset < data.length; offset += 8) {
                    byte[] resolutionData = new byte[8];
                    System.arraycopy(data, offset, resolutionData, 0, 8);
                    this.operationModes.add(new OperationMode(resolutionData, operationModeType));
                }
            }
        } else if (data != null && data.length > 4) {
            this.operationModes.add(new OperationMode(data, operationModeType));
        }
    }

    public List<BoschResolution> getResolutions(int streamNumber) {
        ArrayList<BoschResolution> res = new ArrayList<BoschResolution>();
        for (OperationMode om : this.operationModes) {
            BoschResolution resolution = om.getResolution(streamNumber);
            if (resolution == null || this.containsResolution(res, resolution)) continue;
            res.add(resolution);
        }
        Collections.sort(res, new ResolutionComparator());
        return res;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder("Resolution Modes:\r\n");
        List<OperationMode> opModes = this.getOperationModes();
        if (opModes != null) {
            for (OperationMode om : opModes) {
                if (om.getResolution(1) != null) {
                    ret.append("\t Stream1: ").append(om.getResolution(1).getWidth()).append("x").append(om.getResolution(1).getHeight().byteValue());
                }
                if (om.getResolution(2) == null) continue;
                ret.append("\tStream2: ").append(om.getResolution(2).getWidth()).append("x").append(om.getResolution(2).getHeight()).append("\r\n");
            }
        }
        return super.toString() + "\r\n" + ret.toString();
    }
}

