/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;

public class EncodeCurrentResolutionXML
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpXml.EncodeCurrentResolutionXML";
    private byte videoSource;
    private byte streamNumber;
    private int width;
    private int height;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setVideoSource(byte videoSource) {
        this.videoSource = videoSource;
    }

    public void setStreamNumber(byte streamNumber) {
        this.streamNumber = streamNumber;
    }

    public EncodeCurrentResolutionXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_ENCODE_CURRENT_RESOLUTION;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        byte[] sourceAndstream = new byte[]{this.videoSource, this.streamNumber};
        this.payload = "0x" + Basic.byteArrayToHexString((byte[])sourceAndstream);
        super.send(device, direction);
        byte[] res = this.getResultAsByteArray();
        this.width = (int)Basic.byteArrayToInt8((byte[])res, (int)2, (int)2);
        this.height = (int)Basic.byteArrayToInt8((byte[])res, (int)4, (int)2);
    }

    @Override
    public String toString() {
        return super.toString() + "\r\nResolution: " + this.width + "x" + this.height;
    }
}

