/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.DeviceCapabilityEntry;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import java.util.HashMap;

public class DeviceCapabilitiesXML
extends PacketXML {
    private final HashMap<String, DeviceCapabilityEntry> entriesByName = new HashMap();
    private final HashMap<Integer, DeviceCapabilityEntry> entriesByNumber = new HashMap();

    public DeviceCapabilitiesXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_DEVICE_CAPABILITIES;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length >= 4) {
            int lengthOfEntry;
            for (int pointer = 4; pointer < data.length; pointer += 4 + lengthOfEntry) {
                lengthOfEntry = (int)Basic.byteArrayToInt8((byte[])data, (int)(pointer + 2), (int)2);
                byte[] entryData = new byte[4 + lengthOfEntry];
                System.arraycopy(data, pointer, entryData, 0, entryData.length);
                DeviceCapabilityEntry entry = new DeviceCapabilityEntry(entryData);
                this.entriesByName.put(entry.getTagName(), entry);
                this.entriesByNumber.put(entry.getTagNumber(), entry);
            }
        }
    }

    public DeviceCapabilityEntry getEntryByTagName(String tagName) {
        return this.entriesByName.get(tagName);
    }

    public DeviceCapabilityEntry getEntryByNumber(int tagNumber) {
        return this.entriesByNumber.get(tagNumber);
    }

    public static enum DataTypeEnum {
        Integer,
        ByteArray,
        Boolean,
        String;

    }
}

