/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import java.util.HashMap;
import java.util.Map;

public class ConfRcpCoderListXML
extends PacketXML {
    Map<Integer, Integer> coders = new HashMap<Integer, Integer>();

    public ConfRcpCoderListXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_CODER_LIST;
    }

    public int getCoderNumber(int streamNumber) {
        return this.coders.get(streamNumber);
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Capabilities is not allowed");
        }
        this.payload = "0x010001";
        super.send(device, direction);
        byte[] data = this.getResultAsByteArray();
        if (data != null && data.length > 0) {
            this.fillData(data);
        }
    }

    public void setVideoSource(int videoSource) {
        this.num = videoSource;
    }

    public Map<Integer, Integer> getCoders() {
        return this.coders;
    }

    public void fillData(byte[] inputData) {
        for (int i = 0; i < inputData.length / 16; ++i) {
            int coder = Basic.byteArrayToInt4((byte[])inputData, (int)(i * 16), (int)2);
            this.coders.put(i, coder);
        }
    }
}

